/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.util.BitSet;
import java.util.HashMap;
import morfologik.fsa.FSA;

public final class FSAInfo {
    public final int nodeCount;
    public final int arcsCount;
    public final int arcsCountTotal;
    public final int finalStatesCount;

    public FSAInfo(FSA fSA) {
        NodeVisitor nodeVisitor = new NodeVisitor(fSA);
        int n = fSA.getRootNode();
        if (n > 0) {
            nodeVisitor.visitNode(n);
        }
        this.nodeCount = 1 + nodeVisitor.nodes;
        this.arcsCount = 1 + nodeVisitor.arcs;
        this.arcsCountTotal = 1 + nodeVisitor.totalArcs;
        FinalStateVisitor finalStateVisitor = new FinalStateVisitor(fSA);
        this.finalStatesCount = finalStateVisitor.visitNode(fSA.getRootNode());
    }

    private static class FinalStateVisitor {
        final HashMap<Integer, Integer> visitedNodes = new HashMap();
        private final FSA fsa;

        FinalStateVisitor(FSA fSA) {
            this.fsa = fSA;
        }

        public int visitNode(int n) {
            Integer n2 = this.visitedNodes.get(n);
            if (n2 != null) {
                return n2;
            }
            int n3 = 0;
            int n4 = this.fsa.getFirstArc(n);
            while (n4 != 0) {
                if (this.fsa.isArcFinal(n4)) {
                    ++n3;
                }
                if (!this.fsa.isArcTerminal(n4)) {
                    n3 += this.visitNode(this.fsa.getEndNode(n4));
                }
                n4 = this.fsa.getNextArc(n4);
            }
            this.visitedNodes.put(n, n3);
            return n3;
        }
    }

    private static class NodeVisitor {
        final BitSet visitedArcs = new BitSet();
        final BitSet visitedNodes = new BitSet();
        int nodes;
        int arcs;
        int totalArcs;
        private final FSA fsa;

        NodeVisitor(FSA fSA) {
            this.fsa = fSA;
        }

        public void visitNode(int n) {
            if (this.visitedNodes.get(n)) {
                return;
            }
            this.visitedNodes.set(n);
            ++this.nodes;
            int n2 = this.fsa.getFirstArc(n);
            while (n2 != 0) {
                if (!this.visitedArcs.get(n2)) {
                    ++this.arcs;
                }
                ++this.totalArcs;
                this.visitedArcs.set(n2);
                if (!this.fsa.isArcTerminal(n2)) {
                    this.visitNode(this.fsa.getEndNode(n2));
                }
                n2 = this.fsa.getNextArc(n2);
            }
        }
    }
}

