/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.nio.ByteBuffer;
import java.util.Iterator;
import morfologik.fsa.FSA;
import morfologik.fsa.FSAFinalStatesIterator;
import morfologik.fsa.FSAMatch;
import morfologik.fsa.FSAMatchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FSATraversalHelper {
    private final FSA fsa;

    FSATraversalHelper(FSA fSA) {
        this.fsa = fSA;
    }

    public Iterator<ByteBuffer> getAllSubsequences(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Node cannot be zero.");
        }
        return new FSAFinalStatesIterator(this.fsa, n);
    }

    public FSAFinalStatesIterator getFinalStatesIterator() {
        return new FSAFinalStatesIterator(this.fsa, this.fsa.getRootNode());
    }

    public FSAMatch matchSequence(FSAMatch fSAMatch, byte[] byArray, int n, int n2, int n3) {
        if (n3 == 0) {
            fSAMatch.reset(FSAMatchType.NO_MATCH);
            return fSAMatch;
        }
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            int n5 = this.fsa.getArc(n3, byArray[i]);
            if (n5 != 0) {
                if (this.fsa.isArcFinal(n5)) {
                    if (i + 1 == n4) {
                        fSAMatch.reset(FSAMatchType.EXACT_MATCH);
                        return fSAMatch;
                    }
                    fSAMatch.reset(FSAMatchType.PREMATURE_PATH_END_FOUND, i + 1, 0);
                    return fSAMatch;
                }
            } else {
                fSAMatch.reset(FSAMatchType.PREFIX_FOUND, i, n3);
                return fSAMatch;
            }
            n3 = this.fsa.getEndNode(n5);
        }
        fSAMatch.reset(FSAMatchType.PREMATURE_WORD_END_FOUND, 0, n3);
        return fSAMatch;
    }

    public FSAMatch matchSequence(byte[] byArray, int n, int n2, int n3) {
        return this.matchSequence(new FSAMatch(), byArray, n, n2, n3);
    }

    public FSAMatch matchSequence(byte[] byArray, int n) {
        return this.matchSequence(byArray, 0, byArray.length, n);
    }

    public FSAMatch matchSequence(byte[] byArray) {
        return this.matchSequence(byArray, this.fsa.getRootNode());
    }
}

