/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.WeakHashMap;
import morfologik.fsa.FSA;
import morfologik.stemming.DictionaryMetadata;
import morfologik.util.FileUtils;
import morfologik.util.ResourceUtils;

public final class Dictionary {
    public static final String METADATA_FILE_EXTENSION = "info";
    public final FSA fsa;
    public final DictionaryMetadata metadata;
    public static final WeakHashMap<String, Dictionary> defaultDictionaries = new WeakHashMap();

    public Dictionary(FSA fSA, DictionaryMetadata dictionaryMetadata) {
        this.fsa = fSA;
        this.metadata = dictionaryMetadata;
    }

    public static Dictionary read(File file) throws IOException {
        File file2 = new File(file.getParent(), Dictionary.getExpectedFeaturesName(file.getName()));
        FileUtils.assertExists(file2, true, false);
        return Dictionary.readAndClose(new FileInputStream(file), new FileInputStream(file2));
    }

    public static Dictionary read(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        String string2 = Dictionary.getExpectedFeaturesName(string);
        return Dictionary.readAndClose(ResourceUtils.openInputStream(string), ResourceUtils.openInputStream(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dictionary readAndClose(InputStream inputStream, InputStream inputStream2) throws IOException {
        Dictionary dictionary;
        try {
            Properties properties = new Properties();
            properties.load(inputStream2);
            DictionaryMetadata dictionaryMetadata = DictionaryMetadata.fromMap(properties);
            FSA fSA = FSA.getInstance(inputStream);
            dictionary = new Dictionary(fSA, dictionaryMetadata);
        }
        catch (Throwable throwable) {
            FileUtils.close(inputStream, inputStream2);
            throw throwable;
        }
        FileUtils.close(inputStream, inputStream2);
        return dictionary;
    }

    public static String getExpectedFeaturesName(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n >= 0 ? string.substring(0, n) + "." + METADATA_FILE_EXTENSION : string + "." + METADATA_FILE_EXTENSION;
        return string2;
    }

    public static Dictionary getForLanguage(String string) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("Language code must not be empty.");
        }
        WeakHashMap<String, Dictionary> weakHashMap = defaultDictionaries;
        synchronized (weakHashMap) {
            Dictionary dictionary = defaultDictionaries.get(string);
            if (dictionary != null) {
                return dictionary;
            }
            try {
                String string2 = "/morfologik/dictionaries/" + string + ".dict";
                String string3 = Dictionary.getExpectedFeaturesName(string2);
                dictionary = Dictionary.readAndClose(ResourceUtils.openInputStream(string2), ResourceUtils.openInputStream(string3));
                defaultDictionaries.put(string, dictionary);
                return dictionary;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Default dictionary resource for language '" + string + "not found.", iOException);
            }
        }
    }
}

