/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import morfologik.fsa.CFSA;
import morfologik.fsa.FSA;
import morfologik.fsa.FSA5;
import morfologik.fsa.FSAInfo;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import morfologik.tools.SharedOptions;
import morfologik.tools.Tool;
import morfologik.util.FileUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public final class DumpTool
extends Tool {
    private OutputStream writer;
    private boolean dataOnly;
    private boolean decode;

    protected void go(CommandLine commandLine) throws Exception {
        File file = (File)commandLine.getParsedOptionValue(SharedOptions.fsaDictionaryFileOption.getOpt());
        this.dataOnly = commandLine.hasOption(SharedOptions.dataOnly.getOpt());
        this.decode = commandLine.hasOption(SharedOptions.decode.getOpt());
        FileUtils.assertExists(file, true, false);
        this.dump(file, this.dataOnly);
    }

    private void dump(File file, boolean bl) throws UnsupportedEncodingException, IOException {
        Object object;
        FSA fSA;
        Dictionary dictionary;
        long l = System.currentTimeMillis();
        if (!file.canRead()) {
            this.printWarning("Dictionary file does not exist: " + file.getAbsolutePath());
            return;
        }
        this.writer = new BufferedOutputStream(System.out, 32768);
        if (DumpTool.hasMetadata(file)) {
            dictionary = Dictionary.read(file);
            fSA = dictionary.fsa;
            object = dictionary.metadata.encoding;
            if (!Charset.isSupported((String)object)) {
                this.printWarning("Dictionary's charset is not supported on this JVM: " + (String)object);
                return;
            }
        } else {
            dictionary = null;
            fSA = FSA.getInstance(new FileInputStream(file));
            this.printWarning("Warning: FSA automaton without metadata file.");
        }
        this.printExtra("FSA properties");
        this.printExtra("--------------------");
        this.printExtra("FSA implementation  : " + fSA.getClass().getName());
        this.printExtra("Compiled with flags : " + fSA.getFlags().toString());
        if (!bl) {
            object = new FSAInfo(fSA);
            this.printExtra("Number of arcs      : " + ((FSAInfo)object).arcsCount + "/" + ((FSAInfo)object).arcsCountTotal);
            this.printExtra("Number of nodes     : " + ((FSAInfo)object).nodeCount);
            this.printExtra("Number of final st. : " + ((FSAInfo)object).finalStatesCount);
            this.printExtra("");
        }
        char c = ' ';
        if (fSA instanceof FSA5) {
            this.printExtra("FSA5 properties");
            this.printExtra("--------------------");
            this.printFSA5((FSA5)fSA);
            if (dictionary != null) {
                c = this.byteAsChar(((FSA5)fSA).annotation, dictionary.metadata.encoding);
            }
            this.printExtra("");
        }
        if (fSA instanceof CFSA) {
            this.printExtra("CFSA properties");
            this.printExtra("--------------------");
            this.printCFSA((CFSA)fSA);
            this.printExtra("");
        }
        if (dictionary != null) {
            this.printExtra("Dictionary metadata");
            this.printExtra("--------------------");
            this.printExtra("Encoding            : " + dictionary.metadata.encoding);
            this.printExtra("Separator byte      : 0x" + Integer.toHexString(dictionary.metadata.separator) + " ('" + this.decodeSeparator(dictionary) + "')");
            this.printExtra("Uses prefixes       : " + dictionary.metadata.usesPrefixes);
            this.printExtra("Uses infixes        : " + dictionary.metadata.usesInfixes);
            this.printExtra("");
            this.printExtra("Dictionary metadata (all keys)");
            this.printExtra("---------------------------------");
            for (Map.Entry<String, String> entry : dictionary.metadata.metadata.entrySet()) {
                this.printExtra(String.format("%-27s : %s", entry.getKey(), entry.getValue()));
            }
            this.printExtra("");
        }
        int n = 0;
        if (this.decode) {
            Map.Entry<String, String> entry;
            if (dictionary == null) {
                this.printWarning("No dictionary metadata available.");
                return;
            }
            this.printExtra("Decoded FSA data (in the encoding above)");
            this.printExtra("----------------------------------------");
            entry = new DictionaryLookup(dictionary);
            StringBuilder stringBuilder = new StringBuilder();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.writer, dictionary.metadata.encoding);
            Iterator<WordData> iterator = ((DictionaryLookup)((Object)entry)).iterator();
            while (iterator.hasNext()) {
                WordData wordData = iterator.next();
                stringBuilder.setLength(0);
                stringBuilder.append(wordData.getWord());
                stringBuilder.append(c);
                CharSequence charSequence = wordData.getStem();
                if (charSequence == null) {
                    charSequence = "";
                }
                stringBuilder.append(charSequence);
                stringBuilder.append(c);
                charSequence = wordData.getTag();
                if (charSequence == null) {
                    charSequence = "";
                }
                stringBuilder.append(charSequence);
                stringBuilder.append('\n');
                outputStreamWriter.write(stringBuilder.toString());
                ++n;
            }
            outputStreamWriter.flush();
        } else {
            this.printExtra("FSA data (raw bytes in the encoding above)");
            this.printExtra("------------------------------------------");
            for (ByteBuffer byteBuffer : fSA) {
                this.writer.write(byteBuffer.array(), 0, byteBuffer.remaining());
                this.writer.write(10);
                ++n;
            }
        }
        this.printExtra("--------------------");
        long l2 = Math.max(1L, System.currentTimeMillis() - l);
        this.printExtra(String.format(Locale.ENGLISH, "Dictionary dumped in %.3f second(s), %d sequences (%d sequences/sec.).", (double)l2 / 1000.0, n, (int)((double)n / ((double)l2 / 1000.0))));
        this.writer.flush();
    }

    private char byteAsChar(byte by, String string) {
        try {
            String string2 = new String(new byte[]{by}, string);
            if (string2.length() != 1) {
                throw new RuntimeException("Unexpected annotation character length (should be 1): " + string2.length());
            }
            return string2.charAt(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private void printCFSA(CFSA cFSA) throws IOException {
        this.printExtra("GTL                 : " + cFSA.gtl);
        this.printExtra("Node extra data     : " + cFSA.nodeDataLength);
        this.printExtra("Label mapping       : " + this.bytesAsChars(cFSA.labelMapping));
    }

    private String bytesAsChars(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = this.byteAsChar(byArray[i]);
        }
        return new String(cArray);
    }

    private void printFSA5(FSA5 fSA5) throws IOException {
        this.printExtra("GTL                 : " + fSA5.gtl);
        this.printExtra("Node extra data     : " + fSA5.nodeDataLength);
        this.printExtra("Annotation separator: " + this.byteAsChar(fSA5.annotation));
        this.printExtra("Filler character    : " + this.byteAsChar(fSA5.filler));
    }

    private char byteAsChar(byte by) {
        char c = (char)(by & 0xFF);
        if (c < '\u007f') {
            return c;
        }
        return '?';
    }

    private void printExtra(String string) throws IOException {
        if (this.dataOnly) {
            return;
        }
        this.writer.write(string.getBytes());
        this.writer.write(10);
    }

    private void printWarning(String string) throws IOException {
        System.err.println(string);
    }

    private String decodeSeparator(Dictionary dictionary) {
        try {
            return new String(new byte[]{dictionary.metadata.separator}, dictionary.metadata.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "<unsupported encoding: " + dictionary.metadata.encoding + ">";
        }
    }

    private static boolean hasMetadata(File file) {
        File file2 = new File(file.getParent(), Dictionary.getExpectedFeaturesName(file.getName()));
        return file2.canRead();
    }

    protected void initializeOptions(Options options) {
        options.addOption(SharedOptions.fsaDictionaryFileOption);
        options.addOption(SharedOptions.dataOnly);
        options.addOption(SharedOptions.decode);
    }

    public static void main(String[] stringArray) throws Exception {
        DumpTool dumpTool = new DumpTool();
        dumpTool.go(stringArray);
    }
}

