/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import java.lang.reflect.Method;
import java.util.TreeMap;
import morfologik.tools.DumpTool;
import morfologik.tools.FSA2CFSA;
import morfologik.tools.PolishStemmingTool;
import morfologik.tools.Tool;

public final class Launcher {
    static TreeMap<String, ToolInfo> tools = new TreeMap();

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Provide tool name and its command-line options. Available tools:");
            for (String string : tools.keySet()) {
                ToolInfo toolInfo = tools.get(string);
                System.out.println(String.format("  %-10s - %s", string, toolInfo.info));
            }
        } else {
            String string = stringArray[0];
            if (!tools.containsKey(string)) {
                System.out.println("Unknown tool: " + string);
                return;
            }
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            ToolInfo toolInfo = tools.get(string);
            toolInfo.invoke(stringArray2);
        }
    }

    static {
        tools.put("dump", new ToolInfo(DumpTool.class, "Dump an FSA dictionary."));
        tools.put("plstem", new ToolInfo(PolishStemmingTool.class, "Apply Polish stemming to the input."));
        tools.put("fsa2cfsa", new ToolInfo(FSA2CFSA.class, "Convert FSA5 to CFSA."));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ToolInfo {
        public final Class<? extends Tool> clazz;
        public final String info;

        public ToolInfo(Class<? extends Tool> clazz, String string) {
            this.clazz = clazz;
            this.info = string;
        }

        public void invoke(String[] stringArray) throws Exception {
            Method method = this.clazz.getMethod("main", String[].class);
            method.invoke(null, new Object[]{stringArray});
        }
    }
}

