/*
 * Decompiled with CFR 0.152.
 */
package morfologik.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class FileUtils {
    private FileUtils() {
    }

    public static void assertExists(File file, boolean bl, boolean bl2) throws IOException {
        if (!file.exists()) {
            throw new IOException("File does not exist: " + file.getAbsolutePath());
        }
        if (!(!bl || file.isFile() && file.canRead())) {
            throw new IOException("File cannot be read: " + file.getAbsolutePath());
        }
        if (bl2 && !file.isDirectory()) {
            throw new IOException("Not a directory: " + file.getAbsolutePath());
        }
    }

    public static void close(Closeable ... closeableArray) {
        for (Closeable closeable : closeableArray) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        while ((n = inputStream.read(byArray, n2, byArray.length - n2)) > 0 && (n2 += n) != byArray.length) {
        }
        if (n < 0) {
            throw new EOFException();
        }
    }

    public static int readInt(InputStream inputStream) throws IOException {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n = n << 8 | FileUtils.readByte(inputStream);
        }
        return n;
    }

    public static byte readByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }
}

