/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryIterator;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;

public class InflectionFramesTool {
    public static void main(String[] args) throws IOException {
        new InflectionFramesTool().inflectionFrames();
    }

    public void inflectionFrames() throws IOException {
        Dictionary pl = Dictionary.getForLanguage("pl");
        DictionaryLookup dict = new DictionaryLookup(pl);
        CharsetDecoder decoder = Charset.forName(pl.metadata.encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        HashMap<String, ArrayList<String>> forms = new HashMap<String, ArrayList<String>>();
        ByteBuffer stemBuffer = ByteBuffer.allocate(0);
        ByteBuffer inflBuffer = ByteBuffer.allocate(0);
        ByteBuffer stemDecoded = ByteBuffer.allocate(0);
        int limit = Integer.MAX_VALUE;
        DictionaryIterator i = new DictionaryIterator(pl, decoder, false);
        while (i.hasNext() && limit-- > 0) {
            WordData wd = (WordData)i.next();
            CharSequence inflected = wd.getWord();
            CharSequence stemEncoded = wd.getStem();
            CharSequence tag = wd.getTag();
            if (tag == null) continue;
            inflBuffer.clear();
            inflBuffer = wd.getWordBytes(inflBuffer);
            stemBuffer.clear();
            stemBuffer = wd.getStemBytes(stemBuffer);
            stemDecoded = DictionaryLookup.decodeStem(stemDecoded, stemBuffer.array(), stemBuffer.remaining(), inflBuffer, pl.metadata);
            stemDecoded.flip();
            String string = decoder.decode(stemDecoded).toString();
            String form = ((Object)tag).toString().intern();
            ArrayList<String> frames = (ArrayList<String>)forms.get(string);
            if (frames == null) {
                frames = new ArrayList<String>();
                forms.put(string, frames);
            }
            if (frames.contains(form)) continue;
            frames.add(form);
        }
        HashMap frames = new HashMap();
        StringBuilder key = new StringBuilder();
        for (Map.Entry e : forms.entrySet()) {
            Collections.sort((List)e.getValue());
            key.setLength(0);
            for (String s : (ArrayList)e.getValue()) {
                key.append(s).append(" ");
            }
            String string = key.toString();
            ArrayList words = (ArrayList)frames.get(string);
            if (words == null) {
                words = new ArrayList();
                frames.put(string, words);
            }
            words.add(e.getKey());
            e.setValue(null);
        }
        ArrayList entries = new ArrayList();
        entries.addAll(frames.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, ArrayList<String>>>(){

            @Override
            public int compare(Map.Entry<String, ArrayList<String>> o1, Map.Entry<String, ArrayList<String>> o2) {
                return o2.getValue().size() - o1.getValue().size();
            }
        });
        for (Map.Entry entry : entries) {
            System.out.println(String.format("%6d   %s %s", ((ArrayList)entry.getValue()).size(), entry.getKey(), entry.getValue()));
        }
        System.out.println("Total frames: " + frames.size());
    }
}

