/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import morfologik.stemming.PolishStemmer;
import morfologik.stemming.WordData;
import morfologik.tools.SharedOptions;
import morfologik.tools.Tool;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

class PolishStemmingTool
extends Tool {
    PolishStemmingTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void go(CommandLine line) throws Exception {
        String inputEncoding = this.getEncodingOption(line, SharedOptions.inputEncodingOption.getOpt());
        String outputEncoding = this.getEncodingOption(line, SharedOptions.outputEncodingOption.getOpt());
        System.out.println("Input encoding: " + inputEncoding);
        System.out.println("Output encoding: " + outputEncoding);
        Reader input = this.initializeInput(line, inputEncoding);
        Writer output = this.initializeOutput(line, outputEncoding);
        long start = System.currentTimeMillis();
        try {
            long count = this.process(input, output);
            output.flush();
            long millis = System.currentTimeMillis() - start;
            double time = (double)millis / 1000.0;
            double wordsPerSec = time > 0.0 ? (double)count / time : Double.POSITIVE_INFINITY;
            System.out.println(new MessageFormat("Processed {0} words in {1,number,#.###} seconds ({2,number,#} words per second).", Locale.ENGLISH).format(new Object[]{new Long(count), new Double((double)millis / 1000.0), new Double(wordsPerSec)}));
        }
        finally {
            input.close();
            output.close();
        }
    }

    protected long process(Reader input, Writer output) throws IOException {
        int token;
        PolishStemmer stemmer = new PolishStemmer();
        StreamTokenizer st = new StreamTokenizer(input);
        st.eolIsSignificant(false);
        st.wordChars(43, 43);
        long count = 0L;
        while ((token = st.nextToken()) != -1) {
            if (token != -3) continue;
            String word = st.sval;
            ++count;
            List<WordData> stems = stemmer.lookup(word);
            if (stems.size() == 0) {
                output.write(word);
                output.write("\t-\t-\n");
                continue;
            }
            for (WordData wd : stems) {
                output.write(word);
                output.write("\t");
                output.write(this.asString(wd.getStem()));
                output.write("\t");
                output.write(this.asString(wd.getTag()));
                output.write("\n");
            }
        }
        return count;
    }

    private String asString(CharSequence stem) {
        if (stem == null) {
            return "-";
        }
        return ((Object)stem).toString();
    }

    @Override
    protected void initializeOptions(Options options) {
        options.addOption(SharedOptions.inputFileOption);
        options.addOption(SharedOptions.inputEncodingOption);
        options.addOption(SharedOptions.outputFileOption);
        options.addOption(SharedOptions.outputEncodingOption);
    }

    private Writer initializeOutput(CommandLine line, String outputEncoding) throws IOException, ParseException {
        String opt = SharedOptions.outputFileOption.getOpt();
        OutputStreamWriter output = line.hasOption(opt) ? new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream((File)line.getParsedOptionValue(opt))), outputEncoding) : new OutputStreamWriter((OutputStream)System.out, outputEncoding);
        return output;
    }

    private Reader initializeInput(CommandLine line, String inputEncoding) throws IOException, ParseException {
        String opt = SharedOptions.inputFileOption.getOpt();
        InputStreamReader input = line.hasOption(opt) ? new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream((File)line.getParsedOptionValue(opt))), inputEncoding) : new InputStreamReader(System.in, inputEncoding);
        return input;
    }

    private String getEncodingOption(CommandLine line, String opt) {
        String encoding = System.getProperty("file.encoding", "iso-8859-1");
        if (line.hasOption(opt)) {
            encoding = line.getOptionValue(opt);
        }
        return encoding;
    }

    @Override
    protected boolean isAvailable() {
        boolean available = true;
        try {
            new PolishStemmer();
        }
        catch (Throwable t) {
            available = false;
        }
        return available;
    }

    public static void main(String[] args) throws Exception {
        PolishStemmingTool tool = new PolishStemmingTool();
        tool.go(args);
    }
}

