/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.shaded.guava.common.graph;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.carrot2.shaded.errorprone.annotations.concurrent.LazyInit;
import org.carrot2.shaded.guava.common.base.Preconditions;
import org.carrot2.shaded.guava.common.collect.HashMultiset;
import org.carrot2.shaded.guava.common.collect.ImmutableMap;
import org.carrot2.shaded.guava.common.collect.Multiset;
import org.carrot2.shaded.guava.common.graph.AbstractUndirectedNetworkConnections;
import org.carrot2.shaded.guava.common.graph.MultiEdgesConnecting;
import org.checkerframework.checker.nullness.qual.Nullable;

final class UndirectedMultiNetworkConnections<N, E>
extends AbstractUndirectedNetworkConnections<N, E> {
    @LazyInit
    private transient Reference<Multiset<N>> adjacentNodesReference;

    private UndirectedMultiNetworkConnections(Map<E, N> incidentEdges) {
        super(incidentEdges);
    }

    static <N, E> UndirectedMultiNetworkConnections<N, E> of() {
        return new UndirectedMultiNetworkConnections(new HashMap(2, 1.0f));
    }

    static <N, E> UndirectedMultiNetworkConnections<N, E> ofImmutable(Map<E, N> incidentEdges) {
        return new UndirectedMultiNetworkConnections<N, E>(ImmutableMap.copyOf(incidentEdges));
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(this.adjacentNodesMultiset().elementSet());
    }

    private Multiset<N> adjacentNodesMultiset() {
        Multiset<N> adjacentNodes = UndirectedMultiNetworkConnections.getReference(this.adjacentNodesReference);
        if (adjacentNodes == null) {
            adjacentNodes = HashMultiset.create(this.incidentEdgeMap.values());
            this.adjacentNodesReference = new SoftReference<Multiset<N>>(adjacentNodes);
        }
        return adjacentNodes;
    }

    @Override
    public Set<E> edgesConnecting(final N node) {
        return new MultiEdgesConnecting<E>(this.incidentEdgeMap, node){

            @Override
            public int size() {
                return UndirectedMultiNetworkConnections.this.adjacentNodesMultiset().count(node);
            }
        };
    }

    @Override
    public N removeInEdge(E edge, boolean isSelfLoop) {
        if (!isSelfLoop) {
            return this.removeOutEdge(edge);
        }
        return null;
    }

    @Override
    public N removeOutEdge(E edge) {
        Object node = super.removeOutEdge(edge);
        Multiset<N> adjacentNodes = UndirectedMultiNetworkConnections.getReference(this.adjacentNodesReference);
        if (adjacentNodes != null) {
            Preconditions.checkState(adjacentNodes.remove(node));
        }
        return node;
    }

    @Override
    public void addInEdge(E edge, N node, boolean isSelfLoop) {
        if (!isSelfLoop) {
            this.addOutEdge(edge, node);
        }
    }

    @Override
    public void addOutEdge(E edge, N node) {
        super.addOutEdge(edge, node);
        Multiset<N> adjacentNodes = UndirectedMultiNetworkConnections.getReference(this.adjacentNodesReference);
        if (adjacentNodes != null) {
            Preconditions.checkState(adjacentNodes.add(node));
        }
    }

    private static <T> @Nullable T getReference(@Nullable Reference<T> reference) {
        return reference == null ? null : (T)reference.get();
    }
}

