/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.shaded.guava.common.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import org.carrot2.shaded.guava.common.annotations.Beta;
import org.carrot2.shaded.guava.common.annotations.GwtIncompatible;
import org.carrot2.shaded.guava.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
@GwtIncompatible
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
    }

    @Override
    public boolean accept(@Nullable File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

