/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.shaded.jsr305;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.regex.Pattern;
import org.carrot2.shaded.jsr305.RegEx;
import org.carrot2.shaded.jsr305.meta.TypeQualifier;
import org.carrot2.shaded.jsr305.meta.TypeQualifierValidator;
import org.carrot2.shaded.jsr305.meta.When;

@Documented
@TypeQualifier(applicableTo=String.class)
@Retention(value=RetentionPolicy.RUNTIME)
public @interface MatchesPattern {
    @RegEx
    public String value();

    public int flags() default 0;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Checker
    implements TypeQualifierValidator<MatchesPattern> {
        @Override
        public When forConstantValue(MatchesPattern annotation, Object value) {
            Pattern p = Pattern.compile(annotation.value(), annotation.flags());
            if (p.matcher((String)value).matches()) {
                return When.ALWAYS;
            }
            return When.NEVER;
        }
    }
}

