package com.googlecode.aviator.runtime.type.string;

import java.util.Map;
import com.googlecode.aviator.Expression;

/**
 * A string segment that generated by an expression execution.
 *
 * @author dennis(killme2008@gmail.com)
 *
 */
public class ExpressionSegment implements StringSegment {
  Expression exp;

  public ExpressionSegment(final Expression exp) {
    super();
    this.exp = exp;
  }

  @Override
  public StringBuilder appendTo(final StringBuilder sb, final Map<String, Object> env) {
    return sb.append(this.exp.execute(env));
  }

  @Override
  public String toString() {
    return "ExpressionSegment [exp=" + this.exp + "]";
  }

}
