/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.BaseExpression;
import com.googlecode.aviator.exception.ExpressionNotFoundException;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.lexer.SymbolTable;
import com.googlecode.aviator.runtime.LambdaFunctionBootstrap;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.LambdaFunction;
import com.googlecode.aviator.utils.Env;
import com.googlecode.aviator.utils.Reflector;
import java.util.List;
import java.util.Map;

public abstract class ClassExpression
extends BaseExpression {
    protected Map<String, LambdaFunctionBootstrap> lambdaBootstraps;

    public Map<String, LambdaFunctionBootstrap> getLambdaBootstraps() {
        return this.lambdaBootstraps;
    }

    public void setLambdaBootstraps(Map<String, LambdaFunctionBootstrap> lambdaBootstraps) {
        this.lambdaBootstraps = lambdaBootstraps;
    }

    public ClassExpression(AviatorEvaluatorInstance instance, List<String> varNames, SymbolTable symbolTable) {
        super(instance, varNames, symbolTable);
    }

    public LambdaFunction newLambda(Env env, String name) {
        LambdaFunctionBootstrap bootstrap = this.lambdaBootstraps.get(name);
        if (bootstrap == null) {
            throw new ExpressionNotFoundException("Lambda " + name + " not found");
        }
        return bootstrap.newInstance(env);
    }

    @Override
    public Object executeDirectly(Map<String, Object> env) {
        try {
            Object result = this.execute0((Env)env);
            if (RuntimeUtils.isTracedEval(env)) {
                RuntimeUtils.printlnTrace(env, "Result : " + result);
            }
            return result;
        }
        catch (ExpressionRuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Reflector.sneakyThrow(t);
        }
    }

    public abstract Object execute0(Env var1);

    public Class<?> getJavaClass() {
        return this.getClass();
    }
}

