/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.lexer;

import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.lexer.token.Variable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SymbolTable
implements Serializable {
    private static final long serialVersionUID = -9019014977807517193L;
    private final Map<String, Variable> table = new HashMap<String, Variable>();
    private static final Map<String, Variable> RESERVED = new HashMap<String, Variable>();

    private static void reserveKeyword(Variable v) {
        RESERVED.put(v.getLexeme(), v);
    }

    public static boolean isReservedKeyword(String name) {
        return RESERVED.containsKey(name);
    }

    public static boolean isReservedKeyword(Variable v) {
        return SymbolTable.isReservedKeyword(v.getLexeme());
    }

    public boolean isReserved(String name) {
        return SymbolTable.isReservedKeyword(name) || this.table.containsKey(name);
    }

    public Variable getVariable(String name) {
        Variable var = RESERVED.get(name);
        return var != null ? var : this.table.get(name);
    }

    public Variable reserve(String lexeme) {
        if (this.isReserved(lexeme)) {
            return this.getVariable(lexeme);
        }
        Variable var = new Variable(lexeme, -1);
        this.table.put(lexeme, var);
        return var;
    }

    public Token<?> reserve(Variable variable) {
        String lexeme = variable.getLexeme();
        if (this.isReserved(lexeme)) {
            return this.getVariable(lexeme);
        }
        String name = lexeme;
        this.table.put(name, variable);
        return variable;
    }

    static {
        SymbolTable.reserveKeyword(Variable.TRUE);
        SymbolTable.reserveKeyword(Variable.FALSE);
        SymbolTable.reserveKeyword(Variable.NIL);
        SymbolTable.reserveKeyword(Variable.LAMBDA);
        SymbolTable.reserveKeyword(Variable.FN);
        SymbolTable.reserveKeyword(Variable.END);
        SymbolTable.reserveKeyword(Variable.IF);
        SymbolTable.reserveKeyword(Variable.ELSE);
        SymbolTable.reserveKeyword(Variable.FOR);
        SymbolTable.reserveKeyword(Variable.IN);
        SymbolTable.reserveKeyword(Variable.RETURN);
        SymbolTable.reserveKeyword(Variable.BREAK);
        SymbolTable.reserveKeyword(Variable.CONTINUE);
        SymbolTable.reserveKeyword(Variable.LET);
        SymbolTable.reserveKeyword(Variable.WHILE);
        SymbolTable.reserveKeyword(Variable.ELSIF);
        SymbolTable.reserveKeyword(Variable.TRY);
        SymbolTable.reserveKeyword(Variable.CATCH);
        SymbolTable.reserveKeyword(Variable.FINALLY);
        SymbolTable.reserveKeyword(Variable.THROW);
        SymbolTable.reserveKeyword(Variable.NEW);
    }
}

