/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function;

import com.googlecode.aviator.BaseExpression;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.Env;
import java.util.List;
import java.util.Map;

public abstract class LambdaFunction
extends AbstractFunction {
    private static final long serialVersionUID = -4388339706945053452L;
    protected List<String> arguments;
    protected BaseExpression expression;
    protected Env context;
    private boolean inheritEnv = false;

    public void setInheritEnv(boolean inheritEnv) {
        this.inheritEnv = inheritEnv;
    }

    public LambdaFunction(List<String> arguments, Expression expression, Env context) {
        this.arguments = arguments;
        this.context = context;
        this.expression = (BaseExpression)expression;
    }

    protected Map<String, Object> newEnv(Map<String, Object> parentEnv, AviatorObject ... args) {
        Env env = null;
        if (!this.inheritEnv) {
            Env contextEnv = new Env(parentEnv, this.context);
            contextEnv.configure(this.context.getInstance(), this.expression);
            env = new Env(contextEnv);
            env.configure(this.context.getInstance(), this.expression);
        } else {
            assert (parentEnv == this.context);
            env = (Env)parentEnv;
        }
        int i = 0;
        for (String name : this.arguments) {
            AviatorObject arg;
            Object value;
            if ((value = (arg = args[i++]).getValue(parentEnv)) == null && arg.getAviatorType() == AviatorType.JavaType && !parentEnv.containsKey(((AviatorJavaType)arg).getName())) {
                value = RuntimeUtils.getInstance(parentEnv).getFunction(((AviatorJavaType)arg).getName());
            }
            env.override(name, value);
        }
        return env;
    }
}

