/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.utils.Reflector;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class AviatorRuntimeJavaElementType
extends AviatorRuntimeJavaType {
    private static final long serialVersionUID = -955529214730255727L;
    private final int index;
    private final Object container;
    private final ContainerType containerType;

    public AviatorRuntimeJavaElementType(ContainerType containerType, Object container, int index, Callable<Object> callable) {
        super((Object)null);
        this.setCallable(callable);
        this.container = container;
        this.index = index;
        this.containerType = containerType;
    }

    @Override
    public AviatorObject setValue(AviatorObject value, Map<String, Object> env) {
        Object val = value.getValue(env);
        switch (this.containerType) {
            case Array: {
                Array.set(this.container, this.index, Reflector.boxArg(this.container.getClass().getComponentType(), val));
                break;
            }
            case List: {
                ((List)this.container).set(this.index, val);
                break;
            }
            default: {
                throw new ExpressionRuntimeException("Unknown container type: " + (Object)((Object)this.containerType));
            }
        }
        return AviatorRuntimeJavaType.valueOf(val);
    }

    public static enum ContainerType {
        List,
        Array;

    }
}

