/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.BaseExpression;
import com.googlecode.aviator.Feature;
import com.googlecode.aviator.exception.CompareNotSupportedException;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorPattern;
import com.googlecode.aviator.runtime.type.AviatorStringBuilder;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.TypeUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class AviatorString
extends AviatorObject {
    private static final long serialVersionUID = -7430694306919959899L;
    private final String lexeme;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS");
        }
    };
    private static int COMPILE_TIMES = 0;

    @Override
    public AviatorType getAviatorType() {
        return AviatorType.String;
    }

    @Override
    public Object getValue(Map<String, Object> env) {
        return this.getLexeme(env);
    }

    public AviatorString(String lexeme) {
        this.lexeme = lexeme;
    }

    @Override
    public AviatorObject add(AviatorObject other, Map<String, Object> env) {
        StringBuilder sb = new StringBuilder(this.getLexeme(env));
        if (other.getAviatorType() == AviatorType.Pattern) {
            AviatorPattern otherPatterh = (AviatorPattern)other;
            sb.append(otherPatterh.pattern.pattern());
        } else {
            sb.append(other.getValue(env));
        }
        return new AviatorStringBuilder(sb);
    }

    private int tryCompareDate(Map<String, Object> env, Date otherDate) {
        try {
            SimpleDateFormat simpleDateFormat = DATE_FORMATTER.get();
            Date thisDate = simpleDateFormat.parse(this.getLexeme(env));
            return thisDate.compareTo(otherDate);
        }
        catch (Throwable t) {
            throw new ExpressionRuntimeException("Compare date error", t);
        }
    }

    @Override
    public int innerCompare(AviatorObject other, Map<String, Object> env) {
        if (this == other) {
            return 0;
        }
        switch (other.getAviatorType()) {
            case String: {
                AviatorString otherString = (AviatorString)other;
                if (this.getLexeme(env) == null && otherString.getLexeme(env) != null) {
                    return -1;
                }
                if (this.getLexeme(env) != null && otherString.getLexeme(env) == null) {
                    return 1;
                }
                if (this.getLexeme(env) == null && otherString.getLexeme(env) == null) {
                    return 0;
                }
                return this.getLexeme(env).compareTo(otherString.getLexeme(env));
            }
            case JavaType: {
                AviatorJavaType javaType = (AviatorJavaType)other;
                Object otherJavaValue = javaType.getValue(env);
                if (this.getLexeme(env) == null && otherJavaValue == null) {
                    return 0;
                }
                if (this.getLexeme(env) != null && otherJavaValue == null) {
                    return 1;
                }
                if (TypeUtils.isString(otherJavaValue)) {
                    if (this.getLexeme(env) == null) {
                        return -1;
                    }
                    return this.getLexeme(env).compareTo(String.valueOf(otherJavaValue));
                }
                if (otherJavaValue instanceof Date) {
                    return this.tryCompareDate(env, (Date)otherJavaValue);
                }
                throw new CompareNotSupportedException("Could not compare " + this.desc(env) + " with " + other.desc(env));
            }
            case Nil: {
                if (this.getLexeme(env) == null) {
                    return 0;
                }
                return 1;
            }
        }
        throw new CompareNotSupportedException("Could not compare " + this.desc(env) + " with " + other.desc(env));
    }

    public String getLexeme(Map<String, Object> env) {
        AviatorEvaluatorInstance engine = RuntimeUtils.getInstance(env);
        if (!engine.isFeatureEnabled(Feature.StringInterpolation) || this.lexeme == null || this.lexeme.length() < 3) {
            return this.lexeme;
        }
        AviatorEvaluatorInstance.StringSegments segs = null;
        BaseExpression exp = (BaseExpression)(env == null ? null : env.get("__exp__"));
        if (exp != null) {
            segs = exp.getStringSegements(this.lexeme);
        } else {
            segs = engine.compileStringSegments(this.lexeme);
            this.warnOnCompile();
        }
        assert (segs != null);
        return segs.toString(env, this.lexeme);
    }

    private void warnOnCompile() {
        if (COMPILE_TIMES++ % 1000 == 0) {
            StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
            StringBuilder sb = new StringBuilder();
            boolean wasFirst = true;
            for (StackTraceElement st : stackTraces) {
                if (!wasFirst) {
                    sb.append("\t").append(st.toString()).append("\n");
                }
                if (!wasFirst) continue;
                wasFirst = false;
            }
            System.err.println("[Aviator WARN] compile lexeme `" + this.lexeme + "` without caching, it may hurt performance and cause metaspace full gc, the stack:\n" + sb.toString());
        }
    }
}

