/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.main;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.casbin.jcasbin.effect.DefaultEffector;
import org.casbin.jcasbin.effect.Effect;
import org.casbin.jcasbin.effect.Effector;
import org.casbin.jcasbin.model.Assertion;
import org.casbin.jcasbin.model.FunctionMap;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.Watcher;
import org.casbin.jcasbin.rbac.DefaultRoleManager;
import org.casbin.jcasbin.rbac.RoleManager;
import org.casbin.jcasbin.util.BuiltInFunctions;
import org.casbin.jcasbin.util.Util;

public class CoreEnforcer {
    String modelPath;
    public Model model;
    FunctionMap fm;
    private Effector eft;
    Adapter adapter;
    Watcher watcher;
    private RoleManager rm;
    private boolean enabled;
    boolean autoSave;
    boolean autoBuildRoleLinks;

    void initialize() {
        this.rm = new DefaultRoleManager(10);
        this.eft = new DefaultEffector();
        this.watcher = null;
        this.enabled = true;
        this.autoSave = true;
        this.autoBuildRoleLinks = true;
    }

    public static Model newModel() {
        Model m = new Model();
        return m;
    }

    public static Model newModel(String text) {
        Model m = new Model();
        m.loadModelFromText(text);
        return m;
    }

    public static Model newModel(String modelPath, String unused) {
        Model m = new Model();
        if (!modelPath.equals("")) {
            m.loadModel(modelPath);
        }
        return m;
    }

    public void loadModel() {
        this.model = CoreEnforcer.newModel();
        this.model.loadModel(this.modelPath);
        this.model.printModel();
        this.fm = FunctionMap.loadFunctionMap();
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
        this.fm = FunctionMap.loadFunctionMap();
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public void setWatcher(Watcher watcher) {
        this.watcher = watcher;
        watcher.setUpdateCallback(this::loadPolicy);
    }

    public void setRoleManager(RoleManager rm) {
        this.rm = rm;
    }

    public void setEffector(Effector eft) {
        this.eft = eft;
    }

    public void clearPolicy() {
        this.model.clearPolicy();
    }

    public void loadPolicy() {
        this.model.clearPolicy();
        this.adapter.loadPolicy(this.model);
        this.model.printPolicy();
        if (this.autoBuildRoleLinks) {
            this.buildRoleLinks();
        }
    }

    public void loadFilteredPolicy(Object filter) {
    }

    public boolean isFiltered() {
        return false;
    }

    public void savePolicy() {
        if (this.isFiltered()) {
            throw new Error("cannot save a filtered policy");
        }
        this.adapter.savePolicy(this.model);
        if (this.watcher != null) {
            this.watcher.update();
        }
    }

    public void enableEnforce(boolean enable) {
        this.enabled = enable;
    }

    public void enableLog(boolean enable) {
        Util.enableLog = enable;
    }

    public void enableAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public void enableAutoBuildRoleLinks(boolean autoBuildRoleLinks) {
        this.autoBuildRoleLinks = autoBuildRoleLinks;
    }

    public void buildRoleLinks() {
        this.rm.clear();
        this.model.buildRoleLinks(this.rm);
    }

    public boolean enforce(Object ... rvals) {
        float[] matcherResults;
        Effect[] policyEffects;
        String key;
        if (!this.enabled) {
            return true;
        }
        HashMap<String, AviatorFunction> functions = new HashMap<String, AviatorFunction>();
        for (Map.Entry<String, AviatorFunction> entry : this.fm.fm.entrySet()) {
            key = entry.getKey();
            AviatorFunction function = entry.getValue();
            functions.put(key, function);
        }
        if (this.model.model.containsKey("g")) {
            for (Map.Entry<String, Object> entry : ((Map)this.model.model.get("g")).entrySet()) {
                key = entry.getKey();
                Assertion ast = (Assertion)entry.getValue();
                RoleManager rm = ast.rm;
                functions.put(key, BuiltInFunctions.generateGFunction(key, rm));
            }
        }
        AviatorEvaluatorInstance eval = AviatorEvaluator.newInstance();
        for (AviatorFunction f : functions.values()) {
            eval.addFunction(f);
        }
        String string = ((Assertion)((Map)this.model.model.get((Object)"m")).get((Object)"m")).value;
        Expression expression = eval.compile(string);
        int policyLen = ((Assertion)((Map)this.model.model.get((Object)"p")).get((Object)"p")).policy.size();
        if (policyLen != 0) {
            policyEffects = new Effect[policyLen];
            matcherResults = new float[policyLen];
            for (int i = 0; i < ((Assertion)((Map)this.model.model.get((Object)"p")).get((Object)"p")).policy.size(); ++i) {
                String eft;
                String token;
                int j;
                List<String> pvals = ((Assertion)((Map)this.model.model.get((Object)"p")).get((Object)"p")).policy.get(i);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                for (j = 0; j < ((Assertion)((Map)this.model.model.get((Object)"r")).get((Object)"r")).tokens.length; ++j) {
                    token = ((Assertion)((Map)this.model.model.get((Object)"r")).get((Object)"r")).tokens[j];
                    parameters.put(token, rvals[j]);
                }
                for (j = 0; j < ((Assertion)((Map)this.model.model.get((Object)"p")).get((Object)"p")).tokens.length; ++j) {
                    token = ((Assertion)((Map)this.model.model.get((Object)"p")).get((Object)"p")).tokens[j];
                    parameters.put(token, pvals.get(j));
                }
                Object result = expression.execute(parameters);
                if (result instanceof Boolean) {
                    if (!((Boolean)result).booleanValue()) {
                        policyEffects[i] = Effect.Indeterminate;
                        continue;
                    }
                } else if (result instanceof Float) {
                    if (((Float)result).floatValue() == 0.0f) {
                        policyEffects[i] = Effect.Indeterminate;
                        continue;
                    }
                    matcherResults[i] = ((Float)result).floatValue();
                } else {
                    throw new Error("matcher result should be bool, int or float");
                }
                policyEffects[i] = parameters.containsKey("p_eft") ? ((eft = (String)parameters.get("p_eft")).equals("allow") ? Effect.Allow : (eft.equals("deny") ? Effect.Deny : Effect.Indeterminate)) : Effect.Allow;
                if (!((Assertion)((Map)this.model.model.get((Object)"e")).get((Object)"e")).value.equals("priority(p_eft) || deny")) {
                    continue;
                }
                break;
            }
        } else {
            String token;
            int j;
            policyEffects = new Effect[1];
            matcherResults = new float[1];
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            for (j = 0; j < ((Assertion)((Map)this.model.model.get((Object)"r")).get((Object)"r")).tokens.length; ++j) {
                token = ((Assertion)((Map)this.model.model.get((Object)"r")).get((Object)"r")).tokens[j];
                parameters.put(token, rvals[j]);
            }
            for (j = 0; j < ((Assertion)((Map)this.model.model.get((Object)"p")).get((Object)"p")).tokens.length; ++j) {
                token = ((Assertion)((Map)this.model.model.get((Object)"p")).get((Object)"p")).tokens[j];
                parameters.put(token, "");
            }
            Object result = expression.execute(parameters);
            policyEffects[0] = (Boolean)result != false ? Effect.Allow : Effect.Indeterminate;
        }
        boolean result = this.eft.mergeEffects(((Assertion)((Map)this.model.model.get((Object)"e")).get((Object)"e")).value, policyEffects, matcherResults);
        StringBuilder reqStr = new StringBuilder("Request: ");
        for (int i = 0; i < rvals.length; ++i) {
            String rval = rvals[i].toString();
            if (i != rvals.length - 1) {
                reqStr.append(String.format("%s, ", rval));
                continue;
            }
            reqStr.append(String.format("%s", rval));
        }
        reqStr.append(String.format(" ---> %s", result));
        Util.logPrint(reqStr.toString());
        return result;
    }
}

