/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.casbin.jcasbin.exception.CasbinNameNotExistException;
import org.casbin.jcasbin.main.ManagementEnforcer;
import org.casbin.jcasbin.model.Assertion;
import org.casbin.jcasbin.model.FunctionMap;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.file_adapter.FileAdapter;
import org.casbin.jcasbin.rbac.RoleManager;

public class Enforcer
extends ManagementEnforcer {
    public Enforcer() {
        this("", "");
    }

    public Enforcer(String modelPath, String policyFile) {
        this(modelPath, (Adapter)new FileAdapter(policyFile));
    }

    public Enforcer(String modelPath, Adapter adapter) {
        this(Enforcer.newModel(modelPath, ""), adapter);
        this.modelPath = modelPath;
    }

    public Enforcer(Model m, Adapter adapter) {
        this.adapter = adapter;
        this.watcher = null;
        this.model = m;
        this.model.printModel();
        this.fm = FunctionMap.loadFunctionMap();
        this.initialize();
        if (this.adapter != null) {
            this.loadPolicy();
        }
    }

    public Enforcer(Model m) {
        this(m, null);
    }

    public Enforcer(String modelPath) {
        this(modelPath, "");
    }

    public Enforcer(String modelPath, String policyFile, boolean enableLog) {
        this(modelPath, (Adapter)new FileAdapter(policyFile));
        this.enableLog(enableLog);
    }

    public List<String> getRolesForUser(String name) {
        try {
            return ((Assertion)((Map)this.model.model.get((Object)"g")).get((Object)"g")).rm.getRoles(name, new String[0]);
        }
        catch (CasbinNameNotExistException casbinNameNotExistException) {
            return Collections.emptyList();
        }
    }

    public List<String> getUsersForRole(String name) {
        try {
            return ((Assertion)((Map)this.model.model.get((Object)"g")).get((Object)"g")).rm.getUsers(name, new String[0]);
        }
        catch (CasbinNameNotExistException casbinNameNotExistException) {
            return Collections.emptyList();
        }
    }

    public boolean hasRoleForUser(String name, String role) {
        List<String> roles = this.getRolesForUser(name);
        boolean hasRole = false;
        for (String r : roles) {
            if (!r.equals(role)) continue;
            hasRole = true;
            break;
        }
        return hasRole;
    }

    public boolean addRoleForUser(String user, String role) {
        return this.addGroupingPolicy(user, role);
    }

    public boolean deleteRoleForUser(String user, String role) {
        return this.removeGroupingPolicy(user, role);
    }

    public boolean deleteRolesForUser(String user) {
        return this.removeFilteredGroupingPolicy(0, user);
    }

    public boolean deleteUser(String user) {
        return this.removeFilteredGroupingPolicy(0, user);
    }

    public void deleteRole(String role) {
        this.removeFilteredGroupingPolicy(1, role);
        this.removeFilteredPolicy(0, role);
    }

    public boolean deletePermission(String ... permission) {
        return this.removeFilteredPolicy(1, permission);
    }

    public boolean deletePermission(List<String> permission) {
        return this.deletePermission(permission.toArray(new String[0]));
    }

    public boolean addPermissionForUser(String user, String ... permission) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(user);
        Collections.addAll(params, permission);
        return this.addPolicy(params);
    }

    public boolean updatePermissionForUser(String user, List<String> oldPermission, List<String> newPermission) {
        ArrayList<String> params1 = new ArrayList<String>();
        ArrayList<String> params2 = new ArrayList<String>();
        params1.add(user);
        params2.add(user);
        Collections.addAll(params1, oldPermission.toArray(new String[0]));
        Collections.addAll(params2, newPermission.toArray(new String[0]));
        return this.updatePolicy(params1, params2);
    }

    public boolean addPermissionForUser(String user, List<String> permission) {
        return this.addPermissionForUser(user, permission.toArray(new String[0]));
    }

    public boolean deletePermissionForUser(String user, String ... permission) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(user);
        Collections.addAll(params, permission);
        return this.removePolicy(params);
    }

    public boolean deletePermissionForUser(String user, List<String> permission) {
        return this.deletePermissionForUser(user, permission.toArray(new String[0]));
    }

    public boolean deletePermissionsForUser(String user) {
        return this.removeFilteredPolicy(0, user);
    }

    public List<List<String>> getPermissionsForUser(String user, String ... domain) {
        ArrayList<List<String>> permissions = new ArrayList<List<String>>();
        for (Map.Entry entry : ((Map)this.model.model.get("p")).entrySet()) {
            int index;
            String ptype = (String)entry.getKey();
            Assertion ast = (Assertion)entry.getValue();
            String[] args = new String[ast.tokens.length];
            args[0] = user;
            if (domain.length > 0 && (index = this.getDomainIndex(ptype)) < ast.tokens.length) {
                args[index] = domain[0];
            }
            permissions.addAll(this.getFilteredPolicy(0, args));
        }
        return permissions;
    }

    public boolean hasPermissionForUser(String user, String ... permission) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(user);
        Collections.addAll(params, permission);
        return this.hasPolicy(params);
    }

    public boolean hasPermissionForUser(String user, List<String> permission) {
        return this.hasPermissionForUser(user, permission.toArray(new String[0]));
    }

    public List<String> getRolesForUserInDomain(String name, String domain) {
        try {
            return ((Assertion)((Map)this.model.model.get((Object)"g")).get((Object)"g")).rm.getRoles(name, domain);
        }
        catch (CasbinNameNotExistException casbinNameNotExistException) {
            return Collections.emptyList();
        }
    }

    public List<List<String>> getPermissionsForUserInDomain(String user, String domain) {
        return this.getFilteredPolicy(0, user, domain);
    }

    public boolean addRoleForUserInDomain(String user, String role, String domain) {
        return this.addGroupingPolicy(user, role, domain);
    }

    public boolean deleteRoleForUserInDomain(String user, String role, String domain) {
        return this.removeGroupingPolicy(user, role, domain);
    }

    public List<String> getImplicitRolesForUser(String name, String ... domain) {
        ArrayList<String> res = new ArrayList<String>();
        LinkedList<String> queue = new LinkedList<String>();
        queue.offerLast(name);
        while (!queue.isEmpty()) {
            name = (String)queue.pollFirst();
            for (RoleManager rm : this.rmMap.values()) {
                List<String> roles = rm.getRoles(name, domain);
                for (String role : roles) {
                    if (res.contains(role)) continue;
                    res.add(role);
                    queue.offerLast(role);
                }
            }
        }
        return res;
    }

    public List<String> getImplicitUsersForRole(String name, String ... domain) {
        LinkedList<String> queue = new LinkedList<String>();
        queue.offerLast(name);
        ArrayList<String> res = new ArrayList<String>();
        while (!queue.isEmpty()) {
            name = (String)queue.pollFirst();
            for (RoleManager rm : this.rmMap.values()) {
                try {
                    List<String> users = rm.getUsers(name, domain);
                    for (String user : users) {
                        if (res.contains(user)) continue;
                        res.add(user);
                        queue.offerLast(user);
                    }
                }
                catch (CasbinNameNotExistException casbinNameNotExistException) {
                }
            }
        }
        return res;
    }

    public List<List<String>> getImplicitPermissionsForUser(String user, String ... domain) {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add(user);
        roles.addAll(this.getImplicitRolesForUser(user, domain));
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        for (String role : roles) {
            res.addAll(this.getPermissionsForUser(role, domain));
        }
        return res;
    }

    public List<List<String>> getImplicitPermissionsForUserInDomain(String user, String domain) {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add(user);
        roles.addAll(this.getImplicitRolesForUser(user, domain));
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        for (String n : roles) {
            res.addAll(this.getPermissionsForUserInDomain(n, domain));
        }
        return res;
    }

    public List<Boolean> batchEnforce(List<List<String>> rules) {
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        for (List<String> rule : rules) {
            boolean result = this.enforce(rule.get(0), rule.get(1), rule.get(2));
            results.add(result);
        }
        return results;
    }

    public List<Boolean> batchEnforceWithMatcher(String matcher, List<List<String>> rules) {
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        for (List<String> rule : rules) {
            boolean result = this.enforceWithMatcher(matcher, rule.get(0), rule.get(1), rule.get(2));
            results.add(result);
        }
        return results;
    }
}

