/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.persist.file_adapter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.casbin.jcasbin.exception.CasbinAdapterException;
import org.casbin.jcasbin.exception.CasbinPolicyFileNotFoundException;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.Helper;
import org.casbin.jcasbin.util.Util;

public class FileAdapter
implements Adapter {
    private String filePath;
    private boolean readOnly = false;
    private ByteArrayInputStream byteArrayInputStream;

    public FileAdapter(String filePath) {
        this.filePath = filePath;
    }

    public FileAdapter(InputStream inputStream) {
        this.readOnly = true;
        try {
            this.byteArrayInputStream = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)inputStream));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CasbinAdapterException("File adapter init error");
        }
    }

    @Override
    public void loadPolicy(Model model) {
        if (this.filePath != null && !"".equals(this.filePath)) {
            try (FileInputStream fis = new FileInputStream(this.filePath);){
                this.loadPolicyData(model, Helper::loadPolicyLine, fis);
            }
            catch (IOException e) {
                throw new CasbinAdapterException("Load policy file error", e.getCause());
            }
        }
        if (this.byteArrayInputStream != null) {
            this.loadPolicyData(model, Helper::loadPolicyLine, this.byteArrayInputStream);
        }
    }

    @Override
    public void savePolicy(Model model) {
        if (this.byteArrayInputStream != null && this.readOnly) {
            throw new CasbinAdapterException("Policy file can not write, because use inputStream is readOnly");
        }
        if (this.filePath == null || "".equals(this.filePath) || !new File(this.filePath).exists()) {
            throw new CasbinPolicyFileNotFoundException("invalid file path: " + this.filePath);
        }
        ArrayList<String> policy = new ArrayList<String>();
        policy.addAll(this.getModelPolicy(model, "p"));
        policy.addAll(this.getModelPolicy(model, "g"));
        this.savePolicyFile(String.join((CharSequence)"\n", policy));
    }

    private List<String> getModelPolicy(Model model, String ptype) {
        ArrayList<String> policy = new ArrayList<String>();
        ((Map)model.model.get(ptype)).forEach((k, v) -> {
            List p = v.policy.parallelStream().map(x -> k + ", " + Util.arrayToString(x)).collect(Collectors.toList());
            policy.addAll(p);
        });
        return policy;
    }

    private void loadPolicyData(Model model, Helper.loadPolicyLineHandler<String, Model> handler, InputStream inputStream) {
        try {
            List lines = IOUtils.readLines((InputStream)inputStream, (Charset)Charset.forName("UTF-8"));
            lines.forEach(x -> handler.accept((String)x, model));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CasbinAdapterException("Policy load error");
        }
    }

    private void savePolicyFile(String text) {
        try (FileOutputStream fos = new FileOutputStream(this.filePath);){
            IOUtils.write((String)text, (OutputStream)fos, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CasbinAdapterException("Policy save error");
        }
    }

    @Override
    public void addPolicy(String sec, String ptype, List<String> rule) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void removePolicy(String sec, String ptype, List<String> rule) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void removeFilteredPolicy(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        throw new UnsupportedOperationException("not implemented");
    }
}

