/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.util;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.AbstractVariadicFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.Sequence;
import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.casbin.jcasbin.rbac.RoleManager;
import org.casbin.jcasbin.util.Glob;

public class BuiltInFunctions {
    private static Pattern keyMatch2Pattern = Pattern.compile("(.*):[^/]+(.*)");
    private static Pattern keyMatch3Pattern = Pattern.compile("(.*)\\{[^/]+\\}(.*)");

    public static boolean keyMatch(String key1, String key2) {
        int i = key2.indexOf(42);
        if (i == -1) {
            return key1.equals(key2);
        }
        if (key1.length() > i) {
            return key1.substring(0, i).equals(key2.substring(0, i));
        }
        return key1.equals(key2.substring(0, i));
    }

    public static boolean keyMatch2(String key1, String key2) {
        key2 = key2.replace("/*", "/.*");
        while (key2.contains("/:")) {
            key2 = "^" + keyMatch2Pattern.matcher(key2).replaceAll("$1[^/]+$2") + "$";
        }
        return BuiltInFunctions.regexMatch(key1, key2);
    }

    public static boolean keyMatch3(String key1, String key2) {
        key2 = key2.replace("/*", "/.*");
        while (key2.contains("/{")) {
            key2 = keyMatch3Pattern.matcher(key2).replaceAll("$1[^/]+$2");
        }
        return BuiltInFunctions.regexMatch(key1, key2);
    }

    public static boolean keyMatch4(String key1, String key2) {
        String regEx = "\\{[^/]+\\}";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(key2);
        String[] tmp = p.split(key2);
        ArrayList<String> tokens = new ArrayList<String>();
        if (tmp.length > 0) {
            for (int count = 0; count < tmp.length; ++count) {
                tokens.add(tmp[count]);
                if (!m.find()) continue;
                tokens.add(m.group());
            }
        }
        int off = 0;
        for (String token : tokens) {
            if (p.matcher(token).matches()) continue;
            while (off < key1.length() && key1.charAt(off) != token.charAt(0)) {
                ++off;
            }
            if (key1.length() - (off + 1) < token.length()) {
                return false;
            }
            if (!key1.substring(off, off + token.length()).equals(token)) {
                return false;
            }
            key1 = key1.replaceFirst(token, ",");
        }
        String[] values = key1.split(",");
        int i = 0;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String token : tokens) {
            if (!p.matcher(token).matches()) continue;
            while (i < values.length && values[i].equals("")) {
                ++i;
            }
            if (i == values.length) {
                return false;
            }
            if (params.containsKey(token)) {
                if (!values[i].equals(params.get(token))) {
                    return false;
                }
            } else {
                params.put(token, values[i]);
            }
            ++i;
        }
        return true;
    }

    public static String keyGetFunc(String key1, String key2) {
        int index = key2.indexOf(42);
        if (index == -1) {
            return "";
        }
        if (key1.length() > index && key1.substring(0, index).equals(key2.substring(0, index))) {
            return key1.substring(index);
        }
        return "";
    }

    public static String keyGet2Func(String key1, String key2, String pathVar) {
        int i;
        key2 = key2.replace("/*", "/.*");
        String regexp = ":[^/]+";
        Pattern re = Pattern.compile(regexp);
        Matcher keys = re.matcher(key2);
        ArrayList<String> keysList = new ArrayList<String>();
        while (keys.find()) {
            keysList.add(keys.group());
        }
        key2 = keys.replaceAll("([^/]+)");
        key2 = "^" + key2 + "$";
        Pattern re2 = Pattern.compile(key2);
        Matcher values = re2.matcher(key1);
        ArrayList<String> valuesList = new ArrayList<String>();
        while (values.find()) {
            for (i = 0; i <= values.groupCount(); ++i) {
                valuesList.add(values.group(i));
            }
        }
        if (valuesList.isEmpty()) {
            return "";
        }
        for (i = 0; i < keysList.size(); ++i) {
            if (!pathVar.equals(((String)keysList.get(i)).substring(1))) continue;
            return (String)valuesList.get(i + 1);
        }
        return "";
    }

    public static boolean regexMatch(String key1, String key2) {
        return Pattern.matches(key2, key1);
    }

    public static boolean ipMatch(String ip1, String ip2) {
        IPAddress ipa2;
        IPAddress ipa1;
        IPAddressString ipas1 = new IPAddressString(ip1);
        try {
            ipas1.validateIPv4();
        }
        catch (AddressStringException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("invalid argument: ip1 in IPMatch() function is not an IP address.");
        }
        IPAddressString ipas2 = new IPAddressString(ip2);
        try {
            ipas2.validate();
        }
        catch (AddressStringException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("invalid argument: ip2 in IPMatch() function is neither an IP address nor a CIDR.");
        }
        if (ipas1.equals((Object)ipas2)) {
            return true;
        }
        try {
            ipa1 = ipas1.toAddress();
            ipa2 = ipas2.toAddress();
        }
        catch (AddressStringException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("invalid argument: ip1 or ip2 in IPMatch() function is not an IP address.");
        }
        Integer prefix = ipa2.getNetworkPrefixLength();
        IPAddress mask = ipa2.getNetwork().getNetworkMask(prefix.intValue(), false);
        return ipa1.mask(mask).equals((Object)ipas2.getHostAddress());
    }

    public static boolean globMatch(String key1, String key2) {
        return Pattern.matches(Glob.toRegexPattern(key2), key1);
    }

    public static boolean allMatch(String key1, String key2) {
        if ("*".equals(key1) || "*".equals(key2)) {
            return true;
        }
        return key1.equals(key2);
    }

    public static AviatorFunction generateGFunction(final String name, final RoleManager rm) {
        return new AbstractVariadicFunction(){

            public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
                int len = args.length;
                if (len < 2) {
                    return AviatorBoolean.valueOf((boolean)false);
                }
                Object name1Obj = FunctionUtils.getJavaObject((AviatorObject)args[0], env);
                String name2 = FunctionUtils.getStringValue((AviatorObject)args[1], env);
                Sequence name1List = null;
                String name1 = null;
                if (name1Obj instanceof List) {
                    name1List = RuntimeUtils.seq((Object)name1Obj, env);
                } else {
                    name1 = (String)name1Obj;
                }
                if (rm == null) {
                    return AviatorBoolean.valueOf((boolean)name1.equals(name2));
                }
                switch (len) {
                    case 2: {
                        if (name1List != null) {
                            boolean res = false;
                            for (Object obj : name1List) {
                                if (!rm.hasLink((String)obj, name2, new String[0])) continue;
                                res = true;
                                break;
                            }
                            return AviatorBoolean.valueOf((boolean)res);
                        }
                        return AviatorBoolean.valueOf((boolean)rm.hasLink(name1, name2, new String[0]));
                    }
                    case 3: {
                        String domain = FunctionUtils.getStringValue((AviatorObject)args[2], env);
                        return AviatorBoolean.valueOf((boolean)rm.hasLink(name1, name2, domain));
                    }
                    case 4: {
                        String p_dom = FunctionUtils.getStringValue((AviatorObject)args[3], env);
                        Object domainObj = FunctionUtils.getJavaObject((AviatorObject)args[2], env);
                        boolean res = false;
                        if (domainObj instanceof List) {
                            Sequence domainSeq = RuntimeUtils.seq((Object)domainObj, env);
                            for (Object r_dom : domainSeq) {
                                if (!r_dom.equals(p_dom) || !rm.hasLink(name1, name2, (String)r_dom)) continue;
                                res = true;
                                break;
                            }
                        }
                        return AviatorBoolean.valueOf((boolean)res);
                    }
                }
                return AviatorBoolean.valueOf((boolean)false);
            }

            public String getName() {
                return name;
            }
        };
    }

    public static boolean eval(String eval, Map<String, Object> env, AviatorEvaluatorInstance aviatorEval) {
        boolean res = aviatorEval != null ? ((Boolean)aviatorEval.execute(eval, env)).booleanValue() : ((Boolean)AviatorEvaluator.execute((String)eval, env)).booleanValue();
        return res;
    }
}

