/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.config;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class Config {
    private static final String DEFAULT_SECTION = "default";
    private static final String DEFAULT_COMMENT = "#";
    private static final String DEFAULT_COMMENT_SEM = ";";
    private ReentrantLock lock = new ReentrantLock();
    private Map<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();

    private Config() {
    }

    public static Config newConfig(String confName) {
        Config c = new Config();
        c.parse(confName);
        return c;
    }

    public static Config newConfigFromText(String text) {
        Config c = new Config();
        c.parseBuffer(new BufferedReader(new StringReader(text)));
        return c;
    }

    private boolean addConfig(String section, String option, String value) {
        if (section.equals("")) {
            section = DEFAULT_SECTION;
        }
        if (!this.data.containsKey(section)) {
            this.data.put(section, new HashMap());
        }
        boolean ok = this.data.get(section).containsKey(option);
        this.data.get(section).put(option, value);
        return !ok;
    }

    private void parse(String fname) {
        FileInputStream fis;
        this.lock.lock();
        try {
            fis = new FileInputStream(fname);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Error("model file not found");
        }
        BufferedReader buf = new BufferedReader(new InputStreamReader(fis));
        this.parseBuffer(buf);
        this.lock.unlock();
        try {
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("IO error occurred");
        }
    }

    private void parseBuffer(BufferedReader buf) {
        String section = "";
        int lineNum = 0;
        while (true) {
            String line;
            ++lineNum;
            try {
                line = buf.readLine();
                if (line == null) break;
                if (line.equals("")) {
                    continue;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new Error("IO error occurred");
            }
            if ((line = line.trim()).startsWith(DEFAULT_COMMENT) || line.startsWith(DEFAULT_COMMENT_SEM)) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                section = line.substring(1, line.length() - 1);
                continue;
            }
            String[] optionVal = line.split("=", 2);
            if (optionVal.length != 2) {
                throw new Error(String.format("parse the content error : line %d , %s = ? ", lineNum, optionVal[0]));
            }
            String option = optionVal[0].trim();
            String value = optionVal[1].trim();
            this.addConfig(section, option, value);
        }
    }

    public boolean getBool(String key) {
        return Boolean.parseBoolean(this.get(key));
    }

    public int getInt(String key) {
        return Integer.parseInt(this.get(key));
    }

    public float getFloat(String key) {
        return Float.parseFloat(this.get(key));
    }

    public String getString(String key) {
        return this.get(key);
    }

    public String[] getStrings(String key) {
        String v = this.get(key);
        if (v.equals("")) {
            return null;
        }
        return v.split(",");
    }

    public void set(String key, String value) {
        String option;
        this.lock.lock();
        if (key.length() == 0) {
            throw new Error("key is empty");
        }
        String section = "";
        String[] keys = key.toLowerCase().split("::");
        if (keys.length >= 2) {
            section = keys[0];
            option = keys[1];
        } else {
            option = keys[0];
        }
        this.addConfig(section, option, value);
    }

    public String get(String key) {
        boolean ok;
        String option;
        String section;
        String[] keys = key.toLowerCase().split("::");
        if (keys.length >= 2) {
            section = keys[0];
            option = keys[1];
        } else {
            section = DEFAULT_SECTION;
            option = keys[0];
        }
        boolean bl = ok = this.data.containsKey(section) && this.data.get(section).containsKey(option);
        if (ok) {
            return this.data.get(section).get(option);
        }
        return "";
    }
}

