/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    public static boolean enableLog = true;
    private static Pattern evalReg = Pattern.compile("\\beval\\(([^),]*)\\)");
    private static Logger LOGGER = LoggerFactory.getLogger((String)"org.casbin.jcasbin");

    public static void logPrint(String v) {
        if (enableLog) {
            LOGGER.info(v);
        }
    }

    public static void logPrintf(String format, String ... v) {
        if (enableLog) {
            String tmp = String.format(format, v);
            LOGGER.info(tmp);
        }
    }

    public static void logPrintfWarn(String format, Object ... v) {
        if (enableLog) {
            LOGGER.warn(format, v);
        }
    }

    public static void logPrintfError(String format, Object ... v) {
        if (enableLog) {
            LOGGER.error(format, v);
        }
    }

    public static String escapeAssertion(String s) {
        if (s.startsWith("r") || s.startsWith("p")) {
            s = s.replaceFirst("\\.", "_");
        }
        String regex = "(\\|| |=|\\)|\\(|&|<|>|,|\\+|-|!|\\*|\\/)(r|p)[0-9]*\\.";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group().replace(".", "_"));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String convertInSyntax(String expString) {
        String reg = "([a-zA-Z0-9_.()\"]*) +in +([a-zA-Z0-9_.()\"]*)";
        Matcher m1 = Pattern.compile(reg).matcher(expString);
        StringBuffer sb = new StringBuffer();
        boolean flag = false;
        while (m1.find()) {
            flag = true;
            m1.appendReplacement(sb, "include($2, $1)");
        }
        m1.appendTail(sb);
        return flag ? sb.toString() : expString;
    }

    public static String removeComments(String s) {
        int pos = s.indexOf("#");
        if (pos == -1) {
            return s;
        }
        return s.substring(0, pos).trim();
    }

    public static boolean arrayEquals(List<String> a, List<String> b) {
        if (a == null) {
            a = new ArrayList<String>();
        }
        if (b == null) {
            b = new ArrayList<String>();
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).equals(b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean array2DEquals(List<List<String>> a, List<List<String>> b) {
        if (a == null) {
            a = new ArrayList<List<String>>();
        }
        if (b == null) {
            b = new ArrayList<List<String>>();
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (Util.arrayEquals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean arrayRemoveDuplicates(List<String> s) {
        return true;
    }

    public static String arrayToString(List<String> s) {
        return String.join((CharSequence)", ", s);
    }

    public static String paramsToString(String[] s) {
        return String.join((CharSequence)", ", s);
    }

    public static String[] splitCommaDelimited(String s) {
        String[] records = null;
        if (s != null) {
            try {
                CSVParser csvParser = CSVFormat.DEFAULT.withEscape('\\').parse((Reader)new StringReader(s));
                List csvRecords = csvParser.getRecords();
                records = new String[((CSVRecord)csvRecords.get(0)).size()];
                for (int i = 0; i < ((CSVRecord)csvRecords.get(0)).size(); ++i) {
                    records[i] = ((CSVRecord)csvRecords.get(0)).get(i).trim();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Util.logPrintfError("CSV parser failed to parse this line:", s);
            }
        }
        return records;
    }

    public static boolean setEquals(List<String> a, List<String> b) {
        if (a == null) {
            a = new ArrayList<String>();
        }
        if (b == null) {
            b = new ArrayList<String>();
        }
        if (a.size() != b.size()) {
            return false;
        }
        Collections.sort(a);
        Collections.sort(b);
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).equals(b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasEval(String exp) {
        return evalReg.matcher(exp).matches();
    }

    public static String replaceEval(String s, String replacement) {
        return evalReg.matcher(s).replaceAll("(" + replacement + ")");
    }
}

