/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.util;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.runtime.function.AbstractVariadicFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.casbin.jcasbin.rbac.RoleManager;
import org.casbin.jcasbin.util.Glob;

public class BuiltInFunctions {
    private static final Pattern KEY_MATCH2_PATTERN = Pattern.compile(":[^/]+");
    private static final Pattern KEY_MATCH3_PATTERN = Pattern.compile("\\{[^/]+\\}");

    public static boolean keyMatch(String key1, String key2) {
        int i = key2.indexOf(42);
        if (i == -1) {
            return key1.equals(key2);
        }
        if (key1.length() > i) {
            return key1.substring(0, i).equals(key2.substring(0, i));
        }
        return key1.equals(key2.substring(0, i));
    }

    public static boolean keyMatch2(String key1, String key2) {
        key2 = key2.replace("/*", "/.*");
        key2 = "^" + KEY_MATCH2_PATTERN.matcher(key2).replaceAll("[^/]+") + "$";
        return BuiltInFunctions.regexMatch(key1, key2);
    }

    public static boolean keyMatch3(String key1, String key2) {
        key2 = key2.replace("/*", "/.*");
        key2 = "^" + KEY_MATCH3_PATTERN.matcher(key2).replaceAll("[^/]+") + "$";
        try {
            return BuiltInFunctions.regexMatch(key1, key2);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    public static boolean keyMatch4(String key1, String key2) {
        String regEx = "\\{[^/]+\\}";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(key2);
        String[] tmp = p.split(key2);
        ArrayList<String> tokens = new ArrayList<String>();
        if (tmp.length > 0) {
            for (int count = 0; count < tmp.length; ++count) {
                tokens.add(tmp[count]);
                if (!m.find()) continue;
                tokens.add(m.group());
            }
        }
        int off = 0;
        for (String token : tokens) {
            if (p.matcher(token).matches()) continue;
            while (off < key1.length() && key1.charAt(off) != token.charAt(0)) {
                ++off;
            }
            if (key1.length() - (off + 1) < token.length()) {
                return false;
            }
            if (!key1.startsWith(token, off)) {
                return false;
            }
            key1 = key1.replaceFirst(token, ",");
        }
        String[] values = key1.split(",");
        int i = 0;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String token : tokens) {
            if (!p.matcher(token).matches()) continue;
            while (i < values.length && "".equals(values[i])) {
                ++i;
            }
            if (i == values.length) {
                return false;
            }
            if (params.containsKey(token)) {
                if (!values[i].equals(params.get(token))) {
                    return false;
                }
            } else {
                params.put(token, values[i]);
            }
            ++i;
        }
        return true;
    }

    public static boolean keyMatch5(String key1, String key2) {
        int i = key1.indexOf(63);
        if (i == -1) {
            return key1.equals(key2);
        }
        return key1.substring(0, i).equals(key2);
    }

    public static String keyGetFunc(String key1, String key2) {
        int index = key2.indexOf(42);
        if (index == -1) {
            return "";
        }
        if (key1.length() > index && key1.substring(0, index).equals(key2.substring(0, index))) {
            return key1.substring(index);
        }
        return "";
    }

    public static String keyGet2Func(String key1, String key2, String pathVar) {
        int i;
        key2 = key2.replace("/*", "/.*");
        String regexp = ":[^/]+";
        Pattern re = Pattern.compile(regexp);
        Matcher keys = re.matcher(key2);
        ArrayList<String> keysList = new ArrayList<String>();
        while (keys.find()) {
            keysList.add(keys.group());
        }
        key2 = keys.replaceAll("([^/]+)");
        key2 = "^" + key2 + "$";
        Pattern re2 = Pattern.compile(key2);
        Matcher values = re2.matcher(key1);
        ArrayList<String> valuesList = new ArrayList<String>();
        while (values.find()) {
            for (i = 0; i <= values.groupCount(); ++i) {
                valuesList.add(values.group(i));
            }
        }
        if (valuesList.isEmpty()) {
            return "";
        }
        for (i = 0; i < keysList.size(); ++i) {
            if (!pathVar.equals(((String)keysList.get(i)).substring(1))) continue;
            return (String)valuesList.get(i + 1);
        }
        return "";
    }

    public static boolean regexMatch(String key1, String key2) {
        return Pattern.compile(key2).matcher(key1).lookingAt();
    }

    public static boolean ipMatch(String ip1, String ip2) {
        IPAddress ipa2;
        IPAddress ipa1;
        IPAddressString ipas1 = new IPAddressString(ip1);
        try {
            ipas1.validateIPv4();
        }
        catch (AddressStringException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("invalid argument: ip1 in IPMatch() function is not an IP address.");
        }
        IPAddressString ipas2 = new IPAddressString(ip2);
        try {
            ipas2.validate();
        }
        catch (AddressStringException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("invalid argument: ip2 in IPMatch() function is neither an IP address nor a CIDR.");
        }
        if (ipas1.equals((Object)ipas2)) {
            return true;
        }
        try {
            ipa1 = ipas1.toAddress();
            ipa2 = ipas2.toAddress();
        }
        catch (AddressStringException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("invalid argument: ip1 or ip2 in IPMatch() function is not an IP address.");
        }
        Integer prefix = ipa2.getNetworkPrefixLength();
        IPAddress mask = ipa2.getNetwork().getNetworkMask(prefix.intValue(), false);
        return ipa1.mask(mask).equals((Object)ipa2.mask(mask));
    }

    public static boolean globMatch(String key1, String key2) {
        return Pattern.matches(Glob.toRegexPattern(key2), key1);
    }

    public static boolean allMatch(String key1, String key2) {
        if ("*".equals(key2)) {
            return true;
        }
        return key1.equals(key2);
    }

    public static boolean eval(String eval, Map<String, Object> env, AviatorEvaluatorInstance aviatorEval) {
        boolean res = aviatorEval != null ? ((Boolean)aviatorEval.execute(eval, env)).booleanValue() : ((Boolean)AviatorEvaluator.execute((String)eval, env)).booleanValue();
        return res;
    }

    public static class GenerateGFunctionClass {
        private static Map<String, Map<String, AviatorBoolean>> memorizedMap = new ConcurrentHashMap<String, Map<String, AviatorBoolean>>();

        public static AviatorFunction generateGFunction(final String name, final RoleManager rm) {
            memorizedMap.put(name, new HashMap());
            return new AbstractVariadicFunction(){

                public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
                    Map memorized = (Map)memorizedMap.get(name);
                    int len = args.length;
                    if (len < 2) {
                        return AviatorBoolean.valueOf((boolean)false);
                    }
                    String name1 = FunctionUtils.getStringValue((AviatorObject)args[0], env);
                    String name2 = FunctionUtils.getStringValue((AviatorObject)args[1], env);
                    String key = "";
                    for (AviatorObject arg : args) {
                        String name3 = FunctionUtils.getStringValue((AviatorObject)arg, env);
                        key = key + ";" + name3;
                    }
                    AviatorBoolean value = (AviatorBoolean)memorized.get(key);
                    if (value != null) {
                        return value;
                    }
                    if (rm == null) {
                        value = AviatorBoolean.valueOf((boolean)name1.equals(name2));
                    } else if (len == 2) {
                        value = AviatorBoolean.valueOf((boolean)rm.hasLink(name1, name2, new String[0]));
                    } else if (len == 3) {
                        String domain = FunctionUtils.getStringValue((AviatorObject)args[2], env);
                        value = AviatorBoolean.valueOf((boolean)rm.hasLink(name1, name2, domain));
                    } else {
                        value = AviatorBoolean.valueOf((boolean)false);
                    }
                    memorized.put(key, value);
                    return value;
                }

                public String getName() {
                    return name;
                }
            };
        }
    }
}

