/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.main;

import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.casbin.jcasbin.main.EnforceResult;
import org.casbin.jcasbin.main.Enforcer;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.Watcher;

public class SyncedEnforcer
extends Enforcer {
    private static final ReadWriteLock READ_WRITE_LOCK = new ReentrantReadWriteLock();

    public SyncedEnforcer() {
    }

    public SyncedEnforcer(String modelPath, String policyFile) {
        super(modelPath, policyFile);
    }

    public SyncedEnforcer(String modelPath, Adapter adapter) {
        super(modelPath, adapter);
    }

    public SyncedEnforcer(Model m, Adapter adapter) {
        super(m, adapter);
    }

    public SyncedEnforcer(Model m) {
        super(m);
    }

    public SyncedEnforcer(String modelPath) {
        super(modelPath);
    }

    public SyncedEnforcer(String modelPath, String policyFile, boolean enableLog) {
        super(modelPath, policyFile, enableLog);
    }

    @Override
    public void setWatcher(Watcher watcher) {
        this.watcher = watcher;
        watcher.setUpdateCallback(this::loadPolicy);
    }

    @Override
    public void clearPolicy() {
        this.runSynchronized(() -> super.clearPolicy(), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public void loadPolicy() {
        this.runSynchronized(() -> super.loadPolicy(), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public void loadFilteredPolicy(Object filter) {
        this.runSynchronized(() -> super.loadFilteredPolicy(filter), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public void savePolicy() {
        this.runSynchronized(() -> super.savePolicy(), READ_WRITE_LOCK.readLock());
    }

    @Override
    public void buildRoleLinks() {
        this.runSynchronized(() -> super.buildRoleLinks(), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean enforce(Object ... rvals) {
        return this.runSynchronized(() -> super.enforce(rvals), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean enforceWithMatcher(String matcher, Object ... rvals) {
        return this.runSynchronized(() -> super.enforceWithMatcher(matcher, rvals), READ_WRITE_LOCK.readLock());
    }

    @Override
    public EnforceResult enforceEx(Object ... rvals) {
        return this.runSynchronized(() -> super.enforceEx(rvals), READ_WRITE_LOCK.readLock());
    }

    @Override
    public EnforceResult enforceExWithMatcher(String matcher, Object ... rvals) {
        return this.runSynchronized(() -> super.enforceExWithMatcher(matcher, rvals), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<Boolean> batchEnforce(List<List<String>> rules) {
        return this.runSynchronized(() -> super.batchEnforce(rules), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<Boolean> batchEnforceWithMatcher(String matcher, List<List<String>> rules) {
        return this.runSynchronized(() -> super.batchEnforceWithMatcher(matcher, rules), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<String> getAllSubjects() {
        return this.runSynchronized(() -> super.getAllSubjects(), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<String> getAllObjects() {
        return this.runSynchronized(() -> super.getAllObjects(), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<String> getAllNamedObjects(String ptype) {
        return this.runSynchronized(() -> super.getAllNamedObjects(ptype), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<String> getAllActions() {
        return this.runSynchronized(() -> super.getAllActions(), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<String> getAllNamedActions(String ptype) {
        return this.runSynchronized(() -> super.getAllNamedActions(ptype), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<String> getAllRoles() {
        return this.runSynchronized(() -> super.getAllRoles(), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<String> getAllNamedRoles(String ptype) {
        return this.runSynchronized(() -> super.getAllNamedRoles(ptype), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<List<String>> getPolicy() {
        return this.runSynchronized(() -> super.getPolicy(), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<List<String>> getFilteredPolicy(int fieldIndex, String ... fieldValues) {
        return this.runSynchronized(() -> super.getFilteredPolicy(fieldIndex, fieldValues), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<List<String>> getNamedPolicy(String ptype) {
        return this.runSynchronized(() -> super.getNamedPolicy(ptype), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<List<String>> getFilteredNamedPolicy(String ptype, int fieldIndex, String ... fieldValues) {
        return this.runSynchronized(() -> super.getFilteredNamedPolicy(ptype, fieldIndex, fieldValues), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<List<String>> getGroupingPolicy() {
        return this.runSynchronized(() -> super.getGroupingPolicy(), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<String> getRolesForUser(String name) {
        return this.runSynchronized(() -> super.getRolesForUser(name), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<List<String>> getFilteredGroupingPolicy(int fieldIndex, String ... fieldValues) {
        return this.runSynchronized(() -> super.getFilteredGroupingPolicy(fieldIndex, fieldValues), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<List<String>> getNamedGroupingPolicy(String ptype) {
        return this.runSynchronized(() -> super.getNamedGroupingPolicy(ptype), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<List<String>> getFilteredNamedGroupingPolicy(String ptype, int fieldIndex, String ... fieldValues) {
        return this.runSynchronized(() -> super.getFilteredNamedGroupingPolicy(ptype, fieldIndex, fieldValues), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean hasPolicy(List<String> params) {
        return this.runSynchronized(() -> super.hasPolicy(params), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean hasPolicy(String ... params) {
        return this.runSynchronized(() -> super.hasPolicy(params), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean hasNamedPolicy(String ptype, List<String> params) {
        return this.runSynchronized(() -> super.hasNamedPolicy(ptype, params), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean hasNamedPolicy(String ptype, String ... params) {
        return this.runSynchronized(() -> super.hasNamedPolicy(ptype, params), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean addPolicy(List<String> params) {
        return this.runSynchronized(() -> super.addPolicy(params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addPolicies(List<List<String>> rules) {
        return this.runSynchronized(() -> super.addPolicies(rules), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean updatePolicy(List<String> params1, List<String> params2) {
        return this.runSynchronized(() -> super.updatePolicy(params1, params2), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addPolicy(String ... params) {
        return this.runSynchronized(() -> super.addPolicy(params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addPolicies(String[][] rules) {
        return this.runSynchronized(() -> super.addPolicies(rules), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addNamedPolicy(String ptype, List<String> params) {
        return this.runSynchronized(() -> super.addNamedPolicy(ptype, params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addNamedPolicies(String ptype, List<List<String>> rules) {
        return this.runSynchronized(() -> super.addNamedPolicies(ptype, rules), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean updateNamedPolicy(String ptype, List<String> params1, List<String> params2) {
        return this.runSynchronized(() -> super.updateNamedPolicy(ptype, params1, params2), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean updateGroupingPolicy(List<String> params1, List<String> params2) {
        return this.runSynchronized(() -> super.updateGroupingPolicy(params1, params2), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean updateNamedGroupingPolicy(String ptype, List<String> params1, List<String> params2) {
        return this.runSynchronized(() -> super.updateNamedGroupingPolicy(ptype, params1, params2), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addNamedPolicy(String ptype, String ... params) {
        return this.runSynchronized(() -> super.addNamedPolicy(ptype, params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removePolicy(List<String> params) {
        return this.runSynchronized(() -> super.removePolicy(params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removePolicy(String ... params) {
        return this.runSynchronized(() -> super.removePolicy(params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removePolicies(List<List<String>> rules) {
        return this.runSynchronized(() -> super.removePolicies(rules), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removePolicies(String[][] rules) {
        return this.runSynchronized(() -> super.removePolicies(rules), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeFilteredPolicy(int fieldIndex, String ... fieldValues) {
        return this.runSynchronized(() -> super.removeFilteredPolicy(fieldIndex, fieldValues), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeNamedPolicy(String ptype, List<String> params) {
        return this.runSynchronized(() -> super.removeNamedPolicy(ptype, params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeNamedPolicy(String ptype, String ... params) {
        return this.runSynchronized(() -> super.removeNamedPolicy(ptype, params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeNamedPolicies(String ptype, List<List<String>> rules) {
        return this.runSynchronized(() -> super.removeNamedPolicies(ptype, rules), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeFilteredNamedPolicy(String ptype, int fieldIndex, String ... fieldValues) {
        return this.runSynchronized(() -> super.removeFilteredNamedPolicy(ptype, fieldIndex, fieldValues), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean hasGroupingPolicy(List<String> params) {
        return this.runSynchronized(() -> super.hasGroupingPolicy(params), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean hasGroupingPolicy(String ... params) {
        return this.runSynchronized(() -> super.hasGroupingPolicy(params), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean hasNamedGroupingPolicy(String ptype, List<String> params) {
        return this.runSynchronized(() -> super.hasNamedGroupingPolicy(ptype, params), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean hasNamedGroupingPolicy(String ptype, String ... params) {
        return this.runSynchronized(() -> super.hasNamedGroupingPolicy(ptype, params), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean addGroupingPolicy(List<String> params) {
        return this.runSynchronized(() -> super.addGroupingPolicy(params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addGroupingPolicy(String ... params) {
        return this.runSynchronized(() -> super.addGroupingPolicy(params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addGroupingPolicies(List<List<String>> rules) {
        return this.runSynchronized(() -> super.addGroupingPolicies(rules), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addGroupingPolicies(String[][] rules) {
        return this.runSynchronized(() -> super.addGroupingPolicies(rules), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addNamedGroupingPolicy(String ptype, List<String> params) {
        return this.runSynchronized(() -> super.addNamedGroupingPolicy(ptype, params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addNamedGroupingPolicy(String ptype, String ... params) {
        return this.runSynchronized(() -> super.addNamedGroupingPolicy(ptype, params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addNamedGroupingPolicies(String ptype, List<List<String>> rules) {
        return this.runSynchronized(() -> super.addNamedGroupingPolicies(ptype, rules), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addNamedGroupingPolicies(String ptype, String[][] rules) {
        return this.runSynchronized(() -> super.addNamedGroupingPolicies(ptype, rules), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeGroupingPolicy(List<String> params) {
        return this.runSynchronized(() -> super.removeGroupingPolicy(params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeGroupingPolicy(String ... params) {
        return this.runSynchronized(() -> super.removeGroupingPolicy(params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeGroupingPolicies(List<List<String>> rules) {
        return this.runSynchronized(() -> super.removeGroupingPolicies(rules), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeGroupingPolicies(String[][] rules) {
        return this.runSynchronized(() -> super.removeGroupingPolicies(rules), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeFilteredGroupingPolicy(int fieldIndex, String ... fieldValues) {
        return this.runSynchronized(() -> super.removeFilteredGroupingPolicy(fieldIndex, fieldValues), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeNamedGroupingPolicy(String ptype, List<String> params) {
        return this.runSynchronized(() -> super.removeNamedGroupingPolicy(ptype, params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeNamedGroupingPolicy(String ptype, String ... params) {
        return this.runSynchronized(() -> super.removeNamedGroupingPolicy(ptype, params), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeNamedGroupingPolicies(String ptype, List<List<String>> rules) {
        return this.runSynchronized(() -> super.removeNamedGroupingPolicies(ptype, rules), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeNamedGroupingPolicies(String ptype, String[][] rules) {
        return this.runSynchronized(() -> super.removeNamedGroupingPolicies(ptype, rules), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean removeFilteredNamedGroupingPolicy(String ptype, int fieldIndex, String ... fieldValues) {
        return this.runSynchronized(() -> super.removeFilteredNamedGroupingPolicy(ptype, fieldIndex, fieldValues), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public List<String> getUsersForRole(String name) {
        return this.runSynchronized(() -> super.getUsersForRole(name), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean hasRoleForUser(String name, String role) {
        return this.runSynchronized(() -> super.hasRoleForUser(name, role), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean addRoleForUser(String user, String role) {
        return this.runSynchronized(() -> super.addRoleForUser(user, role), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean deleteRoleForUser(String user, String role) {
        return this.runSynchronized(() -> super.deleteRoleForUser(user, role), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean deleteRolesForUser(String user) {
        return this.runSynchronized(() -> super.deleteRolesForUser(user), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean deleteUser(String user) {
        return this.runSynchronized(() -> super.deleteUser(user), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public void deleteRole(String role) {
        this.runSynchronized(() -> super.deleteRole(role), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean deletePermission(String ... permission) {
        return this.runSynchronized(() -> super.deletePermission(permission), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean deletePermission(List<String> permission) {
        return this.runSynchronized(() -> super.deletePermission(permission), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addPermissionForUser(String user, String ... permission) {
        return this.runSynchronized(() -> super.addPermissionForUser(user, permission), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean addPermissionForUser(String user, List<String> permission) {
        return this.runSynchronized(() -> super.addPermissionForUser(user, permission), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean deletePermissionForUser(String user, String ... permission) {
        return this.runSynchronized(() -> super.deletePermissionForUser(user, permission), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean deletePermissionForUser(String user, List<String> permission) {
        return this.runSynchronized(() -> super.deletePermissionForUser(user, permission), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean deletePermissionsForUser(String user) {
        return this.runSynchronized(() -> super.deletePermissionsForUser(user), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public List<List<String>> getPermissionsForUser(String user, String ... domain) {
        return this.runSynchronized(() -> super.getPermissionsForUser(user, domain), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<List<String>> getNamedPermissionsForUser(String pType, String user, String ... domain) {
        return this.runSynchronized(() -> super.getNamedPermissionsForUser(pType, user, domain), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean hasPermissionForUser(String user, String ... permission) {
        return this.runSynchronized(() -> super.hasPermissionForUser(user, permission), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean hasPermissionForUser(String user, List<String> permission) {
        return this.runSynchronized(() -> super.hasPermissionForUser(user, permission), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<String> getUsersForRoleInDomain(String name, String domain) {
        return this.runSynchronized(() -> super.getUsersForRoleInDomain(name, domain), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<String> getRolesForUserInDomain(String name, String domain) {
        return this.runSynchronized(() -> super.getRolesForUserInDomain(name, domain), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<List<String>> getPermissionsForUserInDomain(String user, String domain) {
        return this.runSynchronized(() -> super.getPermissionsForUserInDomain(user, domain), READ_WRITE_LOCK.readLock());
    }

    @Override
    public boolean addRoleForUserInDomain(String user, String role, String domain) {
        return this.runSynchronized(() -> super.addRoleForUserInDomain(user, role, domain), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public boolean deleteRoleForUserInDomain(String user, String role, String domain) {
        return this.runSynchronized(() -> super.deleteRoleForUserInDomain(user, role, domain), READ_WRITE_LOCK.writeLock());
    }

    @Override
    public List<String> getImplicitRolesForUser(String name, String ... domain) {
        return this.runSynchronized(() -> super.getImplicitRolesForUser(name, domain), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<List<String>> getImplicitPermissionsForUser(String user, String ... domain) {
        return this.runSynchronized(() -> super.getImplicitPermissionsForUser(user, domain), READ_WRITE_LOCK.readLock());
    }

    @Override
    public List<List<String>> getNamedImplicitPermissionsForUser(String pType, String user, String ... domain) {
        return this.runSynchronized(() -> super.getNamedImplicitPermissionsForUser(pType, user, domain), READ_WRITE_LOCK.readLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runSynchronized(Supplier<T> action, Lock lock) {
        try {
            lock.lock();
            T t = action.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    private void runSynchronized(Runnable action, Lock lock) {
        try {
            lock.lock();
            action.run();
        }
        finally {
            lock.unlock();
        }
    }
}

