/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.casbin.jcasbin.main.ManagementEnforcer;
import org.casbin.jcasbin.model.Assertion;
import org.casbin.jcasbin.model.FunctionMap;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.file_adapter.FileAdapter;

public class Enforcer
extends ManagementEnforcer {
    public Enforcer() {
        this("", "");
    }

    public Enforcer(String modelPath, String policyFile) {
        this(modelPath, (Adapter)new FileAdapter(policyFile));
    }

    public Enforcer(String modelPath, Adapter adapter) {
        this(Enforcer.newModel(modelPath, ""), adapter);
        this.modelPath = modelPath;
    }

    public Enforcer(Model m, Adapter adapter) {
        this.adapter = adapter;
        this.watcher = null;
        this.model = m;
        this.model.printModel();
        this.fm = FunctionMap.loadFunctionMap();
        this.initialize();
        if (this.adapter != null) {
            this.loadPolicy();
        }
    }

    public Enforcer(Model m) {
        this(m, null);
    }

    public Enforcer(String modelPath) {
        this(modelPath, "");
    }

    public Enforcer(String modelPath, String policyFile, boolean enableLog) {
        this(modelPath, (Adapter)new FileAdapter(policyFile));
        this.enableLog(enableLog);
    }

    public List<String> getRolesForUser(String name) {
        try {
            return ((Assertion)((Map)this.model.model.get((Object)"g")).get((Object)"g")).rm.getRoles(name, new String[0]);
        }
        catch (IllegalArgumentException e) {
            if (!"error: name does not exist".equals(e.getMessage())) {
                throw e;
            }
            return Collections.emptyList();
        }
    }

    public List<String> getUsersForRole(String name) {
        try {
            return ((Assertion)((Map)this.model.model.get((Object)"g")).get((Object)"g")).rm.getUsers(name);
        }
        catch (IllegalArgumentException e) {
            if (!"error: name does not exist".equals(e.getMessage())) {
                throw e;
            }
            return Collections.emptyList();
        }
    }

    public boolean hasRoleForUser(String name, String role) {
        List<String> roles = this.getRolesForUser(name);
        boolean hasRole = false;
        for (String r : roles) {
            if (!r.equals(role)) continue;
            hasRole = true;
            break;
        }
        return hasRole;
    }

    public boolean addRoleForUser(String user, String role) {
        return this.addGroupingPolicy(user, role);
    }

    public boolean deleteRoleForUser(String user, String role) {
        return this.removeGroupingPolicy(user, role);
    }

    public boolean deleteRolesForUser(String user) {
        return this.removeFilteredGroupingPolicy(0, user);
    }

    public boolean deleteUser(String user) {
        return this.removeFilteredGroupingPolicy(0, user);
    }

    public void deleteRole(String role) {
        this.removeFilteredGroupingPolicy(1, role);
        this.removeFilteredPolicy(0, role);
    }

    public boolean deletePermission(String ... permission) {
        return this.removeFilteredPolicy(1, permission);
    }

    public boolean deletePermission(List<String> permission) {
        return this.deletePermission(permission.toArray(new String[0]));
    }

    public boolean addPermissionForUser(String user, String ... permission) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(user);
        Collections.addAll(params, permission);
        return this.addPolicy(params);
    }

    public boolean addPermissionForUser(String user, List<String> permission) {
        return this.addPermissionForUser(user, permission.toArray(new String[0]));
    }

    public boolean deletePermissionForUser(String user, String ... permission) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(user);
        Collections.addAll(params, permission);
        return this.removePolicy(params);
    }

    public boolean deletePermissionForUser(String user, List<String> permission) {
        return this.deletePermissionForUser(user, permission.toArray(new String[0]));
    }

    public boolean deletePermissionsForUser(String user) {
        return this.removeFilteredPolicy(0, user);
    }

    public List<List<String>> getPermissionsForUser(String user) {
        return this.getFilteredPolicy(0, user);
    }

    public boolean hasPermissionForUser(String user, String ... permission) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(user);
        Collections.addAll(params, permission);
        return this.hasPolicy(params);
    }

    public boolean hasPermissionForUser(String user, List<String> permission) {
        return this.hasPermissionForUser(user, permission.toArray(new String[0]));
    }

    public List<String> getRolesForUserInDomain(String name, String domain) {
        try {
            return ((Assertion)((Map)this.model.model.get((Object)"g")).get((Object)"g")).rm.getRoles(name, domain);
        }
        catch (IllegalArgumentException e) {
            if (!"error: name does not exist".equals(e.getMessage())) {
                throw e;
            }
            return Collections.emptyList();
        }
    }

    public List<List<String>> getPermissionsForUserInDomain(String user, String domain) {
        return this.getFilteredPolicy(0, user, domain);
    }

    public boolean addRoleForUserInDomain(String user, String role, String domain) {
        return this.addGroupingPolicy(user, role, domain);
    }

    public boolean deleteRoleForUserInDomain(String user, String role, String domain) {
        return this.removeGroupingPolicy(user, role, domain);
    }

    public List<String> getImplicitRolesForUser(String name, String ... domain) {
        List<String> roles = this.rm.getRoles(name, domain);
        ArrayList<String> res = new ArrayList<String>(roles);
        for (String n : roles) {
            res.addAll(this.getImplicitRolesForUser(n, domain));
        }
        return res;
    }

    public List<List<String>> getImplicitPermissionsForUser(String user) {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add(user);
        roles.addAll(this.getImplicitRolesForUser(user, new String[0]));
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        for (String n : roles) {
            res.addAll(this.getPermissionsForUser(n));
        }
        return res;
    }

    public List<List<String>> getImplicitPermissionsForUserInDomain(String user, String domain) {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add(user);
        roles.addAll(this.getImplicitRolesForUser(user, domain));
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        for (String n : roles) {
            res.addAll(this.getPermissionsForUserInDomain(n, domain));
        }
        return res;
    }
}

