/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.persist.file_adapter;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.casbin.jcasbin.exception.CasbinAdapterException;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.Helper;
import org.casbin.jcasbin.persist.file_adapter.FileAdapter;

public class FilteredAdapter
implements Adapter {
    private Adapter adapter;
    private boolean isFiltered = true;
    private String filepath;

    public FilteredAdapter(String filepath) {
        this.adapter = new FileAdapter(filepath);
        this.filepath = filepath;
    }

    public void loadFilteredPolicy(Model model, Object filter) throws CasbinAdapterException {
        if ("".equals(this.filepath)) {
            throw new CasbinAdapterException("Invalid file path, file path cannot be empty.");
        }
        if (filter == null) {
            this.adapter.loadPolicy(model);
            this.isFiltered = false;
            return;
        }
        if (!(filter instanceof Filter)) {
            throw new CasbinAdapterException("Invalid filter type.");
        }
        try {
            this.loadFilteredPolicyFile(model, (Filter)filter, Helper::loadPolicyLine);
            this.isFiltered = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadFilteredPolicyFile(Model model, Filter filter, Helper.loadPolicyLineHandler<String, Model> handler) throws CasbinAdapterException {
        try (FileInputStream fis = new FileInputStream(this.filepath);){
            List lines = IOUtils.readLines((InputStream)fis, (Charset)Charset.forName("UTF-8"));
            for (String line : lines) {
                if (this.filterLine(line = line.trim(), filter)) continue;
                handler.accept(line, model);
            }
        }
        catch (IOException e) {
            throw new CasbinAdapterException("Load policy file error", e.getCause());
        }
    }

    private boolean filterLine(String line, Filter filter) {
        if (filter == null) {
            return false;
        }
        String[] p = line.split(",");
        if (p.length == 0) {
            return true;
        }
        String[] filterSlice = null;
        switch (p[0].trim()) {
            case "p": {
                filterSlice = filter.p;
                break;
            }
            case "g": {
                filterSlice = filter.g;
            }
        }
        if (filterSlice == null) {
            filterSlice = new String[]{};
        }
        return this.filterWords(p, filterSlice);
    }

    private boolean filterWords(String[] line, String[] filter) {
        if (line.length < filter.length + 1) {
            return true;
        }
        boolean skipLine = false;
        int i = 0;
        for (String s : filter) {
            if (s.length() <= 0 || s.trim().equals(line[++i].trim())) continue;
            skipLine = true;
            break;
        }
        return skipLine;
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    @Override
    public void loadPolicy(Model model) {
        this.adapter.loadPolicy(model);
        this.isFiltered = false;
    }

    @Override
    public void savePolicy(Model model) {
        this.adapter.savePolicy(model);
    }

    @Override
    public void addPolicy(String sec, String ptype, List<String> rule) {
        this.adapter.addPolicy(sec, ptype, rule);
    }

    @Override
    public void removePolicy(String sec, String ptype, List<String> rule) {
        this.adapter.removePolicy(sec, ptype, rule);
    }

    @Override
    public void removeFilteredPolicy(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        this.adapter.removeFilteredPolicy(sec, ptype, fieldIndex, fieldValues);
    }

    public static class Filter {
        public String[] p;
        public String[] g;
    }
}

