/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.casbin.jcasbin.main.CoreEnforcer;
import org.casbin.jcasbin.model.Assertion;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.BatchAdapter;
import org.casbin.jcasbin.persist.UpdatableAdapter;
import org.casbin.jcasbin.persist.WatcherEx;
import org.casbin.jcasbin.persist.WatcherUpdatable;
import org.casbin.jcasbin.util.Util;

class InternalEnforcer
extends CoreEnforcer {
    InternalEnforcer() {
    }

    private boolean notifyWatcher(String sec, String ptype, List<List<String>> rules, WatcherEx.UpdateType updateType) {
        if (this.watcher == null || !this.autoNotifyWatcher) {
            return true;
        }
        try {
            if (this.watcher instanceof WatcherEx) {
                switch (updateType) {
                    case UpdateForAddPolicy: {
                        ((WatcherEx)this.watcher).updateForAddPolicy(sec, ptype, rules.get(0).toArray(new String[0]));
                        break;
                    }
                    case UpdateForRemovePolicy: {
                        ((WatcherEx)this.watcher).updateForRemovePolicy(sec, ptype, rules.get(0).toArray(new String[0]));
                        break;
                    }
                    case UpdateForAddPolicies: {
                        ((WatcherEx)this.watcher).updateForAddPolicies(sec, ptype, rules);
                        break;
                    }
                    case UpdateForRemovePolicies: {
                        ((WatcherEx)this.watcher).updateForRemovePolicies(sec, ptype, rules);
                        break;
                    }
                    default: {
                        Util.logPrint("UnsupportedUpdateType for notifyWatcher");
                        break;
                    }
                }
            } else {
                this.watcher.update();
            }
        }
        catch (Exception e) {
            Util.logPrint("An exception occurred:" + e.getMessage());
            return false;
        }
        return true;
    }

    boolean addPolicy(String sec, String ptype, List<String> rule) {
        if (this.mustUseDispatcher()) {
            this.dispatcher.addPolicies(sec, ptype, Collections.singletonList(rule));
            return true;
        }
        if (this.model.hasPolicy(sec, ptype, rule)) {
            return false;
        }
        if (this.adapter != null && this.autoSave) {
            try {
                this.adapter.addPolicy(sec, ptype, rule);
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
        }
        this.model.addPolicy(sec, ptype, rule);
        this.buildIncrementalRoleLinks(sec, ptype, Collections.singletonList(rule), Model.PolicyOperations.POLICY_ADD);
        return this.notifyWatcher(sec, ptype, Collections.singletonList(rule), WatcherEx.UpdateType.UpdateForAddPolicy);
    }

    boolean addPolicies(String sec, String ptype, List<List<String>> rules) {
        if (this.mustUseDispatcher()) {
            this.dispatcher.addPolicies(sec, ptype, rules);
            return true;
        }
        if (this.model.hasPolicies(sec, ptype, rules)) {
            return false;
        }
        if (this.adapter != null && this.autoSave) {
            try {
                if (this.adapter instanceof BatchAdapter) {
                    ((BatchAdapter)this.adapter).addPolicies(sec, ptype, rules);
                }
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
        }
        this.model.addPolicies(sec, ptype, rules);
        this.buildIncrementalRoleLinks(sec, ptype, rules, Model.PolicyOperations.POLICY_ADD);
        return this.notifyWatcher(sec, ptype, rules, WatcherEx.UpdateType.UpdateForAddPolicies);
    }

    public void buildIncrementalRoleLinks(Model.PolicyOperations op, String ptype, List<List<String>> rules) {
        this.model.buildIncrementalRoleLinks(this.rmMap, op, "g", ptype, rules);
    }

    boolean removePolicy(String sec, String ptype, List<String> rule) {
        boolean ruleRemoved;
        if (this.mustUseDispatcher()) {
            this.dispatcher.removePolicies(sec, ptype, Collections.singletonList(rule));
            return true;
        }
        if (this.adapter != null && this.autoSave) {
            try {
                this.adapter.removePolicy(sec, ptype, rule);
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
        }
        if (!(ruleRemoved = this.model.removePolicy(sec, ptype, rule))) {
            return false;
        }
        this.buildIncrementalRoleLinks(sec, ptype, Collections.singletonList(rule), Model.PolicyOperations.POLICY_REMOVE);
        return this.notifyWatcher(sec, ptype, Collections.singletonList(rule), WatcherEx.UpdateType.UpdateForRemovePolicy);
    }

    boolean updatePolicy(String sec, String ptype, List<String> oldRule, List<String> newRule) {
        boolean ruleUpdated;
        if (this.mustUseDispatcher()) {
            this.dispatcher.updatePolicy(sec, ptype, oldRule, newRule);
            return true;
        }
        if (this.adapter != null && this.autoSave && this.adapter instanceof UpdatableAdapter) {
            try {
                ((UpdatableAdapter)this.adapter).updatePolicy(sec, ptype, oldRule, newRule);
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
        }
        if (!(ruleUpdated = this.model.updatePolicy(sec, ptype, oldRule, newRule))) {
            return false;
        }
        if ("g".equals(sec)) {
            try {
                ArrayList<List<String>> oldRules = new ArrayList<List<String>>();
                oldRules.add(oldRule);
                this.buildIncrementalRoleLinks(Model.PolicyOperations.POLICY_REMOVE, ptype, oldRules);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
            try {
                ArrayList<List<String>> newRules = new ArrayList<List<String>>();
                newRules.add(newRule);
                this.buildIncrementalRoleLinks(Model.PolicyOperations.POLICY_ADD, ptype, newRules);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
        }
        if (this.watcher != null && this.autoNotifyWatcher) {
            try {
                if (this.watcher instanceof WatcherUpdatable) {
                    ((WatcherUpdatable)this.watcher).updateForUpdatePolicy(oldRule, newRule);
                } else {
                    this.watcher.update();
                }
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
        }
        return true;
    }

    boolean removePolicies(String sec, String ptype, List<List<String>> rules) {
        boolean rulesRemoved;
        if (this.mustUseDispatcher()) {
            this.dispatcher.removePolicies(sec, ptype, rules);
            return true;
        }
        if (!this.model.hasPolicies(sec, ptype, rules)) {
            return false;
        }
        if (this.adapter != null && this.autoSave) {
            try {
                if (this.adapter instanceof BatchAdapter) {
                    ((BatchAdapter)this.adapter).removePolicies(sec, ptype, rules);
                }
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
        }
        if (!(rulesRemoved = this.model.removePolicies(sec, ptype, rules))) {
            return false;
        }
        this.buildIncrementalRoleLinks(sec, ptype, rules, Model.PolicyOperations.POLICY_REMOVE);
        return this.notifyWatcher(sec, ptype, rules, WatcherEx.UpdateType.UpdateForRemovePolicies);
    }

    boolean removeFilteredPolicy(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        List<List<String>> effects;
        boolean ruleRemoved;
        if (this.mustUseDispatcher()) {
            this.dispatcher.removeFilteredPolicy(sec, ptype, fieldIndex, fieldValues);
            return true;
        }
        if (fieldValues == null || fieldValues.length == 0) {
            Util.logPrint("Invalid fieldValues parameter");
            return false;
        }
        if (this.adapter != null && this.autoSave) {
            try {
                this.adapter.removeFilteredPolicy(sec, ptype, fieldIndex, fieldValues);
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
        }
        boolean bl = ruleRemoved = (effects = this.model.removeFilteredPolicyReturnsEffects(sec, ptype, fieldIndex, fieldValues)).size() > 0;
        if (!ruleRemoved) {
            return false;
        }
        this.buildIncrementalRoleLinks(sec, ptype, effects, Model.PolicyOperations.POLICY_REMOVE);
        if (this.watcher != null && this.autoNotifyWatcher) {
            if (this.watcher instanceof WatcherEx) {
                ((WatcherEx)this.watcher).updateForRemoveFilteredPolicy(sec, ptype, fieldIndex, fieldValues);
            } else {
                this.watcher.update();
            }
        }
        return true;
    }

    int getDomainIndex(String ptype) {
        Assertion ast = (Assertion)((Map)this.model.model.get("p")).get(ptype);
        String pattern = String.format("%s_dom", ptype);
        int index = ast.tokens.length;
        for (int i = 0; i < ast.tokens.length; ++i) {
            if (!ast.tokens[i].equals(pattern)) continue;
            index = i;
            break;
        }
        return index;
    }

    private void buildIncrementalRoleLinks(String sec, String ptype, List<List<String>> rules, Model.PolicyOperations operation) {
        if ("g".equals(sec)) {
            this.buildIncrementalRoleLinks(operation, ptype, rules);
        }
    }
}

