/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.main;

import java.util.ArrayList;
import java.util.List;
import org.casbin.jcasbin.main.CoreEnforcer;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.BatchAdapter;
import org.casbin.jcasbin.persist.WatcherEx;
import org.casbin.jcasbin.util.Util;

class InternalEnforcer
extends CoreEnforcer {
    InternalEnforcer() {
    }

    boolean addPolicy(String sec, String ptype, List<String> rule) {
        if (this.model.hasPolicy(sec, ptype, rule)) {
            return false;
        }
        if (this.adapter != null && this.autoSave) {
            try {
                this.adapter.addPolicy(sec, ptype, rule);
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
        }
        this.model.addPolicy(sec, ptype, rule);
        if (sec.equals("g")) {
            ArrayList<List<String>> rules = new ArrayList<List<String>>();
            rules.add(rule);
            this.buildIncrementalRoleLinks(Model.PolicyOperations.POLICY_ADD, ptype, rules);
        }
        if (this.watcher != null && this.autoNotifyWatcher) {
            if (this.watcher instanceof WatcherEx) {
                ((WatcherEx)this.watcher).updateForAddPolicy(rule.toArray(new String[0]));
            } else {
                this.watcher.update();
            }
        }
        return true;
    }

    boolean addPolicies(String sec, String ptype, List<List<String>> rules) {
        if (this.model.hasPolicies(sec, ptype, rules)) {
            return false;
        }
        if (this.adapter != null && this.autoSave) {
            try {
                if (this.adapter instanceof BatchAdapter) {
                    ((BatchAdapter)this.adapter).addPolicies(sec, ptype, rules);
                }
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
        }
        this.model.addPolicies(sec, ptype, rules);
        if (sec.equals("g")) {
            this.buildIncrementalRoleLinks(Model.PolicyOperations.POLICY_ADD, ptype, rules);
        }
        if (this.watcher != null && this.autoNotifyWatcher) {
            this.watcher.update();
        }
        return true;
    }

    public void buildIncrementalRoleLinks(Model.PolicyOperations op, String ptype, List<List<String>> rules) {
        this.model.buildIncrementalRoleLinks(this.rm, op, "g", ptype, rules);
    }

    boolean removePolicy(String sec, String ptype, List<String> rule) {
        boolean ruleRemoved;
        if (this.adapter != null && this.autoSave) {
            try {
                this.adapter.removePolicy(sec, ptype, rule);
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
        }
        if (!(ruleRemoved = this.model.removePolicy(sec, ptype, rule))) {
            return false;
        }
        if (sec.equals("g")) {
            ArrayList<List<String>> rules = new ArrayList<List<String>>();
            rules.add(rule);
            this.buildIncrementalRoleLinks(Model.PolicyOperations.POLICY_REMOVE, ptype, rules);
        }
        if (this.watcher != null && this.autoNotifyWatcher) {
            if (this.watcher instanceof WatcherEx) {
                ((WatcherEx)this.watcher).updateForRemovePolicy(rule.toArray(new String[0]));
            } else {
                this.watcher.update();
            }
        }
        return true;
    }

    boolean removePolicies(String sec, String ptype, List<List<String>> rules) {
        boolean rulesRemoved;
        if (this.model.hasPolicies(sec, ptype, rules)) {
            return false;
        }
        if (this.adapter != null && this.autoSave) {
            try {
                if (this.adapter instanceof BatchAdapter) {
                    ((BatchAdapter)this.adapter).removePolicies(sec, ptype, rules);
                }
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
        }
        if (!(rulesRemoved = this.model.removePolicies(sec, ptype, rules))) {
            return false;
        }
        if (sec.equals("g")) {
            this.buildIncrementalRoleLinks(Model.PolicyOperations.POLICY_REMOVE, ptype, rules);
        }
        if (this.watcher != null && this.autoNotifyWatcher) {
            this.watcher.update();
        }
        return true;
    }

    boolean removeFilteredPolicy(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        List<List<String>> effects;
        boolean ruleRemoved;
        if (fieldValues == null || fieldValues.length == 0) {
            Util.logPrint("Invaild fieldValues parameter");
            return false;
        }
        if (this.adapter != null && this.autoSave) {
            try {
                this.adapter.removeFilteredPolicy(sec, ptype, fieldIndex, fieldValues);
            }
            catch (UnsupportedOperationException ignored) {
                Util.logPrintf("Method not implemented", new String[0]);
            }
            catch (Exception e) {
                Util.logPrint("An exception occurred:" + e.getMessage());
                return false;
            }
        }
        boolean bl = ruleRemoved = (effects = this.model.removeFilteredPolicyReturnsEffects(sec, ptype, fieldIndex, fieldValues)).size() > 0;
        if (!ruleRemoved) {
            return false;
        }
        if (sec.equals("g")) {
            this.buildIncrementalRoleLinks(Model.PolicyOperations.POLICY_REMOVE, ptype, effects);
        }
        if (this.watcher != null && this.autoNotifyWatcher) {
            if (this.watcher instanceof WatcherEx) {
                ((WatcherEx)this.watcher).updateForRemoveFilteredPolicy(fieldIndex, fieldValues);
            } else {
                this.watcher.update();
            }
        }
        return true;
    }
}

