/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.util;

import bsh.EvalError;
import bsh.Interpreter;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.casbin.jcasbin.rbac.RoleManager;

public class BuiltInFunctions {
    private static Pattern keyMatch2Pattern = Pattern.compile("(.*):[^/]+(.*)");
    private static Pattern keyMatch3Pattern = Pattern.compile("(.*)\\{[^/]+}(.*)");
    private static final Interpreter interpreter = new Interpreter();

    public static boolean keyMatch(String key1, String key2) {
        int i = key2.indexOf(42);
        if (i == -1) {
            return key1.equals(key2);
        }
        if (key1.length() > i) {
            return key1.substring(0, i).equals(key2.substring(0, i));
        }
        return key1.equals(key2.substring(0, i));
    }

    public static boolean keyMatch2(String key1, String key2) {
        key2 = key2.replace("/*", "/.*");
        while (key2.contains("/:")) {
            key2 = "^" + keyMatch2Pattern.matcher(key2).replaceAll("$1[^/]+$2") + "$";
        }
        return BuiltInFunctions.regexMatch(key1, key2);
    }

    public static boolean keyMatch3(String key1, String key2) {
        key2 = key2.replace("/*", "/.*");
        while (key2.contains("/{")) {
            key2 = keyMatch3Pattern.matcher(key2).replaceAll("$1[^/]+$2");
        }
        return BuiltInFunctions.regexMatch(key1, key2);
    }

    public static boolean keyMatch4(String key1, String key2) {
        String regEx = "\\{[^/]+}";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(key2);
        String[] tmp = p.split(key2);
        ArrayList<String> tokens = new ArrayList<String>();
        if (tmp.length > 0) {
            for (int count = 0; count < tmp.length; ++count) {
                tokens.add(tmp[count]);
                if (!m.find()) continue;
                tokens.add(m.group());
            }
        }
        int off = 0;
        for (String token : tokens) {
            if (p.matcher(token).matches()) continue;
            while (off < key1.length() && key1.charAt(off) != token.charAt(0)) {
                ++off;
            }
            if (key1.length() - (off + 1) < token.length()) {
                return false;
            }
            if (!key1.substring(off, off + token.length()).equals(token)) {
                return false;
            }
            key1 = key1.replaceFirst(token, ",");
        }
        String[] values = key1.split(",");
        int i = 0;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String token : tokens) {
            if (!p.matcher(token).matches()) continue;
            while (i < values.length && values[i].equals("")) {
                ++i;
            }
            if (i == values.length) {
                return false;
            }
            if (params.containsKey(token)) {
                if (!values[i].equals(params.get(token))) {
                    return false;
                }
            } else {
                params.put(token, values[i]);
            }
            ++i;
        }
        return true;
    }

    public static boolean regexMatch(String key1, String key2) {
        return Pattern.matches(key2, key1);
    }

    public static boolean ipMatch(String ip1, String ip2) {
        IPAddress ipa2;
        IPAddress ipa1;
        IPAddressString ipas1 = new IPAddressString(ip1);
        try {
            ipas1.validateIPv4();
        }
        catch (AddressStringException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("invalid argument: ip1 in IPMatch() function is not an IP address.");
        }
        IPAddressString ipas2 = new IPAddressString(ip2);
        try {
            ipas2.validate();
        }
        catch (AddressStringException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("invalid argument: ip2 in IPMatch() function is neither an IP address nor a CIDR.");
        }
        if (ipas1.equals((Object)ipas2)) {
            return true;
        }
        try {
            ipa1 = ipas1.toAddress();
            ipa2 = ipas2.toAddress();
        }
        catch (AddressStringException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("invalid argument: ip1 or ip2 in IPMatch() function is not an IP address.");
        }
        Integer prefix = ipa2.getNetworkPrefixLength();
        IPAddress mask = ipa2.getNetwork().getNetworkMask(prefix.intValue(), false);
        return ipa1.mask(mask).equals((Object)ipas2.getHostAddress());
    }

    public static boolean allMatch(String key1, String key2) {
        if ("*".equals(key1) || "*".equals(key2)) {
            return true;
        }
        return key1.equals(key2);
    }

    public static AviatorFunction generateGFunction(final String name, final RoleManager rm) {
        return new AbstractFunction(){

            public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
                String name1 = FunctionUtils.getStringValue((AviatorObject)arg1, env);
                String name2 = FunctionUtils.getStringValue((AviatorObject)arg2, env);
                if (rm == null) {
                    return AviatorBoolean.valueOf((boolean)name1.equals(name2));
                }
                boolean res = rm.hasLink(name1, name2, new String[0]);
                return AviatorBoolean.valueOf((boolean)res);
            }

            public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2, AviatorObject arg3) {
                String name1 = FunctionUtils.getStringValue((AviatorObject)arg1, env);
                String name2 = FunctionUtils.getStringValue((AviatorObject)arg2, env);
                if (rm == null) {
                    return AviatorBoolean.valueOf((boolean)name1.equals(name2));
                }
                String domain = FunctionUtils.getStringValue((AviatorObject)arg3, env);
                boolean res = rm.hasLink(name1, name2, domain);
                return AviatorBoolean.valueOf((boolean)res);
            }

            public String getName() {
                return name;
            }
        };
    }

    public static boolean eval(String eval, Map<String, Object> env) {
        Map<String, Map<String, Object>> evalModels = BuiltInFunctions.getEvalModels(env);
        try {
            for (Map.Entry<String, Map<String, Object>> entry : evalModels.entrySet()) {
                interpreter.set(entry.getKey(), entry.getValue());
            }
            ArrayList<String> sortedSrc = new ArrayList<String>(BuiltInFunctions.getReplaceTargets(evalModels));
            sortedSrc.sort((o1, o2) -> o1.length() > o2.length() ? -1 : 1);
            for (String s : sortedSrc) {
                eval = eval.replace("." + s, ".get(\"" + s + "\")");
            }
            return (Boolean)interpreter.eval(eval);
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
            return false;
        }
    }

    private static Map<String, Map<String, Object>> getEvalModels(Map<String, Object> env) {
        HashMap<String, Map<String, Object>> evalModels = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Object> entry : env.entrySet()) {
            String[] names = entry.getKey().split("_");
            evalModels.computeIfAbsent(names[0], k -> new HashMap()).put(names[1], entry.getValue());
        }
        return evalModels;
    }

    private static Set<String> getReplaceTargets(Map<String, Map<String, Object>> evalModels) {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<String, Map<String, Object>> entry : evalModels.entrySet()) {
            ret.addAll(entry.getValue().keySet());
        }
        return ret;
    }
}

