/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.model;

import java.util.ArrayList;
import java.util.List;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.rbac.RoleManager;
import org.casbin.jcasbin.util.Util;

public class Assertion {
    public String key;
    public String value;
    public String[] tokens;
    public List<List<String>> policy = new ArrayList<List<String>>();
    public RoleManager rm;

    protected void buildRoleLinks(RoleManager rm) {
        this.rm = rm;
        int count = 0;
        for (int i = 0; i < this.value.length(); ++i) {
            if (this.value.charAt(i) != '_') continue;
            ++count;
        }
        for (List<String> rule : this.policy) {
            if (count < 2) {
                throw new IllegalArgumentException("the number of \"_\" in role definition should be at least 2");
            }
            if (rule.size() < count) {
                throw new IllegalArgumentException("grouping policy elements do not meet role definition");
            }
            if (count == 2) {
                rm.addLink(rule.get(0), rule.get(1), new String[0]);
                continue;
            }
            if (count == 3) {
                rm.addLink(rule.get(0), rule.get(1), rule.get(2));
                continue;
            }
            if (count != 4) continue;
            rm.addLink(rule.get(0), rule.get(1), rule.get(2), rule.get(3));
        }
        Util.logPrint("Role links for: " + this.key);
        rm.printRoles();
    }

    public void buildIncrementalRoleLinks(RoleManager rm, Model.PolicyOperations op, List<List<String>> rules) {
        this.rm = rm;
        int count = 0;
        for (int i = 0; i < this.value.length(); ++i) {
            if (this.value.charAt(i) != '_') continue;
            ++count;
        }
        block5: for (List<String> rule : rules) {
            if (count < 2) {
                throw new IllegalArgumentException("the number of \"_\" in role definition should be at least 2");
            }
            if (rule.size() < count) {
                throw new IllegalArgumentException("grouping policy elements do not meet role definition");
            }
            if (rule.size() > count) {
                rule = rule.subList(0, count);
            }
            switch (op) {
                case POLICY_ADD: {
                    rm.addLink(rule.get(0), rule.get(1), rule.subList(2, rule.size()).toArray(new String[0]));
                    continue block5;
                }
                case POLICY_REMOVE: {
                    rm.deleteLink(rule.get(0), rule.get(1), rule.subList(2, rule.size()).toArray(new String[0]));
                    continue block5;
                }
            }
            throw new IllegalArgumentException("invalid operation:" + op.toString());
        }
    }
}

