/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.EnvProcessor;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.exception.ExpressionNotFoundException;
import com.googlecode.aviator.lexer.SymbolTable;
import com.googlecode.aviator.lexer.token.Variable;
import com.googlecode.aviator.parser.VariableMeta;
import com.googlecode.aviator.runtime.FunctionArgument;
import com.googlecode.aviator.runtime.LambdaFunctionBootstrap;
import com.googlecode.aviator.runtime.function.LambdaFunction;
import com.googlecode.aviator.utils.Constants;
import com.googlecode.aviator.utils.Env;
import com.googlecode.aviator.utils.Reflector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public abstract class BaseExpression
implements Expression {
    public static final String FUNC_PARAMS_VAR = "__funcs_args__";
    protected List<String> varNames;
    protected List<String> varFullNames;
    private final List<VariableMeta> vars;
    private String expression;
    protected AviatorEvaluatorInstance instance;
    private Env compileEnv;
    private Map<Integer, List<FunctionArgument>> funcsArgs = Collections.emptyMap();
    protected SymbolTable symbolTable;
    private final ConcurrentHashMap<String, FutureTask<AviatorEvaluatorInstance.StringSegments>> stringSegs = new ConcurrentHashMap();
    protected String sourceFile;
    protected Map<String, LambdaFunctionBootstrap> lambdaBootstraps;

    @Override
    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public BaseExpression(AviatorEvaluatorInstance instance, List<VariableMeta> vars, SymbolTable symbolTable) {
        this.vars = vars;
        this.symbolTable = symbolTable;
        this.instance = instance;
    }

    private void populateNames() {
        if (this.varNames == null) {
            if (this.varFullNames == null) {
                this.populateFullNames();
            }
            ArrayList<String> newVarNames = new ArrayList<String>(this.varFullNames.size());
            HashSet<String> nameSet = new HashSet<String>();
            HashSet<String> parentInitNames = new HashSet<String>();
            for (VariableMeta m : this.vars) {
                if (!m.isInit() || m.getName().contains(".") || m.getFirstIndex() < 0) continue;
                parentInitNames.add(m.getName());
            }
            for (String fName : this.varFullNames) {
                String[] tmps = Constants.SPLIT_PAT.split(fName);
                String sName = tmps[0];
                if (nameSet.contains(sName) || parentInitNames.contains(sName)) continue;
                newVarNames.add(sName);
                nameSet.add(sName);
            }
            this.varNames = newVarNames;
        }
    }

    protected void afterPopulateFullNames(Map<String, VariableMeta> fullNames, Set<String> parentVars) {
        if (this.lambdaBootstraps != null && !this.lambdaBootstraps.isEmpty()) {
            for (LambdaFunctionBootstrap bootstrap : this.lambdaBootstraps.values()) {
                for (VariableMeta meta : bootstrap.getClosureOverFullVarNames()) {
                    VariableMeta existsMeta = fullNames.get(meta.getName());
                    if (existsMeta == null) {
                        if (parentVars.contains(meta.getName())) continue;
                        fullNames.put(meta.getName(), meta);
                        continue;
                    }
                    if (existsMeta.getFirstIndex() <= meta.getFirstIndex()) continue;
                    fullNames.put(meta.getName(), meta);
                }
            }
        }
    }

    private void populateFullNames() {
        if (this.varFullNames == null) {
            Map<String, VariableMeta> fullNames = this.getFullNameMetas();
            ArrayList<VariableMeta> metas = new ArrayList<VariableMeta>(fullNames.values());
            Collections.sort(metas, new Comparator<VariableMeta>(){

                @Override
                public int compare(VariableMeta o1, VariableMeta o2) {
                    return Integer.compare(o1.getFirstIndex(), o2.getFirstIndex());
                }
            });
            ArrayList<String> newFullNames = new ArrayList<String>(fullNames.size());
            for (VariableMeta meta : metas) {
                newFullNames.add(meta.getName());
            }
            this.varFullNames = newFullNames;
        }
    }

    public Map<String, VariableMeta> getFullNameMetas() {
        LinkedHashMap<String, VariableMeta> fullNames = new LinkedHashMap<String, VariableMeta>(this.vars.size());
        HashSet<String> parentVars = new HashSet<String>(this.vars.size());
        for (VariableMeta m : this.vars) {
            if (!m.isInit() && m.getFirstIndex() >= 0) {
                fullNames.put(m.getName(), m);
            }
            parentVars.add(m.getName());
        }
        this.afterPopulateFullNames(fullNames, parentVars);
        return fullNames;
    }

    public AviatorEvaluatorInstance.StringSegments getStringSegements(final String lexeme, final int lineNo) {
        FutureTask<AviatorEvaluatorInstance.StringSegments> task = this.stringSegs.get(lexeme);
        if (task == null) {
            task = new FutureTask<AviatorEvaluatorInstance.StringSegments>(new Callable<AviatorEvaluatorInstance.StringSegments>(){

                @Override
                public AviatorEvaluatorInstance.StringSegments call() throws Exception {
                    AviatorEvaluatorInstance.StringSegments compiledSegs = BaseExpression.this.instance.compileStringSegments(lexeme, BaseExpression.this.sourceFile, lineNo);
                    return compiledSegs;
                }
            });
            FutureTask<AviatorEvaluatorInstance.StringSegments> existsTask = this.stringSegs.putIfAbsent(lexeme, task);
            if (existsTask != null) {
                task = existsTask;
            } else {
                task.run();
            }
        }
        try {
            return task.get();
        }
        catch (ExecutionException t) {
            throw Reflector.sneakyThrow(t.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Reflector.sneakyThrow(e);
        }
    }

    @Override
    public Map<String, Object> newEnv(Object ... args) {
        if (args != null && args.length % 2 != 0) {
            throw new IllegalArgumentException("Expect arguments number is even.");
        }
        SymbolHashMap env = new SymbolHashMap(args != null ? args.length : 10);
        if (args != null) {
            for (int i = 0; i < args.length; i += 2) {
                String key = (String)args[i];
                env.put(key, args[i + 1]);
            }
        }
        return env;
    }

    public abstract Object executeDirectly(Map<String, Object> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Map<String, Object> map) {
        if (map == null) {
            map = Collections.emptyMap();
        }
        Env env = this.genTopEnv(map);
        EnvProcessor envProcessor = this.instance.getEnvProcessor();
        if (envProcessor != null) {
            envProcessor.beforeExecute(env, this);
        }
        try {
            Object object = this.executeDirectly(env);
            return object;
        }
        finally {
            if (envProcessor != null) {
                envProcessor.afterExecute(env, this);
            }
        }
    }

    public void setFuncsArgs(Map<Integer, List<FunctionArgument>> funcsArgs) {
        if (funcsArgs != null) {
            this.funcsArgs = Collections.unmodifiableMap(funcsArgs);
        }
    }

    public Env getCompileEnv() {
        return this.compileEnv;
    }

    public void setCompileEnv(Env compileEnv) {
        this.compileEnv = compileEnv;
        this.compileEnv.setExpression(this);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public String addSymbol(String name) {
        if (this.symbolTable != null) {
            return this.symbolTable.reserve(name).getLexeme();
        }
        return name;
    }

    @Override
    public Object execute() {
        return this.execute(null);
    }

    @Override
    public List<String> getVariableFullNames() {
        this.populateFullNames();
        return this.varFullNames;
    }

    public List<VariableMeta> getVars() {
        return this.vars;
    }

    @Override
    public List<String> getVariableNames() {
        this.populateNames();
        return this.varNames;
    }

    protected Env newEnv(Map<String, Object> map, boolean direct) {
        Env env = direct ? new Env(map, map == Collections.EMPTY_MAP ? new HashMap() : map) : new Env(map);
        env.configure(this.instance, this);
        return env;
    }

    protected Env genTopEnv(Map<String, Object> map) {
        if (map instanceof Env) {
            ((Env)map).configure(this.instance, this);
        }
        Env env = this.newEnv(map, this.instance.getOptionValue((Options)Options.USE_USER_ENV_AS_TOP_ENV_DIRECTLY).bool);
        if (this.compileEnv != null && !this.compileEnv.isEmpty()) {
            env.putAll((Map)this.compileEnv);
        }
        if (!this.funcsArgs.isEmpty()) {
            env.override(FUNC_PARAMS_VAR, this.funcsArgs);
        }
        return env;
    }

    protected Env newEnv(Map<String, Object> map) {
        return this.newEnv(map, false);
    }

    public Map<String, LambdaFunctionBootstrap> getLambdaBootstraps() {
        return this.lambdaBootstraps;
    }

    public void setLambdaBootstraps(Map<String, LambdaFunctionBootstrap> lambdaBootstraps) {
        this.lambdaBootstraps = lambdaBootstraps;
    }

    public LambdaFunction newLambda(Env env, String name) {
        LambdaFunctionBootstrap bootstrap = this.lambdaBootstraps.get(name);
        if (bootstrap == null) {
            throw new ExpressionNotFoundException("Lambda " + name + " not found");
        }
        return bootstrap.newInstance(env);
    }

    private class SymbolHashMap
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 5951510458689965590L;

        public SymbolHashMap(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public Object put(String key, Object value) {
            Variable var = null;
            if (BaseExpression.this.symbolTable != null && (var = BaseExpression.this.symbolTable.getVariable(key)) != null) {
                key = var.getLexeme();
            }
            return super.put(key, value);
        }
    }
}

