/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.casbin.jcasbin.model.Assertion;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.rbac.RoleManager;
import org.casbin.jcasbin.util.Util;

public class Policy {
    public Map<String, Map<String, Assertion>> model;

    public void buildRoleLinks(RoleManager rm) {
        if (this.model.containsKey("g")) {
            for (Assertion ast : this.model.get("g").values()) {
                ast.buildRoleLinks(rm);
            }
        }
    }

    public void printPolicy() {
        Assertion ast;
        String key;
        Util.logPrint("Policy:");
        if (this.model.containsKey("p")) {
            for (Map.Entry<String, Assertion> entry : this.model.get("p").entrySet()) {
                key = entry.getKey();
                ast = entry.getValue();
                Util.logPrint(key + ": " + ast.value + ": " + ast.policy);
            }
        }
        if (this.model.containsKey("g")) {
            for (Map.Entry<String, Assertion> entry : this.model.get("g").entrySet()) {
                key = entry.getKey();
                ast = entry.getValue();
                Util.logPrint(key + ": " + ast.value + ": " + ast.policy);
            }
        }
    }

    public String savePolicyToText() {
        Assertion ast;
        String key;
        StringBuilder res = new StringBuilder();
        if (this.model.containsKey("p")) {
            for (Map.Entry<String, Assertion> entry : this.model.get("p").entrySet()) {
                key = entry.getKey();
                ast = entry.getValue();
                for (List<String> rule : ast.policy) {
                    res.append(String.format("%s, %s\n", key, String.join((CharSequence)", ", rule)));
                }
            }
        }
        if (this.model.containsKey("g")) {
            for (Map.Entry<String, Assertion> entry : this.model.get("g").entrySet()) {
                key = entry.getKey();
                ast = entry.getValue();
                for (List<String> rule : ast.policy) {
                    res.append(String.format("%s, %s\n", key, String.join((CharSequence)", ", rule)));
                }
            }
        }
        return res.toString();
    }

    public void clearPolicy() {
        if (this.model.containsKey("p")) {
            for (Assertion ast : this.model.get("p").values()) {
                ast.policy = new ArrayList<List<String>>();
            }
        }
        if (this.model.containsKey("g")) {
            for (Assertion ast : this.model.get("g").values()) {
                ast.policy = new ArrayList<List<String>>();
            }
        }
    }

    public List<List<String>> getPolicy(String sec, String ptype) {
        return this.model.get((Object)sec).get((Object)ptype).policy;
    }

    public List<List<String>> getFilteredPolicy(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        for (List<String> rule : this.model.get((Object)sec).get((Object)ptype).policy) {
            boolean matched = true;
            for (int i = 0; i < fieldValues.length; ++i) {
                String fieldValue = fieldValues[i];
                if (fieldValue.equals("") || rule.get(fieldIndex + i).equals(fieldValue)) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            res.add(rule);
        }
        return res;
    }

    public boolean hasPolicy(String sec, String ptype, List<String> rule) {
        for (List<String> r : this.model.get((Object)sec).get((Object)ptype).policy) {
            if (!Util.arrayEquals(rule, r)) continue;
            return true;
        }
        return false;
    }

    public boolean addPolicy(String sec, String ptype, List<String> rule) {
        if (!this.hasPolicy(sec, ptype, rule)) {
            Assertion assertion = this.model.get(sec).get(ptype);
            List<List<String>> policy = assertion.policy;
            if ("p".equals(sec) && (ptype + "_priority").equals(assertion.tokens[0])) {
                int value = Integer.parseInt(rule.get(0));
                int left = 0;
                int right = policy.size();
                while (left < right) {
                    int mid = left + right >>> 1;
                    if (value > Integer.parseInt(policy.get(mid).get(0))) {
                        left = mid + 1;
                        continue;
                    }
                    right = mid;
                }
                policy.add(left, rule);
            } else {
                policy.add(rule);
            }
            return true;
        }
        return false;
    }

    public boolean addPolicies(String sec, String ptype, List<List<String>> rules) {
        int size = this.model.get((Object)sec).get((Object)ptype).policy.size();
        for (List<String> rule : rules) {
            if (this.hasPolicy(sec, ptype, rule)) continue;
            this.model.get((Object)sec).get((Object)ptype).policy.add(rule);
        }
        return size < this.model.get((Object)sec).get((Object)ptype).policy.size();
    }

    public boolean updatePolicy(String sec, String ptype, List<String> oldRule, List<String> newRule) {
        if (!this.hasPolicy(sec, ptype, oldRule)) {
            return false;
        }
        this.model.get((Object)sec).get((Object)ptype).policy.remove(oldRule);
        this.model.get((Object)sec).get((Object)ptype).policy.add(newRule);
        return true;
    }

    public boolean removePolicy(String sec, String ptype, List<String> rule) {
        for (int i = 0; i < this.model.get((Object)sec).get((Object)ptype).policy.size(); ++i) {
            List<String> r = this.model.get((Object)sec).get((Object)ptype).policy.get(i);
            if (!Util.arrayEquals(rule, r)) continue;
            this.model.get((Object)sec).get((Object)ptype).policy.remove(i);
            return true;
        }
        return false;
    }

    public boolean removePolicies(String sec, String ptype, List<List<String>> rules) {
        int size = this.model.get((Object)sec).get((Object)ptype).policy.size();
        for (List<String> rule : rules) {
            for (int i = 0; i < this.model.get((Object)sec).get((Object)ptype).policy.size(); ++i) {
                List<String> r = this.model.get((Object)sec).get((Object)ptype).policy.get(i);
                if (!Util.arrayEquals(rule, r)) continue;
                this.model.get((Object)sec).get((Object)ptype).policy.remove(i);
            }
        }
        return size > this.model.get((Object)sec).get((Object)ptype).policy.size();
    }

    public List<List<String>> removeFilteredPolicyReturnsEffects(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        ArrayList<List<String>> tmp = new ArrayList<List<String>>();
        ArrayList<List<String>> effects = new ArrayList<List<String>>();
        int firstIndex = -1;
        for (List<String> rule : this.model.get((Object)sec).get((Object)ptype).policy) {
            boolean matched = true;
            for (int i = 0; i < fieldValues.length; ++i) {
                String fieldValue = fieldValues[i];
                if (fieldValue.equals("") || rule.get(fieldIndex + i).equals(fieldValue)) continue;
                matched = false;
                break;
            }
            if (matched) {
                if (firstIndex == -1) {
                    firstIndex = this.model.get((Object)sec).get((Object)ptype).policy.indexOf(rule);
                }
                effects.add(rule);
                continue;
            }
            tmp.add(rule);
        }
        if (firstIndex != -1) {
            this.model.get((Object)sec).get((Object)ptype).policy = tmp;
        }
        return effects;
    }

    public boolean removeFilteredPolicy(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        return this.removeFilteredPolicyReturnsEffects(sec, ptype, fieldIndex, fieldValues).size() > 0;
    }

    public List<String> getValuesForFieldInPolicy(String sec, String ptype, int fieldIndex) {
        ArrayList<String> values = new ArrayList<String>();
        for (List<String> rule : this.model.get((Object)sec).get((Object)ptype).policy) {
            values.add(rule.get(fieldIndex));
        }
        Util.arrayRemoveDuplicates(values);
        return values;
    }

    public void buildIncrementalRoleLinks(RoleManager rm, Model.PolicyOperations op, String sec, String ptype, List<List<String>> rules) {
        if (sec.equals("g")) {
            this.model.get(sec).get(ptype).buildIncrementalRoleLinks(rm, op, rules);
        }
    }

    public boolean hasPolicies(String sec, String ptype, List<List<String>> rules) {
        for (List<String> rule : rules) {
            if (!this.hasPolicy(sec, ptype, rule)) continue;
            return true;
        }
        return false;
    }
}

