/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.casbin.jcasbin.model.Assertion;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.rbac.ConditionalRoleManager;
import org.casbin.jcasbin.rbac.RoleManager;
import org.casbin.jcasbin.util.Util;

public class Policy {
    public Map<String, Map<String, Assertion>> model;

    public void buildRoleLinks(Map<String, RoleManager> rmMap) {
        if (this.model.containsKey("g")) {
            for (Map.Entry<String, Assertion> entry : this.model.get("g").entrySet()) {
                String ptype = entry.getKey();
                Assertion ast = entry.getValue();
                RoleManager rm = rmMap.get(ptype);
                if (rm == null) continue;
                ast.buildRoleLinks(rm);
            }
        }
    }

    public void printPolicy() {
        Assertion ast;
        String key;
        if (!Util.isLogPrintEnabled()) {
            return;
        }
        Util.logPrint("Policy:");
        if (this.model.containsKey("p")) {
            for (Map.Entry<String, Assertion> entry : this.model.get("p").entrySet()) {
                key = entry.getKey();
                ast = entry.getValue();
                Util.logPrint(key + ": " + ast.value + ": " + ast.policy);
            }
        }
        if (this.model.containsKey("g")) {
            for (Map.Entry<String, Assertion> entry : this.model.get("g").entrySet()) {
                key = entry.getKey();
                ast = entry.getValue();
                Util.logPrint(key + ": " + ast.value + ": " + ast.policy);
            }
        }
    }

    public String savePolicyToText() {
        Assertion ast;
        String key;
        StringBuilder res = new StringBuilder();
        if (this.model.containsKey("p")) {
            for (Map.Entry<String, Assertion> entry : this.model.get("p").entrySet()) {
                key = entry.getKey();
                ast = entry.getValue();
                for (List<String> rule : ast.policy) {
                    res.append(String.format("%s, %s\n", key, String.join((CharSequence)", ", rule)));
                }
            }
        }
        if (this.model.containsKey("g")) {
            for (Map.Entry<String, Assertion> entry : this.model.get("g").entrySet()) {
                key = entry.getKey();
                ast = entry.getValue();
                for (List<String> rule : ast.policy) {
                    res.append(String.format("%s, %s\n", key, String.join((CharSequence)", ", rule)));
                }
            }
        }
        return res.toString();
    }

    public void clearPolicy() {
        if (this.model.containsKey("p")) {
            for (Assertion ast : this.model.get("p").values()) {
                ast.policy = new ArrayList<List<String>>();
                ast.policyIndex = new HashMap<String, Integer>();
            }
        }
        if (this.model.containsKey("g")) {
            for (Assertion ast : this.model.get("g").values()) {
                ast.policy = new ArrayList<List<String>>();
                ast.policyIndex = new HashMap<String, Integer>();
            }
        }
    }

    public List<List<String>> getPolicy(String sec, String ptype) {
        return this.model.get((Object)sec).get((Object)ptype).policy;
    }

    public List<List<String>> getFilteredPolicy(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        for (List<String> rule : this.model.get((Object)sec).get((Object)ptype).policy) {
            boolean matched = true;
            for (int i = 0; i < fieldValues.length; ++i) {
                String fieldValue = fieldValues[i];
                if (fieldValue == null || "".equals(fieldValue) || rule.get(fieldIndex + i).equals(fieldValue)) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            res.add(rule);
        }
        return res;
    }

    public boolean hasPolicy(String sec, String ptype, List<String> rule) {
        return this.model.get((Object)sec).get((Object)ptype).policyIndex.containsKey(rule.toString());
    }

    public boolean addPolicy(String sec, String ptype, List<String> rule) {
        if (!this.hasPolicy(sec, ptype, rule)) {
            Assertion assertion = this.model.get(sec).get(ptype);
            List<List<String>> policy = assertion.policy;
            int priorityIndex = assertion.priorityIndex;
            if ("p".equals(sec) && priorityIndex >= 0) {
                int value = Integer.parseInt(rule.get(priorityIndex));
                int left = 0;
                int right = policy.size();
                while (left < right) {
                    int mid = left + right >>> 1;
                    if (value > Integer.parseInt(policy.get(mid).get(priorityIndex))) {
                        left = mid + 1;
                        continue;
                    }
                    right = mid;
                }
                policy.add(left, rule);
                for (int i = left; i < assertion.policy.size(); ++i) {
                    assertion.policyIndex.put(assertion.policy.get(i).toString(), i);
                }
            } else {
                policy.add(rule);
                assertion.policyIndex.put(rule.toString(), policy.size() - 1);
            }
            return true;
        }
        return false;
    }

    public boolean addPolicies(String sec, String ptype, List<List<String>> rules) {
        int size = this.model.get((Object)sec).get((Object)ptype).policy.size();
        for (List<String> rule : rules) {
            if (this.hasPolicy(sec, ptype, rule)) continue;
            this.addPolicy(sec, ptype, rule);
        }
        return size < this.model.get((Object)sec).get((Object)ptype).policy.size();
    }

    public boolean updatePolicy(String sec, String ptype, List<String> oldRule, List<String> newRule) {
        if (!this.hasPolicy(sec, ptype, oldRule)) {
            return false;
        }
        Assertion ast = this.model.get(sec).get(ptype);
        int index = ast.policyIndex.get(oldRule.toString());
        ast.policy.set(index, newRule);
        ast.policyIndex.remove(oldRule.toString());
        ast.policyIndex.put(newRule.toString(), index);
        return true;
    }

    public boolean removePolicy(String sec, String ptype, List<String> rule) {
        Assertion ast = this.model.get(sec).get(ptype);
        if (ast.policyIndex.containsKey(rule.toString())) {
            int index = ast.policyIndex.get(rule.toString());
            ast.policy.remove(index);
            ast.policyIndex.remove(rule.toString());
            for (int i = index; i < ast.policy.size(); ++i) {
                ast.policyIndex.put(ast.policy.get(i).toString(), i);
            }
            return true;
        }
        return false;
    }

    public boolean removePolicies(String sec, String ptype, List<List<String>> rules) {
        int size = this.model.get((Object)sec).get((Object)ptype).policy.size();
        for (List<String> rule : rules) {
            this.removePolicy(sec, ptype, rule);
        }
        return size > this.model.get((Object)sec).get((Object)ptype).policy.size();
    }

    public List<List<String>> removeFilteredPolicyReturnsEffects(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        ArrayList<List<String>> tmp = new ArrayList<List<String>>();
        ArrayList<List<String>> effects = new ArrayList<List<String>>();
        int firstIndex = -1;
        for (List<String> rule : this.model.get((Object)sec).get((Object)ptype).policy) {
            boolean matched = true;
            for (int i = 0; i < fieldValues.length; ++i) {
                String fieldValue = fieldValues[i];
                if ("".equals(fieldValue) || rule.get(fieldIndex + i).equals(fieldValue)) continue;
                matched = false;
                break;
            }
            if (matched) {
                if (firstIndex == -1) {
                    firstIndex = this.model.get((Object)sec).get((Object)ptype).policy.indexOf(rule);
                }
                effects.add(rule);
                continue;
            }
            tmp.add(rule);
        }
        if (firstIndex != -1) {
            Assertion assertion = this.model.get(sec).get(ptype);
            assertion.policy = tmp;
            assertion.policyIndex.clear();
            for (int i = 0; i < assertion.policy.size(); ++i) {
                assertion.policyIndex.put(assertion.policy.get(i).toString(), i);
            }
        }
        return effects;
    }

    public boolean removeFilteredPolicy(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        return this.removeFilteredPolicyReturnsEffects(sec, ptype, fieldIndex, fieldValues).size() > 0;
    }

    public List<String> getValuesForFieldInPolicy(String sec, String ptype, int fieldIndex) {
        List<String> values = new ArrayList<String>();
        for (List<String> rule : this.model.get((Object)sec).get((Object)ptype).policy) {
            values.add(rule.get(fieldIndex));
        }
        values = Util.arrayRemoveDuplicates(values);
        return values;
    }

    public void buildIncrementalRoleLinks(Map<String, RoleManager> rmMap, Model.PolicyOperations op, String sec, String ptype, List<List<String>> rules) {
        if ("g".equals(sec) && rmMap.containsKey(ptype)) {
            this.model.get(sec).get(ptype).buildIncrementalRoleLinks(rmMap.get(ptype), op, rules);
        }
    }

    public boolean hasPolicies(String sec, String ptype, List<List<String>> rules) {
        for (List<String> rule : rules) {
            if (!this.hasPolicy(sec, ptype, rule)) continue;
            return true;
        }
        return false;
    }

    public void buildIncrementalConditionalRoleLinks(Map<String, ConditionalRoleManager> condRmMap, Model.PolicyOperations op, String sec, String ptype, List<List<String>> rules) {
        if ("g".equals(sec) && condRmMap.containsKey(ptype)) {
            this.model.get(sec).get(ptype).buildIncrementalConditionalRoleLinks(condRmMap.get(ptype), op, rules);
        }
    }

    public void buildConditionalRoleLinks(Map<String, ConditionalRoleManager> condRmMap) {
        this.printPolicy();
        if (this.model.containsKey("g")) {
            for (Map.Entry<String, Assertion> entry : this.model.get("g").entrySet()) {
                String ptype = entry.getKey();
                Assertion ast = entry.getValue();
                if (condRmMap.get(ptype) == null) continue;
                ConditionalRoleManager condRm = condRmMap.get(ptype);
                ast.buildConditionalRoleLinks(condRm);
            }
        }
    }
}

