/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.persist.cache;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.casbin.jcasbin.exception.CasbinCacheException;
import org.casbin.jcasbin.persist.cache.Cache;
import org.casbin.jcasbin.persist.cache.CacheItem;

public class DefaultCache
implements Cache {
    private final Map<String, CacheItem> cache = new HashMap<String, CacheItem>();

    public void set(String key, boolean value, Duration ttl) {
        CacheItem item = new CacheItem(value, ttl);
        this.cache.put(key, item);
    }

    public void set(String key, boolean value) {
        CacheItem item = new CacheItem(value, Duration.ofMillis(-1L));
        this.cache.put(key, item);
    }

    @Override
    public boolean set(String key, boolean value, Object ... extra) {
        if (extra.length > 0 && extra[0] instanceof Duration) {
            Duration ttl = (Duration)extra[0];
            this.set(key, value, ttl);
        } else {
            this.set(key, value);
        }
        return true;
    }

    @Override
    public Boolean get(String key) {
        CacheItem item = this.cache.get(key);
        if (item == null) {
            return null;
        }
        if (item.isExpired()) {
            this.cache.remove(key);
            return null;
        }
        return item.getValue();
    }

    @Override
    public void delete(String key) throws CasbinCacheException {
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

