/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.shiro.authorize.rbac.annotation.auth;

import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;
import org.apache.shiro.web.subject.support.WebDelegatingSubject;
import org.casbin.shiro.authorize.rbac.annotation.auth.EnforcerAuth;
import org.casbin.shiro.factory.EnforcerFactory;

public class EnforcerAuthHandler
extends AuthorizingAnnotationHandler {
    public EnforcerAuthHandler() {
        super(EnforcerAuth.class);
    }

    public void assertAuthorized(Annotation a) throws AuthorizationException {
        if (a instanceof EnforcerAuth) {
            WebDelegatingSubject subject = (WebDelegatingSubject)this.getSubject();
            if (!subject.isAuthenticated()) {
                throw new AuthorizationException("Please login");
            }
            HttpServletRequest request = (HttpServletRequest)subject.getServletRequest();
            String path = request.getServletPath();
            String method = request.getMethod();
            boolean hasPermission = EnforcerFactory.getEnforcer().enforce(new Object[]{subject.getPrincipal().toString(), path, method});
            if (!hasPermission) {
                throw new UnauthorizedException("No permission to access this interface");
            }
        }
    }
}

