/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.shiro.factory;

import org.casbin.adapter.JDBCAdapter;
import org.casbin.jcasbin.main.Enforcer;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.shiro.config.EnforcerConfigProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={EnforcerConfigProperties.class})
public class EnforcerFactory
implements InitializingBean {
    private static Enforcer enforcer;
    private static JDBCAdapter jdbcAdapter;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driver;
    @Value(value="${spring.datasource.url}")
    private String url;
    @Value(value="${spring.datasource.username}")
    private String username;
    @Value(value="${spring.datasource.password}")
    private String password;
    @Autowired
    private EnforcerConfigProperties properties;

    public void afterPropertiesSet() throws Exception {
        jdbcAdapter = new JDBCAdapter(this.driver, this.url, this.username, this.password);
        enforcer = new Enforcer(this.properties.getModelPath(), (Adapter)jdbcAdapter);
        enforcer.loadPolicy();
    }

    public static Enforcer getEnforcer() {
        return enforcer;
    }

    public static JDBCAdapter getJdbcAdapter() {
        return jdbcAdapter;
    }
}

