/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.shiro.authorize.rbac.annotation.auth;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;
import org.apache.shiro.web.subject.support.WebDelegatingSubject;
import org.casbin.shiro.authorize.rbac.annotation.auth.EnforcerAuth;
import org.casbin.shiro.factory.EnforcerFactory;
import org.casbin.shiro.util.LogUtil;

public class EnforcerAuthHandler
extends AuthorizingAnnotationHandler {
    public EnforcerAuthHandler() {
        super(EnforcerAuth.class);
    }

    public void assertAuthorized(Annotation a) throws AuthorizationException {
        if (a instanceof EnforcerAuth) {
            WebDelegatingSubject subject = (WebDelegatingSubject)this.getSubject();
            if (!subject.isAuthenticated()) {
                throw new AuthorizationException("Please login");
            }
            HttpServletRequest request = (HttpServletRequest)subject.getServletRequest();
            String path = request.getServletPath();
            String method = request.getMethod();
            boolean hasPermission = false;
            if (EnforcerFactory.getUserMethodName() == null) {
                hasPermission = EnforcerFactory.getEnforcer().enforce(new Object[]{subject.getPrincipal().toString(), path, method});
            } else {
                Object principal = subject.getPrincipal();
                Class<?> principalClass = principal.getClass();
                Object principalCast = principalClass.cast(principal);
                try {
                    Method principalMethod = principalClass.getMethod(EnforcerFactory.getUserMethodName(), new Class[0]);
                    String userName = (String)principalMethod.invoke(principalCast, new Object[0]);
                    hasPermission = EnforcerFactory.getEnforcer().enforce(new Object[]{userName, path, method});
                }
                catch (NoSuchMethodException e) {
                    LogUtil.logPrintfError("Incorrect userNameMethodName", new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            if (!hasPermission) {
                throw new UnauthorizedException("No permission to access this interface");
            }
        }
    }
}

