/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.shiro.factory;

import java.io.FileNotFoundException;
import javax.sql.DataSource;
import org.casbin.adapter.JDBCAdapter;
import org.casbin.jcasbin.main.Enforcer;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.file_adapter.FileAdapter;
import org.casbin.shiro.config.EnforcerConfigProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ResourceUtils;

@Configuration
@EnableConfigurationProperties(value={EnforcerConfigProperties.class})
public class EnforcerFactory
implements InitializingBean {
    private static Enforcer enforcer;
    private static JDBCAdapter jdbcAdapter;
    private static String userMethodName;
    @Autowired
    private EnforcerConfigProperties properties;
    @Autowired
    private DataSource dataSource;

    public void afterPropertiesSet() throws Exception {
        jdbcAdapter = new JDBCAdapter(this.dataSource);
        String modelPath = this.getResourcePath(this.properties.getModelPath());
        String policyPath = this.getResourcePath(this.properties.getPolicyPath());
        FileAdapter fileAdapter = new FileAdapter(policyPath);
        enforcer = new Enforcer(modelPath, (Adapter)fileAdapter);
        jdbcAdapter.savePolicy(enforcer.getModel());
        jdbcAdapter.close();
        userMethodName = this.properties.getUserNameMethodName();
    }

    public static Enforcer getEnforcer() {
        return enforcer;
    }

    public static JDBCAdapter getJdbcAdapter() {
        return jdbcAdapter;
    }

    public static String getUserMethodName() {
        return userMethodName;
    }

    private String getResourcePath(String resourcePath) throws FileNotFoundException {
        String path = ResourceUtils.isUrl((String)resourcePath) ? ResourceUtils.getURL((String)resourcePath).getPath() : resourcePath;
        return path;
    }
}

