/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.casdoor.shiro;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.BearerToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.Assert;
import org.casbin.casdoor.config.CasdoorConfig;
import org.casbin.casdoor.entity.CasdoorUser;
import org.casbin.casdoor.exception.CasdoorAuthException;
import org.casbin.casdoor.service.CasdoorAuthService;

public class CasdoorShiroRealm
extends AuthorizingRealm {
    private CasdoorAuthService casdoorAuthService;
    private String endpoint;
    private String clientId;
    private String clientSecret;
    private String jwtPublicKey;
    private String organizationName;
    private String applicationName;

    public CasdoorShiroRealm() {
        this.setAuthenticationTokenClass(BearerToken.class);
    }

    public CasdoorShiroRealm(String endpoint, String clientId, String clientSecret, String jwtPublicKey, String organizationName, String applicationName) {
        this.endpoint = endpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.jwtPublicKey = jwtPublicKey;
        this.organizationName = organizationName;
        this.applicationName = applicationName;
        this.setAuthenticationTokenClass(BearerToken.class);
    }

    protected void onInit() {
        super.onInit();
        Assert.hasText((String)this.endpoint, (String)("An endpoint is required for the " + ((Object)((Object)this)).getClass()));
        Assert.hasText((String)this.clientId, (String)("A clientId is required for the " + ((Object)((Object)this)).getClass()));
        Assert.hasText((String)this.clientSecret, (String)("A clientSecret is required for the " + ((Object)((Object)this)).getClass()));
        Assert.hasText((String)this.jwtPublicKey, (String)("A jwtPublicKey is required for the " + ((Object)((Object)this)).getClass()));
        Assert.hasText((String)this.organizationName, (String)("A organizationName is required for the " + ((Object)((Object)this)).getClass()));
        this.casdoorAuthService = new CasdoorAuthService(new CasdoorConfig(this.endpoint, this.clientId, this.clientSecret, this.jwtPublicKey, this.organizationName, this.applicationName));
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        BearerToken token = (BearerToken)authenticationToken;
        try {
            CasdoorUser user = this.casdoorAuthService.parseJwtToken(token.getToken());
            return new SimpleAuthenticationInfo((Object)user, token.getCredentials(), this.getName());
        }
        catch (CasdoorAuthException e) {
            throw new AuthenticationException("Could not validate bearer token", (Throwable)e);
        }
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        return null;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getJwtPublicKey() {
        return this.jwtPublicKey;
    }

    public void setJwtPublicKey(String jwtPublicKey) {
        this.jwtPublicKey = jwtPublicKey;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }
}

