/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.analysis;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.cert.netsa.data.net.ApplicationLabel$;
import org.cert.netsa.data.net.DNSResourceRecordType$;
import org.cert.netsa.data.net.EmailAddress;
import org.cert.netsa.data.net.EmailAddress$;
import org.cert.netsa.data.net.IPBlock;
import org.cert.netsa.data.net.IPBlock$;
import org.cert.netsa.data.net.TLSCipherSuite$;
import org.cert.netsa.data.net.YAFSSLObjectType$;
import org.cert.netsa.io.silk.IPSetReader$;
import org.cert.netsa.io.silk.IPSetWriter;
import org.cert.netsa.io.silk.IPSetWriter$;
import org.cert.netsa.mothra.analysis.util$;
import org.cert.netsa.mothra.analysis.util$ExternalInternalDirectionInfo$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.UninitializedFieldError;
import scala.collection.GenSeq;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class util$ {
    public static util$ MODULE$;
    private Option<Dataset<Row>> MOTHRA_COLLECTORS_DF;
    public final SparkSession org$cert$netsa$mothra$analysis$util$$spark;
    private final String OBSERVATION_DOMAIN_ID_FIELD;
    private final String VLAN_ID_FIELD;
    private final String ENCLAVE_LABEL_FIELD;
    private final String COLLECTOR_LABEL_FIELD;
    private final String DEPARTMENT_LABEL_FIELD;
    private final String ORGANIZATION_LABEL_FIELD;
    private final Map<String, String> LABEL_FIELD_MAP;
    private final Map<String, Option<Map<String, Tuple2<Object, Option<Object>>[]>>> LABEL_DATA_MAP;
    private final String APPLICATION_LABEL_FIELD;
    private final UserDefinedFunction app_label_udf;
    private final Column app_label_name;
    private final UserDefinedFunction email_addr;
    private final UserDefinedFunction email_addrs;
    private final UserDefinedFunction email_mailbox;
    private final UserDefinedFunction email_mailboxes;
    private final UserDefinedFunction email_domain;
    private final UserDefinedFunction email_domains;
    private final UserDefinedFunction email_display;
    private final UserDefinedFunction email_displays;
    private final UserDefinedFunction email_header_addrs;
    private final UserDefinedFunction email_header_mailboxes;
    private final UserDefinedFunction email_header_domains;
    private final UserDefinedFunction email_header_displays;
    private final String TLS_CIPHER_SUITE_FIELD;
    private final UserDefinedFunction tls_cipher_descs_udf;
    private final Column tls_cipher_descs;
    private final String DNS_RESOURCE_RECORD_TYPE_FIELD;
    private final UserDefinedFunction dns_rr_types_udf;
    private final Column dns_rr_types;
    private final UserDefinedFunction yaf_ssl_object_type;
    private final UserDefinedFunction ssl_rewrite_col;
    private volatile boolean bitmap$0;
    private volatile long bitmap$init$0;

    static {
        new util$();
    }

    public Column compare_field(String field, String condition, Object value) {
        Column column;
        Column ltQuery = functions$.MODULE$.col(field).$less(value);
        Column gtQuery = functions$.MODULE$.col(field).$greater(value);
        Column leqQuery = functions$.MODULE$.col(field).$less$eq(value);
        Column geqQuery = functions$.MODULE$.col(field).$greater$eq(value);
        Column eqQuery = functions$.MODULE$.col(field).$eq$eq$eq(value);
        String string = condition;
        if ("=".equals(string)) {
            column = eqQuery;
        } else if ("<".equals(string)) {
            column = ltQuery;
        } else if (">".equals(string)) {
            column = gtQuery;
        } else if ("<=".equals(string)) {
            column = leqQuery;
        } else if (">=".equals(string)) {
            column = geqQuery;
        } else {
            throw new MatchError((Object)string);
        }
        Column chosenQuery = column;
        return chosenQuery;
    }

    public Dataset<Row> filter_by_field(Dataset<Row> df, String field, String condition, Object value) {
        return df.filter(this.compare_field(field, condition, value));
    }

    public Dataset<Row> filter_array_field_list(Dataset<Row> df, String field, Seq<Object> list) {
        return df.filter(functions$.MODULE$.col(field).isNotNull()).filter(this.filterItems$1(list).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(field)})));
    }

    public Dataset<Row> filter_field_list(Dataset<Row> df, String field, Seq<Object> list) {
        DataType dataType = df.schema().apply(field).dataType();
        if (dataType instanceof ArrayType) {
            return this.filter_array_field_list(df, field, list);
        }
        return df.filter(functions$.MODULE$.col(field).isin(list));
    }

    public Timestamp make_timestamp(String s) {
        Timestamp timestamp;
        try {
            timestamp = Timestamp.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            timestamp = null;
        }
        return timestamp;
    }

    public Timestamp make_timestamp(Timestamp t) {
        return t;
    }

    public Column stime_range(String begin, String end) {
        Seq tests = (Seq)new .colon.colon((Object)Option$.MODULE$.apply((Object)begin).map((Function1 & Serializable & scala.Serializable)b -> util$.MODULE$.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startTime"}))).$((Seq)Nil$.MODULE$).$greater$eq((Object)Timestamp.valueOf(b))), (List)new .colon.colon((Object)Option$.MODULE$.apply((Object)end).map((Function1 & Serializable & scala.Serializable)e -> util$.MODULE$.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startTime"}))).$((Seq)Nil$.MODULE$).$less((Object)Timestamp.valueOf(e))), (List)Nil$.MODULE$)).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
        Predef$.MODULE$.assume(tests.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Either begin or end must be provided");
        return (Column)tests.reduce((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> x$1.$amp$amp(x$2));
    }

    public String stime_range$default$1() {
        return null;
    }

    public String stime_range$default$2() {
        return null;
    }

    public Column stime_date(String date) {
        LocalDate d = LocalDate.parse(date);
        return this.stime_range(Timestamp.valueOf(d.atTime(0, 0)).toString(), Timestamp.valueOf(d.plusDays(1L).atTime(0, 0)).toString());
    }

    public Dataset<Row> filter_by_times(Dataset<Row> df, String start, String end) {
        return df.filter(this.stime_range(start, end));
    }

    private String OBSERVATION_DOMAIN_ID_FIELD() {
        if ((this.bitmap$init$0 & 2L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 189");
        }
        return this.OBSERVATION_DOMAIN_ID_FIELD;
    }

    private String VLAN_ID_FIELD() {
        if ((this.bitmap$init$0 & 4L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 195");
        }
        return this.VLAN_ID_FIELD;
    }

    private String ENCLAVE_LABEL_FIELD() {
        if ((this.bitmap$init$0 & 8L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 200");
        }
        return this.ENCLAVE_LABEL_FIELD;
    }

    private String COLLECTOR_LABEL_FIELD() {
        if ((this.bitmap$init$0 & 0x10L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 205");
        }
        return this.COLLECTOR_LABEL_FIELD;
    }

    private String DEPARTMENT_LABEL_FIELD() {
        if ((this.bitmap$init$0 & 0x20L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 210");
        }
        return this.DEPARTMENT_LABEL_FIELD;
    }

    public String ORGANIZATION_LABEL_FIELD() {
        if ((this.bitmap$init$0 & 0x40L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 215");
        }
        return this.ORGANIZATION_LABEL_FIELD;
    }

    private Option<Dataset<Row>> MOTHRA_COLLECTORS_DF$lzycompute() {
        util$ util$2 = this;
        synchronized (util$2) {
            if (!this.bitmap$0) {
                this.MOTHRA_COLLECTORS_DF = (Option)scala.sys.package$.MODULE$.props().get("MOTHRA_COLLECTORS_CSV").map((Function1 & Serializable & scala.Serializable)f -> new Some(MODULE$.load_csv_file((String)f))).getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
                this.bitmap$0 = true;
            }
        }
        return this.MOTHRA_COLLECTORS_DF;
    }

    public Option<Dataset<Row>> MOTHRA_COLLECTORS_DF() {
        return !this.bitmap$0 ? this.MOTHRA_COLLECTORS_DF$lzycompute() : this.MOTHRA_COLLECTORS_DF;
    }

    private Map<String, String> LABEL_FIELD_MAP() {
        if ((this.bitmap$init$0 & 0x80L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 223");
        }
        return this.LABEL_FIELD_MAP;
    }

    private Option<Map<String, Tuple2<Object, Option<Object>>[]>> make_label_map(String field) {
        return (Option)this.MOTHRA_COLLECTORS_DF().map((Function1 & Serializable & scala.Serializable)cdf -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            public final class Org_cert_netsa_mothra_analysis_util$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))));
                }

                public Org_cert_netsa_mothra_analysis_util$$typecreator4$1() {
                }
            }
            Map map = (Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cdf.select((String)MODULE$.LABEL_FIELD_MAP().apply((Object)field), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.OBSERVATION_DOMAIN_ID_FIELD(), MODULE$.VLAN_ID_FIELD()})).as(util$.MODULE$.org$cert$netsa$mothra$analysis$util$$spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator4$1()))).collect())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple3 tuple3 = x0$1;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                String label = (String)tuple3._1();
                int obs = BoxesRunTime.unboxToInt((Object)tuple3._2());
                Option vlan = (Option)tuple3._3();
                Tuple2 tuple2 = new Tuple2((Object)label, (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)obs), (Object)vlan));
                return tuple2;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).groupBy((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3._1()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String label = (String)tuple2._1();
                Tuple2[] pairs = (Tuple2[])tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)label, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pairs)).map((Function1 & Serializable & scala.Serializable)x$4 -> (Tuple2)x$4._2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            return new Some((Object)map);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
    }

    private Map<String, Option<Map<String, Tuple2<Object, Option<Object>>[]>>> LABEL_DATA_MAP() {
        if ((this.bitmap$init$0 & 0x100L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 241");
        }
        return this.LABEL_DATA_MAP;
    }

    public Column collection_labels(String attribute, Seq<String> labels) {
        Option labelData = (Option)this.LABEL_DATA_MAP().apply((Object)attribute);
        Predef$.MODULE$.require(labelData.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(attribute).append(" label data is not defined").toString());
        Predef$.MODULE$.require(labels.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Must specify a list of labels.");
        Map map = (Map)labelData.get();
        Set missing = (Set)((SetLike)Predef$.MODULE$.Set().apply(labels)).diff((GenSet)map.keySet());
        Predef$.MODULE$.require(missing.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append(attribute).append(" label(s) ").append(missing.mkString(", ")).append(" not found").toString());
        Iterable obsVlans = (Iterable)map.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)util$.$anonfun$collection_labels$4(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)util$.$anonfun$collection_labels$5(labels, x$7))).map((Function1 & Serializable & scala.Serializable)x$8 -> {
            Tuple2 tuple2 = x$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2[] pairs = (Tuple2[])tuple2._2();
            Column column = (Column)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pairs)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int oid = tuple2._1$mcI$sp();
                    Option option = (Option)tuple2._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int vid = BoxesRunTime.unboxToInt((Object)some.value());
                        return functions$.MODULE$.col(MODULE$.OBSERVATION_DOMAIN_ID_FIELD()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)oid)).$amp$amp((Object)functions$.MODULE$.col(MODULE$.VLAN_ID_FIELD()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)vid)));
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                int oid = tuple2._1$mcI$sp();
                return functions$.MODULE$.col(MODULE$.OBSERVATION_DOMAIN_ID_FIELD()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)oid));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).reduce((Function2 & Serializable & scala.Serializable)(x$5, x$6) -> x$5.$bar$bar(x$6));
            return column;
        }, Iterable$.MODULE$.canBuildFrom());
        return (Column)obsVlans.reduce((Function2 & Serializable & scala.Serializable)(x$9, x$10) -> x$9.$bar$bar(x$10));
    }

    public Column enclave_labels(Seq<String> labels) {
        return this.collection_labels("enclave", labels);
    }

    public Column collector_labels(Seq<String> labels) {
        return this.collection_labels("collector", labels);
    }

    public Column department_labels(Seq<String> labels) {
        return this.collection_labels("department", labels);
    }

    public Column organization_labels(Seq<String> labels) {
        return this.collection_labels("organization", labels);
    }

    public Dataset<Row> append_collection_labels(Dataset<Row> df, Seq<String> attributes) {
        Predef$.MODULE$.require(this.MOTHRA_COLLECTORS_DF().nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "MOTHRA_COLLECTORS_DF is not defined");
        Set unknown = (Set)attributes.toSet().diff((GenSet)this.LABEL_FIELD_MAP().keys().toSet());
        Predef$.MODULE$.require(unknown.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("attributes(s) ").append(unknown.mkString(", ")).append(" not valid").toString());
        Seq labelCols = (Seq)((TraversableLike)new .colon.colon((Object)this.OBSERVATION_DOMAIN_ID_FIELD(), (List)new .colon.colon((Object)this.VLAN_ID_FIELD(), (List)Nil$.MODULE$))).$plus$plus((GenTraversableOnce)attributes.flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(MODULE$.LABEL_FIELD_MAP().get(key)), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Dataset ldf = ((Dataset)this.MOTHRA_COLLECTORS_DF().get()).select((String)labelCols.head(), (Seq)labelCols.tail());
        Set missing = (Set)attributes.toSet().diff((GenSet)Predef$.MODULE$.Set().apply(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).toSeq()));
        Dataset rdf = missing.isEmpty() ? df : df.drop(attributes.toSeq()).join(ldf, ldf.apply(this.OBSERVATION_DOMAIN_ID_FIELD()).$eq$eq$eq((Object)df.apply("observationDomainId")).$amp$amp((Object)ldf.apply(this.VLAN_ID_FIELD()).isNull().$bar$bar((Object)ldf.apply(this.VLAN_ID_FIELD()).$eq$eq$eq((Object)df.apply("vlanId"))))).drop(ldf.apply(this.OBSERVATION_DOMAIN_ID_FIELD())).drop(ldf.apply(this.VLAN_ID_FIELD()));
        return rdf.toDF(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdf.columns())).toSeq());
    }

    public Dataset<Row> count_by_collection_labels(Dataset<Row> df, Seq<String> attributes) {
        Seq cols = (Seq)attributes.flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(MODULE$.LABEL_FIELD_MAP().get(key)), Seq$.MODULE$.canBuildFrom());
        Dataset<Row> rdf = this.append_collection_labels(df, attributes);
        return rdf.toDF(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdf.columns())).toSeq()).groupBy((String)cols.head(), (Seq)cols.tail()).count().sort((String)cols.head(), (Seq)cols.tail());
    }

    public Dataset<Row> load_csv_file(String filepath) {
        return this.org$cert$netsa$mothra$analysis$util$$spark.read().option("header", true).option("inferSchema", true).csv(filepath);
    }

    public void save_csv_file(Dataset<Row> df, String outfile) {
        df.coalesce(1).write().mode(SaveMode.Overwrite).option("header", "true").csv(outfile);
    }

    public Dataset<Row> load_hive_table(String tablename) {
        return this.org$cert$netsa$mothra$analysis$util$$spark.table(tablename);
    }

    public void save_hive_table(Dataset<Row> df, String tablename) {
        df.write().mode(SaveMode.Overwrite).saveAsTable(tablename);
    }

    public Dataset<Row> load_ipset(String infile) {
        return this.org$cert$netsa$mothra$analysis$util$$spark.implicits().localSeqToDatasetHolder(IPSetReader$.MODULE$.ofInputStream((InputStream)FileSystem.get((Configuration)this.org$cert$netsa$mothra$analysis$util$$spark.sparkContext().hadoopConfiguration()).open(new Path(infile))).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.min().toString()).toSeq(), this.org$cert$netsa$mothra$analysis$util$$spark.implicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"addr"}));
    }

    public Dataset<Row> load_ipset_blocks(String infile) {
        return this.org$cert$netsa$mothra$analysis$util$$spark.implicits().localSeqToDatasetHolder(IPSetReader$.MODULE$.ofInputStream((InputStream)FileSystem.get((Configuration)this.org$cert$netsa$mothra$analysis$util$$spark.sparkContext().hadoopConfiguration()).open(new Path(infile))).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toString()).toSeq(), this.org$cert$netsa$mothra$analysis$util$$spark.implicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"block"}));
    }

    public void save_ipset(String outfile, Dataset<Row> df) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator1$2() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator2$1() {
            }
        }
        UserDefinedFunction addr_to_block_udf = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x$13 -> util$.addr_to_block$1(x$13), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator1$2()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator2$1()));
        String[] blocks = (String[])df.filter(df.col(df.columns()[0]).isNotNull()).withColumn("block", addr_to_block_udf.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.col(df.columns()[0])}))).select("block", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).sort("block", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().map((Function1 & Serializable & scala.Serializable)row -> row.apply(0).toString(), this.org$cert$netsa$mothra$analysis$util$$spark.implicits().newStringEncoder()).collect();
        IPSetWriter out_set = IPSetWriter$.MODULE$.toOutputStream((OutputStream)new BufferedOutputStream((OutputStream)FileSystem.get((Configuration)this.org$cert$netsa$mothra$analysis$util$$spark.sparkContext().hadoopConfiguration()).create(new Path(outfile))), IPSetWriter$.MODULE$.toOutputStream$default$2());
        out_set.append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).map((Function1 & Serializable & scala.Serializable)x$14 -> IPBlock$.MODULE$.apply(x$14), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(IPBlock.class))))).sorted(IPBlock$.MODULE$.ipBlockOrdering()))).iterator());
        out_set.close();
    }

    public Object[] collect_column(Dataset<Row> df) {
        return (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.apply(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
    }

    public Object[] collect_column(Dataset<Row> df, Column c) {
        return this.collect_column((Dataset<Row>)df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{c})));
    }

    public String APPLICATION_LABEL_FIELD() {
        if ((this.bitmap$init$0 & 0x200L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 571");
        }
        return this.APPLICATION_LABEL_FIELD;
    }

    private UserDefinedFunction app_label_udf() {
        if ((this.bitmap$init$0 & 0x400L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 575");
        }
        return this.app_label_udf;
    }

    public Column app_label_name() {
        if ((this.bitmap$init$0 & 0x800L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 579");
        }
        return this.app_label_name;
    }

    public Column app_labels(Seq<Object> labels) {
        Seq cols = (Seq)labels.map((Function1 & Serializable & scala.Serializable)label -> {
            Column column;
            Object object = label;
            if (object instanceof String) {
                String string = (String)object;
                column = functions$.MODULE$.col(MODULE$.APPLICATION_LABEL_FIELD()).$eq$eq$eq((Object)BoxesRunTime.boxToShort((short)ApplicationLabel$.MODULE$.apply(string)));
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                column = functions$.MODULE$.col(MODULE$.APPLICATION_LABEL_FIELD()).$eq$eq$eq((Object)BoxesRunTime.boxToShort((short)ApplicationLabel$.MODULE$.apply(n)));
            } else {
                throw new RuntimeException("invalid type for label");
            }
            return column;
        }, Seq$.MODULE$.canBuildFrom());
        return (Column)cols.reduce((Function2 & Serializable & scala.Serializable)(x$16, x$17) -> x$16.$bar$bar(x$17));
    }

    public UserDefinedFunction email_addr() {
        if ((this.bitmap$init$0 & 0x1000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 598");
        }
        return this.email_addr;
    }

    public UserDefinedFunction email_addrs() {
        if ((this.bitmap$init$0 & 0x2000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 599");
        }
        return this.email_addrs;
    }

    public UserDefinedFunction email_mailbox() {
        if ((this.bitmap$init$0 & 0x4000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 601");
        }
        return this.email_mailbox;
    }

    public UserDefinedFunction email_mailboxes() {
        if ((this.bitmap$init$0 & 0x8000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 602");
        }
        return this.email_mailboxes;
    }

    public UserDefinedFunction email_domain() {
        if ((this.bitmap$init$0 & 0x10000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 604");
        }
        return this.email_domain;
    }

    public UserDefinedFunction email_domains() {
        if ((this.bitmap$init$0 & 0x20000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 605");
        }
        return this.email_domains;
    }

    public UserDefinedFunction email_display() {
        if ((this.bitmap$init$0 & 0x40000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 607");
        }
        return this.email_display;
    }

    public UserDefinedFunction email_displays() {
        if ((this.bitmap$init$0 & 0x80000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 608");
        }
        return this.email_displays;
    }

    public UserDefinedFunction email_header_addrs() {
        if ((this.bitmap$init$0 & 0x100000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 610");
        }
        return this.email_header_addrs;
    }

    public UserDefinedFunction email_header_mailboxes() {
        if ((this.bitmap$init$0 & 0x200000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 616");
        }
        return this.email_header_mailboxes;
    }

    public UserDefinedFunction email_header_domains() {
        if ((this.bitmap$init$0 & 0x400000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 622");
        }
        return this.email_header_domains;
    }

    public UserDefinedFunction email_header_displays() {
        if ((this.bitmap$init$0 & 0x800000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 628");
        }
        return this.email_header_displays;
    }

    public String TLS_CIPHER_SUITE_FIELD() {
        if ((this.bitmap$init$0 & 0x1000000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 636");
        }
        return this.TLS_CIPHER_SUITE_FIELD;
    }

    public UserDefinedFunction tls_cipher_descs_udf() {
        if ((this.bitmap$init$0 & 0x2000000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 640");
        }
        return this.tls_cipher_descs_udf;
    }

    public Column tls_cipher_descs() {
        if ((this.bitmap$init$0 & 0x4000000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 644");
        }
        return this.tls_cipher_descs;
    }

    public String DNS_RESOURCE_RECORD_TYPE_FIELD() {
        if ((this.bitmap$init$0 & 0x8000000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 648");
        }
        return this.DNS_RESOURCE_RECORD_TYPE_FIELD;
    }

    public UserDefinedFunction dns_rr_types_udf() {
        if ((this.bitmap$init$0 & 0x10000000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 653");
        }
        return this.dns_rr_types_udf;
    }

    public Column dns_rr_types() {
        if ((this.bitmap$init$0 & 0x20000000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 657");
        }
        return this.dns_rr_types;
    }

    public UserDefinedFunction yaf_ssl_object_type() {
        if ((this.bitmap$init$0 & 0x40000000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 661");
        }
        return this.yaf_ssl_object_type;
    }

    public UserDefinedFunction ssl_rewrite_col() {
        if ((this.bitmap$init$0 & 0x80000000L) == 0L) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_analysis/src/util.scala: 665");
        }
        return this.ssl_rewrite_col;
    }

    public Dataset<Row> ssl_rewrite_df(Dataset<Row> df) {
        Dataset subject_df = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yafFlowKeyHash"}))).$((Seq)Nil$.MODULE$), functions$.MODULE$.explode((Column)this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sslDataSubject"}))).$((Seq)Nil$.MODULE$)).as("sslDataSubject")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yafFlowKeyHash"}))).$((Seq)Nil$.MODULE$), this.ssl_rewrite_col().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"sslCertSub"), this.yaf_ssl_object_type().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sslDataSubject.key"}))).$((Seq)Nil$.MODULE$)}))})).as("key"), this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sslDataSubject.value"}))).$((Seq)Nil$.MODULE$).cast((DataType)StringType$.MODULE$)})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yafFlowKeyHash"}))).$((Seq)Nil$.MODULE$)})).pivot("key").agg(functions$.MODULE$.collect_list((Column)this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
        Dataset issuer_df = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yafFlowKeyHash"}))).$((Seq)Nil$.MODULE$), functions$.MODULE$.explode((Column)this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sslDataIssuer"}))).$((Seq)Nil$.MODULE$)).as("sslDataIssuer")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yafFlowKeyHash"}))).$((Seq)Nil$.MODULE$), this.ssl_rewrite_col().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"sslCertIssuer"), this.yaf_ssl_object_type().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sslDataIssuer.key"}))).$((Seq)Nil$.MODULE$)}))})).as("key"), this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sslDataIssuer.value"}))).$((Seq)Nil$.MODULE$).cast((DataType)StringType$.MODULE$)})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yafFlowKeyHash"}))).$((Seq)Nil$.MODULE$)})).pivot("key").agg(functions$.MODULE$.collect_list((Column)this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
        Dataset extension_df = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yafFlowKeyHash"}))).$((Seq)Nil$.MODULE$), functions$.MODULE$.explode((Column)this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sslDataExtension"}))).$((Seq)Nil$.MODULE$)).as("sslDataExtension")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yafFlowKeyHash"}))).$((Seq)Nil$.MODULE$), this.ssl_rewrite_col().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"sslCertExt"), this.yaf_ssl_object_type().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sslDataExtension.key"}))).$((Seq)Nil$.MODULE$)}))})).as("key"), this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sslDataExtension.value"}))).$((Seq)Nil$.MODULE$).cast((DataType)StringType$.MODULE$)})).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yafFlowKeyHash"}))).$((Seq)Nil$.MODULE$)})).pivot("key").agg(functions$.MODULE$.collect_list((Column)this.org$cert$netsa$mothra$analysis$util$$spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
        return subject_df.join(issuer_df, "yafFlowKeyHash").join(extension_df, "yafFlowKeyHash");
    }

    public Iterator<LocalDate> dateRange(LocalDate from, LocalDate to, int step) {
        Predef$.MODULE$.require(step >= 0);
        return from.isAfter(to) ? scala.package$.MODULE$.Iterator().iterate((Object)from, (Function1 & Serializable & scala.Serializable)x$30 -> x$30.minusDays(step)).takeWhile((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)x$31.isAfter(to))) : scala.package$.MODULE$.Iterator().iterate((Object)from, (Function1 & Serializable & scala.Serializable)x$32 -> x$32.plusDays(step)).takeWhile((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)x$33.isBefore(to)));
    }

    public int dateRange$default$3() {
        return 1;
    }

    public <T> Dataset<T> withSensorIds(Dataset<T> input, Seq<Object> sensorIds) {
        return input.filter(input.apply("sensorId").isin(sensorIds));
    }

    public Column ip_is_internal(Object a) {
        return util$ExternalInternalDirectionInfo$.MODULE$.ip_is_internal_udf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit(a)}));
    }

    public Column ip_is_external(Object a) {
        return util$ExternalInternalDirectionInfo$.MODULE$.ip_is_internal_udf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit(a)})).unary_$bang();
    }

    public Column sip_dip_direction(Object sip, Object dip) {
        return util$ExternalInternalDirectionInfo$.MODULE$.sip_dip_direction_udf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit(sip), functions$.MODULE$.lit(dip)}));
    }

    public static final /* synthetic */ boolean $anonfun$filter_array_field_list$1(Seq list$1, Seq field_vals) {
        Object object = list$1.intersect((GenSeq)field_vals);
        Nil$ nil$ = Nil$.MODULE$;
        return object == null ? nil$ != null : !object.equals(nil$);
    }

    private final UserDefinedFunction filterItems$1(Seq list) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Any").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator1$1() {
            }
        }
        return functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)field_vals -> BoxesRunTime.boxToBoolean((boolean)util$.$anonfun$filter_array_field_list$1(list, field_vals)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Boolean(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator1$1()));
    }

    public static final /* synthetic */ boolean $anonfun$collection_labels$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$collection_labels$5(Seq labels$1, Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String label = (String)tuple2._1();
        boolean bl = labels$1.contains((Object)label);
        return bl;
    }

    private static final String addr_to_block$1(String addr) {
        return addr.contains("/") ? addr : new StringBuilder(3).append(addr).append("/32").toString();
    }

    public static final /* synthetic */ String $anonfun$tls_cipher_descs_udf$2(int i) {
        return (String)TLSCipherSuite$.MODULE$.desc$extension(TLSCipherSuite$.MODULE$.apply(i)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Integer.toString(i));
    }

    public static final /* synthetic */ String $anonfun$dns_rr_types_udf$2(int i) {
        return (String)DNSResourceRecordType$.MODULE$.rrType$extension(i).getOrElse((Function0 & Serializable & scala.Serializable)() -> Integer.toString(i));
    }

    public static final /* synthetic */ String $anonfun$yaf_ssl_object_type$1(int i) {
        return (String)YAFSSLObjectType$.MODULE$.objectType$extension(i).getOrElse((Function0 & Serializable & scala.Serializable)() -> Integer.toString(i));
    }

    private util$() {
        MODULE$ = this;
        this.org$cert$netsa$mothra$analysis$util$$spark = SparkSession$.MODULE$.builder().appName("mothra").getOrCreate();
        this.bitmap$init$0 |= 1L;
        this.OBSERVATION_DOMAIN_ID_FIELD = (String)scala.sys.package$.MODULE$.props().get("MOTHRA_OBSERVATION_DOMAIN_ID_FIELD").getOrElse((Function0 & Serializable & scala.Serializable)() -> "observationDomainId");
        this.bitmap$init$0 |= 2L;
        this.VLAN_ID_FIELD = (String)scala.sys.package$.MODULE$.props().get("MOTHRA_VLAN_ID_FIELD").getOrElse((Function0 & Serializable & scala.Serializable)() -> "vlanId");
        this.bitmap$init$0 |= 4L;
        this.ENCLAVE_LABEL_FIELD = (String)scala.sys.package$.MODULE$.props().get("MOTHRA_ENCLAVE_LABEL_FIELD").getOrElse((Function0 & Serializable & scala.Serializable)() -> "enclaveLabel");
        this.bitmap$init$0 |= 8L;
        this.COLLECTOR_LABEL_FIELD = (String)scala.sys.package$.MODULE$.props().get("MOTHRA_COLLECTOR_LABEL_FIELD").getOrElse((Function0 & Serializable & scala.Serializable)() -> "collectorLabel");
        this.bitmap$init$0 |= 0x10L;
        this.DEPARTMENT_LABEL_FIELD = (String)scala.sys.package$.MODULE$.props().get("MOTHRA_DEPARTMENT_LABEL_FIELD").getOrElse((Function0 & Serializable & scala.Serializable)() -> "departmentLabel");
        this.bitmap$init$0 |= 0x20L;
        this.ORGANIZATION_LABEL_FIELD = (String)scala.sys.package$.MODULE$.props().get("MOTHRA_ORGANIZATION_LABEL_FIELD").getOrElse((Function0 & Serializable & scala.Serializable)() -> "organizationLabel");
        this.bitmap$init$0 |= 0x40L;
        this.LABEL_FIELD_MAP = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"enclave"), (Object)this.ENCLAVE_LABEL_FIELD()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collector"), (Object)this.COLLECTOR_LABEL_FIELD()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"department"), (Object)this.DEPARTMENT_LABEL_FIELD()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"organization"), (Object)this.ORGANIZATION_LABEL_FIELD())}));
        this.bitmap$init$0 |= 0x80L;
        this.LABEL_DATA_MAP = ((TraversableOnce)((TraversableLike)new .colon.colon((Object)"enclave", (List)new .colon.colon((Object)"collector", (List)new .colon.colon((Object)"department", (List)new .colon.colon((Object)"organization", (List)Nil$.MODULE$))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            Tuple2 tuple2 = new Tuple2((Object)string, MODULE$.make_label_map(string));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.bitmap$init$0 |= 0x100L;
        this.APPLICATION_LABEL_FIELD = (String)scala.sys.package$.MODULE$.props().get("MOTHRA_APPLICATION_LABEL_FIELD").getOrElse((Function0 & Serializable & scala.Serializable)() -> "silkAppLabel");
        this.bitmap$init$0 |= 0x200L;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator1$3() {
            }
        }
        this.app_label_udf = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)port -> ApplicationLabel$.MODULE$.service$extension(BoxesRunTime.unboxToShort((Object)port)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator1$3()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Short());
        this.bitmap$init$0 |= 0x400L;
        this.app_label_name = this.app_label_udf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.APPLICATION_LABEL_FIELD())}));
        this.bitmap$init$0 |= 0x800L;
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator2$2() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator3$1() {
            }
        }
        this.email_addr = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x$18 -> new EmailAddress(x$18).addr(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator2$2()), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator3$1()));
        this.bitmap$init$0 |= 0x1000L;
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator4$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator4$2() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator5$1() {
            }
        }
        this.email_addrs = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)l -> (Seq)l.map((Function1 & Serializable & scala.Serializable)x$19 -> new EmailAddress(x$19).addr(), Seq$.MODULE$.canBuildFrom()), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator4$2()), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator5$1()));
        this.bitmap$init$0 |= 0x2000L;
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u7 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m7 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator6$1() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator7$1() {
            }
        }
        this.email_mailbox = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x$20 -> new EmailAddress(x$20).mailbox(), ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator6$1()), ((TypeTags)$u7).TypeTag().apply((Mirror)$m7, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator7$1()));
        this.bitmap$init$0 |= 0x4000L;
        JavaUniverse $u8 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m8 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u9 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m9 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator8$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator8$1() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator9$1() {
            }
        }
        this.email_mailboxes = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)l -> (Seq)l.map((Function1 & Serializable & scala.Serializable)x$21 -> new EmailAddress(x$21).mailbox(), Seq$.MODULE$.canBuildFrom()), ((TypeTags)$u8).TypeTag().apply((Mirror)$m8, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator8$1()), ((TypeTags)$u9).TypeTag().apply((Mirror)$m9, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator9$1()));
        this.bitmap$init$0 |= 0x8000L;
        JavaUniverse $u10 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m10 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u11 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m11 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator10$1() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator11$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator11$1() {
            }
        }
        this.email_domain = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x$22 -> new EmailAddress(x$22).domain(), ((TypeTags)$u10).TypeTag().apply((Mirror)$m10, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator10$1()), ((TypeTags)$u11).TypeTag().apply((Mirror)$m11, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator11$1()));
        this.bitmap$init$0 |= 0x10000L;
        JavaUniverse $u12 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m12 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u13 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m13 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator12$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator12$1() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator13$1() {
            }
        }
        this.email_domains = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)l -> (Seq)l.map((Function1 & Serializable & scala.Serializable)x$23 -> new EmailAddress(x$23).domain(), Seq$.MODULE$.canBuildFrom()), ((TypeTags)$u12).TypeTag().apply((Mirror)$m12, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator12$1()), ((TypeTags)$u13).TypeTag().apply((Mirror)$m13, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator13$1()));
        this.bitmap$init$0 |= 0x20000L;
        JavaUniverse $u14 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m14 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u15 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m15 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator14$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator14$1() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator15$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator15$1() {
            }
        }
        this.email_display = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x$24 -> new EmailAddress(x$24).display(), ((TypeTags)$u14).TypeTag().apply((Mirror)$m14, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator14$1()), ((TypeTags)$u15).TypeTag().apply((Mirror)$m15, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator15$1()));
        this.bitmap$init$0 |= 0x40000L;
        JavaUniverse $u16 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m16 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u17 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m17 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator16$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator16$1() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator17$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator17$1() {
            }
        }
        this.email_displays = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)l -> (Seq)l.map((Function1 & Serializable & scala.Serializable)x$25 -> new EmailAddress(x$25).display(), Seq$.MODULE$.canBuildFrom()), ((TypeTags)$u16).TypeTag().apply((Mirror)$m16, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator16$1()), ((TypeTags)$u17).TypeTag().apply((Mirror)$m17, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator17$1()));
        this.bitmap$init$0 |= 0x80000L;
        JavaUniverse $u18 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m18 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u19 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m19 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator18$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator18$1() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator19$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator19$1() {
            }
        }
        this.email_header_addrs = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)header -> Option$.MODULE$.apply(header).map((Function1 & Serializable & scala.Serializable)x$26 -> EmailAddress$.MODULE$.fromHeader(x$26).map((Function1 & Serializable & scala.Serializable)e -> e.addr()).toSeq()), ((TypeTags)$u18).TypeTag().apply((Mirror)$m18, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator18$1()), ((TypeTags)$u19).TypeTag().apply((Mirror)$m19, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator19$1()));
        this.bitmap$init$0 |= 0x100000L;
        JavaUniverse $u20 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m20 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u21 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m21 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator20$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator20$1() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator21$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator21$1() {
            }
        }
        this.email_header_mailboxes = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)header -> Option$.MODULE$.apply(header).map((Function1 & Serializable & scala.Serializable)x$27 -> EmailAddress$.MODULE$.fromHeader(x$27).map((Function1 & Serializable & scala.Serializable)e -> e.mailbox()).toSeq()), ((TypeTags)$u20).TypeTag().apply((Mirror)$m20, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator20$1()), ((TypeTags)$u21).TypeTag().apply((Mirror)$m21, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator21$1()));
        this.bitmap$init$0 |= 0x200000L;
        JavaUniverse $u22 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m22 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u23 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m23 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator22$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator22$1() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator23$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator23$1() {
            }
        }
        this.email_header_domains = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)header -> Option$.MODULE$.apply(header).map((Function1 & Serializable & scala.Serializable)x$28 -> EmailAddress$.MODULE$.fromHeader(x$28).map((Function1 & Serializable & scala.Serializable)e -> e.domain()).toSeq()), ((TypeTags)$u22).TypeTag().apply((Mirror)$m22, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator22$1()), ((TypeTags)$u23).TypeTag().apply((Mirror)$m23, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator23$1()));
        this.bitmap$init$0 |= 0x400000L;
        JavaUniverse $u24 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m24 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u25 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m25 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator24$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator24$1() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator25$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator25$1() {
            }
        }
        this.email_header_displays = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)header -> Option$.MODULE$.apply(header).map((Function1 & Serializable & scala.Serializable)x$29 -> EmailAddress$.MODULE$.fromHeader(x$29).map((Function1 & Serializable & scala.Serializable)e -> e.display()).toSeq()), ((TypeTags)$u24).TypeTag().apply((Mirror)$m24, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator24$1()), ((TypeTags)$u25).TypeTag().apply((Mirror)$m25, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator25$1()));
        this.bitmap$init$0 |= 0x800000L;
        this.TLS_CIPHER_SUITE_FIELD = (String)scala.sys.package$.MODULE$.props().get("MOTHRA_TLS_CIPHER_SUITE_FIELD").getOrElse((Function0 & Serializable & scala.Serializable)() -> "sslCipher");
        this.bitmap$init$0 |= 0x1000000L;
        JavaUniverse $u26 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m26 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u27 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m27 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator26$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator26$1() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator27$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator27$1() {
            }
        }
        this.tls_cipher_descs_udf = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)l -> (Seq)l.map((Function1 & Serializable & scala.Serializable)i -> util$.$anonfun$tls_cipher_descs_udf$2(BoxesRunTime.unboxToInt((Object)i)), Seq$.MODULE$.canBuildFrom()), ((TypeTags)$u26).TypeTag().apply((Mirror)$m26, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator26$1()), ((TypeTags)$u27).TypeTag().apply((Mirror)$m27, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator27$1()));
        this.bitmap$init$0 |= 0x2000000L;
        this.tls_cipher_descs = this.tls_cipher_descs_udf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.TLS_CIPHER_SUITE_FIELD())}));
        this.bitmap$init$0 |= 0x4000000L;
        this.DNS_RESOURCE_RECORD_TYPE_FIELD = (String)scala.sys.package$.MODULE$.props().get("MOTHRA_DNS_RESOURCE_RECORD_TYPE_FIELD").getOrElse((Function0 & Serializable & scala.Serializable)() -> "dnsQRType");
        this.bitmap$init$0 |= 0x8000000L;
        JavaUniverse $u28 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m28 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u29 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m29 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator28$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator28$1() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator29$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator29$1() {
            }
        }
        this.dns_rr_types_udf = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)l -> (Seq)l.map((Function1 & Serializable & scala.Serializable)i -> util$.$anonfun$dns_rr_types_udf$2(BoxesRunTime.unboxToInt((Object)i)), Seq$.MODULE$.canBuildFrom()), ((TypeTags)$u28).TypeTag().apply((Mirror)$m28, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator28$1()), ((TypeTags)$u29).TypeTag().apply((Mirror)$m29, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator29$1()));
        this.bitmap$init$0 |= 0x10000000L;
        this.dns_rr_types = this.dns_rr_types_udf().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.DNS_RESOURCE_RECORD_TYPE_FIELD())}));
        this.bitmap$init$0 |= 0x20000000L;
        JavaUniverse $u30 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m30 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator30$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator30$1() {
            }
        }
        this.yaf_ssl_object_type = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)i -> util$.$anonfun$yaf_ssl_object_type$1(BoxesRunTime.unboxToInt((Object)i)), ((TypeTags)$u30).TypeTag().apply((Mirror)$m30, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator30$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        this.bitmap$init$0 |= 0x40000000L;
        JavaUniverse $u31 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m31 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u32 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m32 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u33 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m33 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator31$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator31$1() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator32$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator32$1() {
            }
        }
        public final class Org_cert_netsa_mothra_analysis_util$$typecreator33$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_cert_netsa_mothra_analysis_util$$typecreator33$1() {
            }
        }
        this.ssl_rewrite_col = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(prefix, suffix) -> new StringBuilder(0).append((String)prefix).append(new StringOps(Predef$.MODULE$.augmentString(suffix)).capitalize()).toString(), ((TypeTags)$u31).TypeTag().apply((Mirror)$m31, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator31$1()), ((TypeTags)$u32).TypeTag().apply((Mirror)$m32, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator32$1()), ((TypeTags)$u33).TypeTag().apply((Mirror)$m33, (TypeCreator)new Org_cert_netsa_mothra_analysis_util$$typecreator33$1()));
        this.bitmap$init$0 |= 0x80000000L;
    }
}

