/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.datasources.ipfix;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.cert.netsa.mothra.datasources.ipfix.Constraint;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class SlicingRelation$
implements Serializable {
    public static SlicingRelation$ MODULE$;
    private final DateTimeFormatter org$cert$netsa$mothra$datasources$ipfix$SlicingRelation$$ymdPrefixFormat;
    private final ZoneId utc;
    private final Regex locationPatternV2;
    private final DateTimeFormatter ymdhFormat;
    private final DateTimeFormatter ymdFormat;

    static {
        new SlicingRelation$();
    }

    public DateTimeFormatter org$cert$netsa$mothra$datasources$ipfix$SlicingRelation$$ymdPrefixFormat() {
        return this.org$cert$netsa$mothra$datasources$ipfix$SlicingRelation$$ymdPrefixFormat;
    }

    private ZoneId utc() {
        return this.utc;
    }

    private Regex locationPatternV2() {
        return this.locationPatternV2;
    }

    private DateTimeFormatter ymdhFormat() {
        return this.ymdhFormat;
    }

    public Seq<Constraint> constraintsForLocation(String location) {
        Seq seq;
        TraversableLike traversableLike = (TraversableLike)new .colon.colon((Object)new Constraint.EQ("__location__", location), (List)Nil$.MODULE$);
        String string = location;
        Option option = this.locationPatternV2().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String ymdh = (String)((LinearSeqOptimized)option.get()).apply(0);
            Instant t = ZonedDateTime.parse(ymdh, this.ymdhFormat()).toInstant();
            String t0 = t.toString();
            String t1 = t.plusSeconds(3600L).toString();
            String t2 = t.plusSeconds(7200L).toString();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Constraint.GE_LT[]{new Constraint.GE_LT("flowStartNanoseconds", t0, t1), new Constraint.GE_LT("flowStartMicroseconds", t0, t1), new Constraint.GE_LT("flowStartMilliseconds", t0, t1), new Constraint.GE_LT("flowStartSeconds", t0, t1), new Constraint.GE_LT("flowEndNanoseconds", t0, t2), new Constraint.GE_LT("flowEndMicroseconds", t0, t2), new Constraint.GE_LT("flowEndMilliseconds", t0, t2), new Constraint.GE_LT("flowEndSeconds", t0, t2)}));
        } else {
            seq = (Seq)Nil$.MODULE$;
        }
        return (Seq)traversableLike.$plus$plus((GenTraversableOnce)seq, Seq$.MODULE$.canBuildFrom());
    }

    private DateTimeFormatter ymdFormat() {
        return this.ymdFormat;
    }

    public Seq<Constraint> constraintsForDate(String dateStr) {
        Instant date = LocalDate.parse(dateStr, this.ymdFormat()).atStartOfDay(this.utc()).toInstant();
        String d0 = date.toString();
        String d1 = date.plusSeconds(86400L).toString();
        String d2 = date.plusSeconds(172800L).toString();
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Constraint.GE_LT[]{new Constraint.GE_LT("flowStartNanoseconds", d0, d1), new Constraint.GE_LT("flowStartMicroseconds", d0, d1), new Constraint.GE_LT("flowStartMilliseconds", d0, d1), new Constraint.GE_LT("flowStartSeconds", d0, d1), new Constraint.GE_LT("flowEndNanoseconds", d0, d2), new Constraint.GE_LT("flowEndMicroseconds", d0, d2), new Constraint.GE_LT("flowEndMilliseconds", d0, d2), new Constraint.GE_LT("flowEndSeconds", d0, d2)}));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SlicingRelation$() {
        MODULE$ = this;
        this.org$cert$netsa$mothra$datasources$ipfix$SlicingRelation$$ymdPrefixFormat = DateTimeFormatter.ofPattern("yyyy/MM/dd/");
        this.utc = ZoneId.of("UTC");
        this.locationPatternV2 = new StringOps(Predef$.MODULE$.augmentString("^(?:|.*/)(\\d{4}\\d{2}\\d{2}\\.\\d{2})\\.[^/]*$")).r();
        this.ymdhFormat = DateTimeFormatter.ofPattern("yyyyMMdd.HH").withZone(this.utc());
        this.ymdFormat = DateTimeFormatter.ofPattern("yyyy/MM/dd").withZone(this.utc());
    }
}

