/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.datasources.ipfix.fields;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.cert.netsa.data.net.IPv4Address;
import org.cert.netsa.data.net.IPv6Address;
import org.cert.netsa.data.time.LocalDateSet;
import org.cert.netsa.data.time.LocalDateSet$;
import org.cert.netsa.io.ipfix.DataTypes;
import org.cert.netsa.io.ipfix.InfoElement;
import org.cert.netsa.io.ipfix.util.ListView;
import org.cert.netsa.mothra.datasources.FilterResult;
import org.cert.netsa.mothra.datasources.fields.Field;
import org.cert.netsa.mothra.datasources.ipfix.Constraint;
import org.cert.netsa.mothra.datasources.ipfix.DefaultSource$;
import org.cert.netsa.mothra.datasources.ipfix.fields.IPFIXField;
import org.cert.netsa.mothra.datasources.ipfix.fields.IPFIXFieldParsing$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class IPFIXField$
implements scala.Serializable {
    public static IPFIXField$ MODULE$;
    private final ZoneId utc;
    private final Map<String, String> aliases;
    private final String ipfixPrefix;

    static {
        new IPFIXField$();
    }

    public DataType ipfixToSQLType(DataTypes ipfixType) {
        BinaryType$ binaryType$;
        DataTypes dataTypes = ipfixType;
        if (DataTypes.OctetArray$.MODULE$.equals(dataTypes)) {
            binaryType$ = BinaryType$.MODULE$;
        } else if (DataTypes.Unsigned8$.MODULE$.equals(dataTypes)) {
            binaryType$ = IntegerType$.MODULE$;
        } else if (DataTypes.Unsigned16$.MODULE$.equals(dataTypes)) {
            binaryType$ = IntegerType$.MODULE$;
        } else if (DataTypes.Unsigned32$.MODULE$.equals(dataTypes)) {
            binaryType$ = LongType$.MODULE$;
        } else if (DataTypes.Unsigned64$.MODULE$.equals(dataTypes)) {
            binaryType$ = LongType$.MODULE$;
        } else if (DataTypes.Signed8$.MODULE$.equals(dataTypes)) {
            binaryType$ = IntegerType$.MODULE$;
        } else if (DataTypes.Signed16$.MODULE$.equals(dataTypes)) {
            binaryType$ = IntegerType$.MODULE$;
        } else if (DataTypes.Signed32$.MODULE$.equals(dataTypes)) {
            binaryType$ = IntegerType$.MODULE$;
        } else if (DataTypes.Signed64$.MODULE$.equals(dataTypes)) {
            binaryType$ = LongType$.MODULE$;
        } else if (DataTypes.Float32$.MODULE$.equals(dataTypes)) {
            binaryType$ = FloatType$.MODULE$;
        } else if (DataTypes.Float64$.MODULE$.equals(dataTypes)) {
            binaryType$ = DoubleType$.MODULE$;
        } else if (DataTypes.Boolean$.MODULE$.equals(dataTypes)) {
            binaryType$ = BooleanType$.MODULE$;
        } else if (DataTypes.MacAddress$.MODULE$.equals(dataTypes)) {
            binaryType$ = BinaryType$.MODULE$;
        } else if (DataTypes.String$.MODULE$.equals(dataTypes)) {
            binaryType$ = StringType$.MODULE$;
        } else if (DataTypes.DateTimeSeconds$.MODULE$.equals(dataTypes)) {
            binaryType$ = TimestampType$.MODULE$;
        } else if (DataTypes.DateTimeMilliseconds$.MODULE$.equals(dataTypes)) {
            binaryType$ = TimestampType$.MODULE$;
        } else if (DataTypes.DateTimeMicroseconds$.MODULE$.equals(dataTypes)) {
            binaryType$ = TimestampType$.MODULE$;
        } else if (DataTypes.DateTimeNanoseconds$.MODULE$.equals(dataTypes)) {
            binaryType$ = TimestampType$.MODULE$;
        } else if (DataTypes.IPv4Address$.MODULE$.equals(dataTypes)) {
            binaryType$ = StringType$.MODULE$;
        } else if (DataTypes.IPv6Address$.MODULE$.equals(dataTypes)) {
            binaryType$ = StringType$.MODULE$;
        } else {
            boolean bl = DataTypes.BasicList$.MODULE$.equals(dataTypes) ? true : (DataTypes.SubTemplateList$.MODULE$.equals(dataTypes) ? true : DataTypes.SubTemplateMultiList$.MODULE$.equals(dataTypes));
            if (bl) {
                throw package$.MODULE$.error(new StringBuilder(40).append("Can't provide SQL type for IPFIX type '").append(ipfixType).append("'").toString());
            }
            throw new MatchError((Object)dataTypes);
        }
        return binaryType$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object ipfixToSQLValue(DataTypes ipfixType, Object value) {
        Tuple2 tuple2 = new Tuple2((Object)ipfixType, value);
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object lv = tuple2._2();
            if (DataTypes.OctetArray$.MODULE$.equals(dataTypes) && lv instanceof ListView) {
                ListView listView = (ListView)lv;
                return listView.toArray(ClassTag$.MODULE$.Byte());
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object i = tuple2._2();
            if (DataTypes.Unsigned8$.MODULE$.equals(dataTypes) && i instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)i);
                return BoxesRunTime.boxToInteger((int)Short.toUnsignedInt(s));
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object i = tuple2._2();
            if (DataTypes.Unsigned16$.MODULE$.equals(dataTypes) && i instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)i);
                return BoxesRunTime.boxToInteger((int)n);
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object i = tuple2._2();
            if (DataTypes.Unsigned32$.MODULE$.equals(dataTypes) && i instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)i);
                return BoxesRunTime.boxToLong((long)l);
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object i = tuple2._2();
            if (DataTypes.Unsigned64$.MODULE$.equals(dataTypes) && i instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)i);
                return BoxesRunTime.boxToLong((long)l);
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object i = tuple2._2();
            if (DataTypes.Signed8$.MODULE$.equals(dataTypes) && i instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)i);
                return BoxesRunTime.boxToInteger((int)by);
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object i = tuple2._2();
            if (DataTypes.Signed16$.MODULE$.equals(dataTypes) && i instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)i);
                return BoxesRunTime.boxToInteger((int)s);
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object i = tuple2._2();
            if (DataTypes.Signed32$.MODULE$.equals(dataTypes) && i instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)i);
                return BoxesRunTime.boxToInteger((int)n);
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object i = tuple2._2();
            if (DataTypes.Signed64$.MODULE$.equals(dataTypes) && i instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)i);
                return BoxesRunTime.boxToLong((long)l);
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object f = tuple2._2();
            if (DataTypes.Float32$.MODULE$.equals(dataTypes) && f instanceof Float) {
                float f2 = BoxesRunTime.unboxToFloat((Object)f);
                return BoxesRunTime.boxToFloat((float)f2);
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object f = tuple2._2();
            if (DataTypes.Float64$.MODULE$.equals(dataTypes) && f instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)f);
                return BoxesRunTime.boxToDouble((double)d);
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object b = tuple2._2();
            if (DataTypes.Boolean$.MODULE$.equals(dataTypes) && b instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)b);
                return BoxesRunTime.boxToBoolean((boolean)bl);
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object s = tuple2._2();
            if (DataTypes.MacAddress$.MODULE$.equals(dataTypes) && s instanceof String) {
                String string = (String)s;
                return string;
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object s = tuple2._2();
            if (DataTypes.String$.MODULE$.equals(dataTypes) && s instanceof String) {
                String string = (String)s;
                return string;
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object t = tuple2._2();
            if (DataTypes.DateTimeSeconds$.MODULE$.equals(dataTypes) && t instanceof Instant) {
                Instant instant = (Instant)t;
                return Timestamp.from(instant);
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object t = tuple2._2();
            if (DataTypes.DateTimeMilliseconds$.MODULE$.equals(dataTypes) && t instanceof Instant) {
                Instant instant = (Instant)t;
                return Timestamp.from(instant);
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object t = tuple2._2();
            if (DataTypes.DateTimeMicroseconds$.MODULE$.equals(dataTypes) && t instanceof Instant) {
                Instant instant = (Instant)t;
                return Timestamp.from(instant);
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object t = tuple2._2();
            if (DataTypes.DateTimeNanoseconds$.MODULE$.equals(dataTypes) && t instanceof Instant) {
                Instant instant = (Instant)t;
                return Timestamp.from(instant);
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object a = tuple2._2();
            if (DataTypes.IPv4Address$.MODULE$.equals(dataTypes) && a instanceof IPv4Address) {
                IPv4Address iPv4Address = (IPv4Address)a;
                return iPv4Address.toString();
            }
        }
        if (tuple2 != null) {
            DataTypes dataTypes = (DataTypes)tuple2._1();
            Object a = tuple2._2();
            if (DataTypes.IPv6Address$.MODULE$.equals(dataTypes) && a instanceof IPv6Address) {
                IPv6Address iPv6Address = (IPv6Address)a;
                return iPv6Address.toString();
            }
        }
        if (tuple2 == null) throw new NotImplementedError(new StringBuilder(41).append("Unknown IPFIX type ").append(ipfixType).append(" conversion for value ").append(value).toString());
        DataTypes dataTypes = (DataTypes)tuple2._1();
        Object lv = tuple2._2();
        if (!DataTypes.MacAddress$.MODULE$.equals(dataTypes)) throw new NotImplementedError(new StringBuilder(41).append("Unknown IPFIX type ").append(ipfixType).append(" conversion for value ").append(value).toString());
        if (!(lv instanceof ListView)) throw new NotImplementedError(new StringBuilder(41).append("Unknown IPFIX type ").append(ipfixType).append(" conversion for value ").append(value).toString());
        ListView listView = (ListView)lv;
        return listView.toArray(ClassTag$.MODULE$.Byte());
    }

    public FilterResult checkConstraints(Filter filter, Seq<Constraint> constraints) {
        return (FilterResult)((TraversableOnce)constraints.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.matchesFilter(filter), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> x$3.$amp$amp((Function0 & Serializable & scala.Serializable)() -> x$4)).getOrElse((Function0 & Serializable & scala.Serializable)() -> FilterResult.Maybe$.MODULE$);
    }

    private ZoneId utc() {
        return this.utc;
    }

    /*
     * Unable to fully structure code
     */
    public LocalDateSet datesForFilter(Filter f, boolean isEndTimeElement) {
        var6_3 = false;
        var7_4 = null;
        var8_5 = f;
        if (!(var8_5 instanceof EqualNullSafe)) ** GOTO lbl-1000
        var6_3 = true;
        var7_4 = (EqualNullSafe)var8_5;
        var9_6 = var7_4.value();
        if (var9_6 == null) {
            var3_7 = LocalDateSet$.MODULE$.NONE();
        } else if (var6_3) {
            v = var7_4.value();
            var3_7 = LocalDateSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDate[]{this.tsToDate$1(v)}));
        } else if (var8_5 instanceof EqualTo) {
            var11_9 = (EqualTo)var8_5;
            v = var11_9.value();
            var3_7 = LocalDateSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDate[]{this.tsToDate$1(v)}));
        } else if (var8_5 instanceof GreaterThan) {
            var13_11 = (GreaterThan)var8_5;
            v = var13_11.value();
            var3_7 = LocalDateSet$.MODULE$.fromDateRanges((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tsToDate$1(v)), (Object)LocalDate.MAX), (List)Nil$.MODULE$));
        } else if (var8_5 instanceof GreaterThanOrEqual) {
            var15_13 = (GreaterThanOrEqual)var8_5;
            v = var15_13.value();
            var3_7 = LocalDateSet$.MODULE$.fromDateRanges((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tsToDate$1(v)), (Object)LocalDate.MAX), (List)Nil$.MODULE$));
        } else if (var8_5 instanceof In) {
            var17_15 = (In)var8_5;
            vs = var17_15.values();
            var3_7 = LocalDateSet$.MODULE$.fromDates((Seq)Predef$.MODULE$.genericArrayOps((Object)vs).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$datesForFilter$1(org.cert.netsa.mothra.datasources.ipfix.fields.IPFIXField$ java.lang.Object ), (Ljava/lang/Object;)Ljava/time/LocalDate;)((IPFIXField$)this), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
        } else if (var8_5 instanceof IsNotNull) {
            var3_7 = LocalDateSet$.MODULE$.ALL();
        } else if (var8_5 instanceof IsNull) {
            var3_7 = LocalDateSet$.MODULE$.NONE();
        } else if (var8_5 instanceof LessThan) {
            var19_17 = (LessThan)var8_5;
            v = var19_17.value();
            var3_7 = LocalDateSet$.MODULE$.fromDateRanges((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LocalDate.MIN), (Object)this.tsToDateEndExclusive$1(v)), (List)Nil$.MODULE$));
        } else if (var8_5 instanceof LessThanOrEqual) {
            var21_19 = (LessThanOrEqual)var8_5;
            v = var21_19.value();
            var3_7 = LocalDateSet$.MODULE$.fromDateRanges((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LocalDate.MIN), (Object)this.tsToDate$1(v)), (List)Nil$.MODULE$));
        } else {
            var4_21 = var8_5 instanceof StringContains != false ? true : (var8_5 instanceof StringEndsWith != false ? true : (var8_5 instanceof StringStartsWith != false ? true : (var8_5 instanceof And != false ? true : (var8_5 instanceof Or != false ? true : var8_5 instanceof Not != false))));
            if (var4_21) {
                throw new AssertionError((Object)new StringBuilder(47).append("Filter node should never reach datesForFilter: ").append(f).toString());
            }
            throw new MatchError((Object)var8_5);
        }
        baseDates = var3_7;
        return isEndTimeElement != false ? LocalDateSet$.MODULE$.fromDateRanges((Seq)baseDates.sortedRanges().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$datesForFilter$2(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)(), List$.MODULE$.canBuildFrom())) : baseDates;
    }

    private Map<String, String> aliases() {
        return this.aliases;
    }

    public InfoElement lookupInfoElement(String name) {
        return DefaultSource$.MODULE$.infoModel().apply(name);
    }

    public <T> IPFIXField<T> apply(String fieldSpec) {
        return IPFIXFieldParsing$.MODULE$.apply(fieldSpec);
    }

    private String ipfixPrefix() {
        return this.ipfixPrefix;
    }

    public Tuple2<String, IPFIXField<Object>> handleField(Field f) {
        String source = (String)this.aliases().getOrElse((Object)f.source(), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(f.source())).stripPrefix(MODULE$.ipfixPrefix()));
        return new Tuple2((Object)f.name(), this.apply(source));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final LocalDate tsToDate$1(Object v) {
        return ((Timestamp)v).toInstant().atZone(this.utc()).toLocalDate();
    }

    /*
     * WARNING - void declaration
     */
    private final LocalDate tsToDateEndExclusive$1(Object v) {
        void var3_3;
        ZonedDateTime a = ((Timestamp)v).toInstant().atZone(this.utc());
        LocalDate d = this.tsToDate$1(v);
        ZonedDateTime zonedDateTime = a;
        ZonedDateTime zonedDateTime2 = d.atStartOfDay(this.utc());
        return !(zonedDateTime != null ? !((Object)zonedDateTime).equals(zonedDateTime2) : zonedDateTime2 != null) ? d.minusDays(1L) : var3_3;
    }

    public static final /* synthetic */ LocalDate $anonfun$datesForFilter$1(IPFIXField$ $this, Object x$5) {
        return $this.tsToDate$1(x$5);
    }

    public static final /* synthetic */ Tuple2 $anonfun$datesForFilter$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LocalDate s = (LocalDate)tuple2._1();
        LocalDate e = (LocalDate)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)s.minusDays(1L), (Object)e);
        return tuple22;
    }

    private IPFIXField$() {
        MODULE$ = this;
        this.utc = ZoneId.of("UTC");
        this.aliases = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"startTime"), (Object)"func:startTime"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"elapsed"), (Object)"func:durationMilliseconds"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endTime"), (Object)"func:endTime"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sPort"), (Object)"func:sourcePort"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dPort"), (Object)"func:destinationPort"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocol"), (Object)"protocolIdentifier"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flags"), (Object)"func:TCPFlags"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"packets"), (Object)"func:packetCount"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bytes"), (Object)"func:octetCount"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sIP"), (Object)"func:sourceIPAddress"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dIP"), (Object)"func:destinationIPAddress"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nhIP"), (Object)"func:nextHopIPAddress"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"icmpType"), (Object)"func:icmpType"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"icmpCode"), (Object)"func:icmpCode"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isIPv6"), (Object)"func:isIPv6"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filename"), (Object)"func:filename")}));
        this.ipfixPrefix = "ipfix:";
    }
}

