/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.datasources.ipfix;

import java.sql.Timestamp;
import java.time.Instant;
import org.cert.netsa.mothra.datasources.ipfix.Constraint;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichBoolean;

public final class Constraint$ {
    public static Constraint$ MODULE$;

    static {
        new Constraint$();
    }

    public Constraint apply(String opName, String field, Seq<String> args) {
        Constraint constraint;
        String string = opName;
        if ("eq".equals(string)) {
            Predef$.MODULE$.require(args.length() == 1);
            constraint = new Constraint.EQ(field, (String)args.apply(0));
        } else if ("lt".equals(string)) {
            Predef$.MODULE$.require(args.length() == 1);
            constraint = new Constraint.LT(field, (String)args.apply(0));
        } else if ("le".equals(string)) {
            Predef$.MODULE$.require(args.length() == 1);
            constraint = new Constraint.LE(field, (String)args.apply(0));
        } else if ("ge".equals(string)) {
            Predef$.MODULE$.require(args.length() == 1);
            constraint = new Constraint.GE(field, (String)args.apply(0));
        } else if ("gt".equals(string)) {
            Predef$.MODULE$.require(args.length() == 1);
            constraint = new Constraint.GT(field, (String)args.apply(0));
        } else if ("gt_lt".equals(string)) {
            Predef$.MODULE$.require(args.length() == 2);
            constraint = new Constraint.GT_LT(field, (String)args.apply(0), (String)args.apply(1));
        } else if ("ge_lt".equals(string)) {
            Predef$.MODULE$.require(args.length() == 2);
            constraint = new Constraint.GE_LT(field, (String)args.apply(0), (String)args.apply(1));
        } else if ("ge_le".equals(string)) {
            Predef$.MODULE$.require(args.length() == 2);
            constraint = new Constraint.GE_LE(field, (String)args.apply(0), (String)args.apply(1));
        } else if ("gt_le".equals(string)) {
            Predef$.MODULE$.require(args.length() == 2);
            constraint = new Constraint.GT_LE(field, (String)args.apply(0), (String)args.apply(1));
        } else if ("is_null".equals(string)) {
            Predef$.MODULE$.require(args.length() == 0);
            constraint = new Constraint.IS_NULL(field);
        } else if ("in".equals(string)) {
            Predef$.MODULE$.require(args.length() >= 1);
            constraint = new Constraint.IN(field, args);
        } else if ("not_in".equals(string)) {
            Predef$.MODULE$.require(args.length() >= 1);
            constraint = new Constraint.NOT_IN(field, args);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(33).append("Unrecognized constraint operator ").append(opName).toString());
        }
        return constraint;
    }

    public boolean isEQ(Object fv, String cv) {
        boolean bl;
        Object object = fv;
        if (object instanceof Boolean) {
            boolean bl2 = BoxesRunTime.unboxToBoolean((Object)object);
            bl = bl2 == this.decodeBoolean(cv);
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            bl = by == this.decodeByte(cv);
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            bl = s == this.decodeShort(cv);
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            bl = n == this.decodeInt(cv);
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            bl = l == this.decodeLong(cv);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            bl = f == this.decodeFloat(cv);
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            bl = d == this.decodeDouble(cv);
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            bl = timestamp.compareTo(this.decodeTimestamp(cv)) == 0;
        } else {
            throw new MatchError(object);
        }
        return bl;
    }

    public boolean isLT(Object fv, String cv) {
        boolean bl;
        Object object = fv;
        if (object instanceof Boolean) {
            boolean bl2 = BoxesRunTime.unboxToBoolean((Object)object);
            bl = new RichBoolean(Predef$.MODULE$.booleanWrapper(bl2)).$less((Object)BoxesRunTime.boxToBoolean((boolean)this.decodeBoolean(cv)));
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            bl = by < this.decodeByte(cv);
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            bl = s < this.decodeShort(cv);
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            bl = n < this.decodeInt(cv);
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            bl = l < this.decodeLong(cv);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            bl = f < this.decodeFloat(cv);
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            bl = d < this.decodeDouble(cv);
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            bl = timestamp.compareTo(this.decodeTimestamp(cv)) < 0;
        } else {
            throw new MatchError(object);
        }
        return bl;
    }

    public boolean isLE(Object fv, String cv) {
        boolean bl;
        Object object = fv;
        if (object instanceof Boolean) {
            boolean bl2 = BoxesRunTime.unboxToBoolean((Object)object);
            bl = new RichBoolean(Predef$.MODULE$.booleanWrapper(bl2)).$less$eq((Object)BoxesRunTime.boxToBoolean((boolean)this.decodeBoolean(cv)));
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            bl = by <= this.decodeByte(cv);
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            bl = s <= this.decodeShort(cv);
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            bl = n <= this.decodeInt(cv);
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            bl = l <= this.decodeLong(cv);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            bl = f <= this.decodeFloat(cv);
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            bl = d <= this.decodeDouble(cv);
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            bl = timestamp.compareTo(this.decodeTimestamp(cv)) <= 0;
        } else {
            throw new MatchError(object);
        }
        return bl;
    }

    public boolean isGE(Object fv, String cv) {
        boolean bl;
        Object object = fv;
        if (object instanceof Boolean) {
            boolean bl2 = BoxesRunTime.unboxToBoolean((Object)object);
            bl = new RichBoolean(Predef$.MODULE$.booleanWrapper(bl2)).$greater$eq((Object)BoxesRunTime.boxToBoolean((boolean)this.decodeBoolean(cv)));
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            bl = by >= this.decodeByte(cv);
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            bl = s >= this.decodeShort(cv);
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            bl = n >= this.decodeInt(cv);
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            bl = l >= this.decodeLong(cv);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            bl = f >= this.decodeFloat(cv);
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            bl = d >= this.decodeDouble(cv);
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            bl = timestamp.compareTo(this.decodeTimestamp(cv)) >= 0;
        } else {
            throw new MatchError(object);
        }
        return bl;
    }

    public boolean isGT(Object fv, String cv) {
        boolean bl;
        Object object = fv;
        if (object instanceof Boolean) {
            boolean bl2 = BoxesRunTime.unboxToBoolean((Object)object);
            bl = new RichBoolean(Predef$.MODULE$.booleanWrapper(bl2)).$greater((Object)BoxesRunTime.boxToBoolean((boolean)this.decodeBoolean(cv)));
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            bl = by > this.decodeByte(cv);
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            bl = s > this.decodeShort(cv);
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            bl = n > this.decodeInt(cv);
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            bl = l > this.decodeLong(cv);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            bl = f > this.decodeFloat(cv);
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            bl = d > this.decodeDouble(cv);
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            bl = timestamp.compareTo(this.decodeTimestamp(cv)) > 0;
        } else {
            throw new MatchError(object);
        }
        return bl;
    }

    private boolean decodeBoolean(String cv) {
        return new StringOps(Predef$.MODULE$.augmentString(cv)).toBoolean();
    }

    private byte decodeByte(String cv) {
        return new StringOps(Predef$.MODULE$.augmentString(cv)).toByte();
    }

    private short decodeShort(String cv) {
        return new StringOps(Predef$.MODULE$.augmentString(cv)).toShort();
    }

    private int decodeInt(String cv) {
        return new StringOps(Predef$.MODULE$.augmentString(cv)).toInt();
    }

    private long decodeLong(String cv) {
        return new StringOps(Predef$.MODULE$.augmentString(cv)).toLong();
    }

    private float decodeFloat(String cv) {
        return new StringOps(Predef$.MODULE$.augmentString(cv)).toFloat();
    }

    private double decodeDouble(String cv) {
        return new StringOps(Predef$.MODULE$.augmentString(cv)).toDouble();
    }

    private Timestamp decodeTimestamp(String cv) {
        return Timestamp.from(Instant.parse(cv));
    }

    private Constraint$() {
        MODULE$ = this;
    }
}

