/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.datasources.ipfix;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.LocalDate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.cert.netsa.data.time.LocalDateSet;
import org.cert.netsa.data.time.LocalDateSet$;
import org.cert.netsa.io.ipfix.InfoModel;
import org.cert.netsa.io.ipfix.InputStreamSession;
import org.cert.netsa.io.ipfix.InputStreamSession$;
import org.cert.netsa.io.ipfix.Record;
import org.cert.netsa.mothra.datasources.ipfix.Constraint;
import org.cert.netsa.mothra.datasources.ipfix.Debug$;
import org.cert.netsa.mothra.datasources.ipfix.SlicingRelation$;
import org.cert.netsa.mothra.datasources.ipfix.SlicingRelationConfig;
import org.cert.netsa.mothra.datasources.ipfix.SlicingRelationSparkVerImpl;
import org.cert.netsa.mothra.datasources.ipfix.fields.IPFIXField;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rEeA\u0002$H\u0003\u000395\u000b\u0003\u0005x\u0001\t\u0015\r\u0011\"\u0001z\u0011%\t\u0019\u0004\u0001B\u0001B\u0003%!\u0010\u0003\u0006\u00026\u0001\u0011)\u0019!C\u0001\u0003oA!\"a\u0012\u0001\u0005\u0003\u0005\u000b\u0011BA\u001d\u0011)\tI\u0005\u0001BC\u0002\u0013\u0005\u00111\n\u0005\u000b\u0003'\u0002!\u0011!Q\u0001\n\u00055\u0003BCA+\u0001\t\u0015\r\u0011\"\u0001\u0002X!Q\u0011\u0011\r\u0001\u0003\u0002\u0003\u0006I!!\u0017\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!9\u0011\u0011\u0010\u0001\u0007\u0002\u0005m\u0004bBAH\u0001\u0019\u0005\u0011\u0011\u0013\u0005\b\u0005[\u0004a\u0011\u0001Bx\u0011\u001d\u0011I\u0010\u0001C\u0001\u0005wD\u0011B!@\u0001\u0005\u0004%\tAa@\t\u0011\r5\u0001\u0001)A\u0005\u0007\u0003Aqaa\u0004\u0001\t\u000b\u0019\t\u0002\u0003\u0005\u0004$\u0001!\taRB\u0013\u0011!\u0019i\u0003\u0001C\u0001\u000f\u000e=\u0002bBB\u001c\u0001\u0011\u00151\u0011\b\u0005\b\u0007\u001f\u0002AQAB)\u0011\u001d\u0019I\u0006\u0001C\u0003\u00077Bqa!\u001c\u0001\t\u0013\u0019y\u0007C\u0005\u0004t\u0001\u0011\r\u0011\"\u0011\u0004v!A11\u0011\u0001!\u0002\u0013\u00199\bC\u0004\u0004\u0006\u0002!\tea\"\b\u0011\u0005uu\t#\u0001H\u0003?3qAR$\t\u0002\u001d\u000b\t\u000bC\u0004\u0002lm!\t!!+\u0007\r\u0005-6\u0004QAW\u0011)\ti)\bBK\u0002\u0013\u0005\u0011Q\u0017\u0005\u000b\u0003ok\"\u0011#Q\u0001\n\u0005M\u0001BCA];\tU\r\u0011\"\u0001\u0002<\"Q\u00111Y\u000f\u0003\u0012\u0003\u0006I!!0\t\u000f\u0005-T\u0004\"\u0001\u0002F\"I\u0011qZ\u000f\u0002\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u0003/l\u0012\u0013!C\u0001\u00033D\u0011\"a<\u001e#\u0003%\t!!=\t\u0013\u0005UX$!A\u0005B\u0005]\b\"\u0003B\u0002;\u0005\u0005I\u0011\u0001B\u0003\u0011%\u0011i!HA\u0001\n\u0003\u0011y\u0001C\u0005\u0003\u0016u\t\t\u0011\"\u0011\u0003\u0018!I!1E\u000f\u0002\u0002\u0013\u0005!Q\u0005\u0005\n\u0005_i\u0012\u0011!C!\u0005cA\u0011Ba\r\u001e\u0003\u0003%\tE!\u000e\t\u0013\t]R$!A\u0005B\ter!\u0003B\u001f7\u0005\u0005\t\u0012\u0001B \r%\tYkGA\u0001\u0012\u0003\u0011\t\u0005C\u0004\u0002l=\"\tAa\u0014\t\u0013\tMr&!A\u0005F\tU\u0002\"\u0003B)_\u0005\u0005I\u0011\u0011B*\u0011%\u0011IfLA\u0001\n\u0003\u0013Y\u0006C\u0005\u0003j=\n\t\u0011\"\u0003\u0003l\u0019I!1O\u000e\u0011\u0002G\u0005!Q\u000f\u0005\b\u0005o*d\u0011\u0001B=\u0011\u001d\u0011i(\u000eD\u0001\u0005\u007fBqAa!6\r\u0003\u0011y\bC\u0005\u0003\u0006n\u0011\r\u0011\"\u0003\u0003\b\"A!\u0011T\u000e!\u0002\u0013\u0011I\tC\u0005\u0003\u001cn\u0011\r\u0011\"\u0003\u0003\u001e\"A!qU\u000e!\u0002\u0013\u0011y\nC\u0005\u0003*n\u0011\r\u0011\"\u0003\u0003,\"A!QX\u000e!\u0002\u0013\u0011i\u000bC\u0005\u0003@n\u0011\r\u0011\"\u0003\u0003\b\"A!\u0011Y\u000e!\u0002\u0013\u0011I\tC\u0004\u0003Dn!\tA!2\t\u0013\tE7D1A\u0005\n\t\u001d\u0005\u0002\u0003Bj7\u0001\u0006IA!#\t\u000f\tU7\u0004\"\u0001\u0003X\"I!\u0011N\u000e\u0002\u0002\u0013%!1\u000e\u0002\u0010'2L7-\u001b8h%\u0016d\u0017\r^5p]*\u0011\u0001*S\u0001\u0006SB4\u0017\u000e\u001f\u0006\u0003\u0015.\u000b1\u0002Z1uCN|WO]2fg*\u0011A*T\u0001\u0007[>$\bN]1\u000b\u00059{\u0015!\u00028fiN\f'B\u0001)R\u0003\u0011\u0019WM\u001d;\u000b\u0003I\u000b1a\u001c:h'\u0019\u0001A\u000b\u00193h[B\u0011QKX\u0007\u0002-*\u0011q\u000bW\u0001\bg>,(oY3t\u0015\tI&,A\u0002tc2T!a\u0017/\u0002\u000bM\u0004\u0018M]6\u000b\u0005u\u000b\u0016AB1qC\u000eDW-\u0003\u0002`-\na!)Y:f%\u0016d\u0017\r^5p]B\u0011\u0011MY\u0007\u0002\u000f&\u00111m\u0012\u0002\u001c'2L7-\u001b8h%\u0016d\u0017\r^5p]N\u0003\u0018M]6WKJLU\u000e\u001d7\u0011\u0005U+\u0017B\u00014W\u0005I\u0001&/\u001e8fI\u001aKG\u000e^3sK\u0012\u001c6-\u00198\u0011\u0005!\\W\"A5\u000b\u0003)\fQa]2bY\u0006L!\u0001\\5\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u00059,X\"A8\u000b\u0005A\f\u0018\u0001D:dC2\fGn\\4hS:<'B\u0001:t\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001;\u0002\u0007\r|W.\u0003\u0002w_\nYA*\u0019>z\u0019><w-\u001b8h\u0003\u00191\u0017.\u001a7eg\u000e\u0001Q#\u0001>\u0011\u000bm\f9!!\u0004\u000f\u0007q\f\u0019AD\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007fb\fa\u0001\u0010:p_Rt\u0014\"\u00016\n\u0007\u0005\u0015\u0011.A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00111\u0002\u0002\u0004'\u0016\f(bAA\u0003SB9\u0001.a\u0004\u0002\u0014\u0005\r\u0012bAA\tS\n1A+\u001e9mKJ\u0002B!!\u0006\u0002\u001e9!\u0011qCA\r!\ti\u0018.C\u0002\u0002\u001c%\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0010\u0003C\u0011aa\u0015;sS:<'bAA\u000eSB1\u0011QEA\u0015\u0003[i!!a\n\u000b\u0005]<\u0015\u0002BA\u0016\u0003O\u0011!\"\u0013)G\u0013b3\u0015.\u001a7e!\rA\u0017qF\u0005\u0004\u0003cI'aA!os\u00069a-[3mIN\u0004\u0013!C5oM>lu\u000eZ3m+\t\tI\u0004\u0005\u0003\u0002<\u0005\rSBAA\u001f\u0015\rA\u0015q\b\u0006\u0004\u0003\u0003j\u0015AA5p\u0013\u0011\t)%!\u0010\u0003\u0013%sgm\\'pI\u0016d\u0017AC5oM>lu\u000eZ3mA\u000511m\u001c8gS\u001e,\"!!\u0014\u0011\u0007\u0005\fy%C\u0002\u0002R\u001d\u0013Qc\u00157jG&twMU3mCRLwN\\\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u0015M\fHnQ8oi\u0016DH/\u0006\u0002\u0002ZA!\u00111LA/\u001b\u0005A\u0016bAA01\nQ1+\u0015'D_:$X\r\u001f;\u0002\u0017M\fHnQ8oi\u0016DH\u000f\t\u0015\u0004\u0011\u0005\u0015\u0004c\u00015\u0002h%\u0019\u0011\u0011N5\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018A\u0002\u001fj]&$h\b\u0006\u0006\u0002p\u0005E\u00141OA;\u0003o\u0002\"!\u0019\u0001\t\u000b]L\u0001\u0019\u0001>\t\u000f\u0005U\u0012\u00021\u0001\u0002:!9\u0011\u0011J\u0005A\u0002\u00055\u0003bBA+\u0013\u0001\u0007\u0011\u0011L\u0001\r_B,g\u000eT8dCRLwN\u001c\u000b\u0005\u0003{\nY\t\u0005\u0003\u0002\u0000\u0005\u001dUBAAA\u0015\u0011\t\t%a!\u000b\u0005\u0005\u0015\u0015\u0001\u00026bm\u0006LA!!#\u0002\u0002\nY\u0011J\u001c9viN#(/Z1n\u0011\u001d\tiI\u0003a\u0001\u0003'\t\u0001\u0002\\8dCRLwN\\\u0001\u0016M&dG/\u001a:fI2{7-\u0019;j_:\u001c\u0016N_3t)!\t\u0019J!8\u0003`\n\u0005\b#B>\u0002\u0016\u0006e\u0015\u0002BAL\u0003\u0017\u0011\u0001\"\u0013;fe\u0006$xN\u001d\t\u0004\u00037kbBA1\u001b\u0003=\u0019F.[2j]\u001e\u0014V\r\\1uS>t\u0007CA1\u001c'\u0011Y\u00121U4\u0011\u0007!\f)+C\u0002\u0002(&\u0014a!\u00118z%\u00164GCAAP\u00051aunY1uS>t7+\u001b>f'\u0019i\u00121UAXOB\u0019\u0001.!-\n\u0007\u0005M\u0016NA\u0004Qe>$Wo\u0019;\u0016\u0005\u0005M\u0011!\u00037pG\u0006$\u0018n\u001c8!\u0003\u0011\u0019\u0018N_3\u0016\u0005\u0005u\u0006c\u00015\u0002@&\u0019\u0011\u0011Y5\u0003\t1{gnZ\u0001\u0006g&TX\r\t\u000b\u0007\u0003\u000f\fY-!4\u0011\u0007\u0005%W$D\u0001\u001c\u0011\u001d\tiI\ta\u0001\u0003'Aq!!/#\u0001\u0004\ti,\u0001\u0003d_BLHCBAd\u0003'\f)\u000eC\u0005\u0002\u000e\u000e\u0002\n\u00111\u0001\u0002\u0014!I\u0011\u0011X\u0012\u0011\u0002\u0003\u0007\u0011QX\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYN\u000b\u0003\u0002\u0014\u0005u7FAAp!\u0011\t\t/a;\u000e\u0005\u0005\r(\u0002BAs\u0003O\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%\u0018.\u0001\u0006b]:|G/\u0019;j_:LA!!<\u0002d\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u001f\u0016\u0005\u0003{\u000bi.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003s\u0004B!a?\u0003\u00025\u0011\u0011Q \u0006\u0005\u0003\u007f\f\u0019)\u0001\u0003mC:<\u0017\u0002BA\u0010\u0003{\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u0002\u0011\u0007!\u0014I!C\u0002\u0003\f%\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\f\u0003\u0012!I!1\u0003\u0015\u0002\u0002\u0003\u0007!qA\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\te\u0001C\u0002B\u000e\u0005C\ti#\u0004\u0002\u0003\u001e)\u0019!qD5\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0018\nu\u0011\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t\u001d\"Q\u0006\t\u0004Q\n%\u0012b\u0001B\u0016S\n9!i\\8mK\u0006t\u0007\"\u0003B\nU\u0005\u0005\t\u0019AA\u0017\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\u0004\u0003!!xn\u0015;sS:<GCAA}\u0003\u0019)\u0017/^1mgR!!q\u0005B\u001e\u0011%\u0011\u0019\"LA\u0001\u0002\u0004\ti#\u0001\u0007M_\u000e\fG/[8o'&TX\rE\u0002\u0002J>\u001aBa\fB\"OBQ!Q\tB&\u0003'\ti,a2\u000e\u0005\t\u001d#b\u0001B%S\u00069!/\u001e8uS6,\u0017\u0002\u0002B'\u0005\u000f\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011y$A\u0003baBd\u0017\u0010\u0006\u0004\u0002H\nU#q\u000b\u0005\b\u0003\u001b\u0013\u0004\u0019AA\n\u0011\u001d\tIL\ra\u0001\u0003{\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003^\t\u0015\u0004#\u00025\u0003`\t\r\u0014b\u0001B1S\n1q\n\u001d;j_:\u0004r\u0001[A\b\u0003'\ti\fC\u0005\u0003hM\n\t\u00111\u0001\u0002H\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005[\u0002B!a?\u0003p%!!\u0011OA\u007f\u0005\u0019y%M[3di\n)1\u000b\\5dKN!Q'a)h\u0003%awnY1uS>t7/\u0006\u0002\u0003|A)10!&\u0002\u0014\u0005Q1\u000f^1si\u00063G/\u001a:\u0016\u0005\t\u0005\u0005#\u00025\u0003`\u0005M\u0011a\u00034j]&\u001c\b.\u00114uKJ\fq\"_7e!J,g-\u001b=G_Jl\u0017\r^\u000b\u0003\u0005\u0013\u0003BAa#\u0003\u00166\u0011!Q\u0012\u0006\u0005\u0005\u001f\u0013\t*\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0005\u0005'\u000b\u0019)\u0001\u0003uS6,\u0017\u0002\u0002BL\u0005\u001b\u0013\u0011\u0003R1uKRKW.\u001a$pe6\fG\u000f^3s\u0003AIX\u000e\u001a)sK\u001aL\u0007PR8s[\u0006$\b%A\u0002vi\u000e,\"Aa(\u0011\t\t\u0005&1U\u0007\u0003\u0005#KAA!*\u0003\u0012\n1!l\u001c8f\u0013\u0012\fA!\u001e;dA\u0005\tBn\\2bi&|g\u000eU1ui\u0016\u0014hN\u0016\u001a\u0016\u0005\t5\u0006\u0003\u0002BX\u0005sk!A!-\u000b\t\tM&QW\u0001\t[\u0006$8\r[5oO*\u0019!qW5\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005w\u0013\tLA\u0003SK\u001e,\u00070\u0001\nm_\u000e\fG/[8o!\u0006$H/\u001a:o-J\u0002\u0013AC=nI\"4uN]7bi\u0006Y\u00110\u001c3i\r>\u0014X.\u0019;!\u0003Y\u0019wN\\:ue\u0006Lg\u000e^:G_JdunY1uS>tG\u0003\u0002Bd\u0005\u001f\u0004Ra_A\u0004\u0005\u0013\u00042!\u0019Bf\u0013\r\u0011im\u0012\u0002\u000b\u0007>t7\u000f\u001e:bS:$\bbBAG\u0003\u0002\u0007\u00111C\u0001\ns6$gi\u001c:nCR\f!\"_7e\r>\u0014X.\u0019;!\u0003I\u0019wN\\:ue\u0006Lg\u000e^:G_J$\u0015\r^3\u0015\t\t\u001d'\u0011\u001c\u0005\b\u00057$\u0005\u0019AA\n\u0003\u001d!\u0017\r^3TiJDqA! \f\u0001\u0004\u0011\t\tC\u0004\u0003\u0004.\u0001\rA!!\t\u000f\t\r8\u00021\u0001\u0003f\u00069a-\u001b7uKJ\u001c\b#B>\u0002\b\t\u001d\bcA+\u0003j&\u0019!1\u001e,\u0003\r\u0019KG\u000e^3s\u0003%i\u0017m[3TY&\u001cW\r\u0006\u0005\u0003r\nM(Q\u001fB|!\r\tY*\u000e\u0005\b\u0005{b\u0001\u0019\u0001BA\u0011\u001d\u0011\u0019\t\u0004a\u0001\u0005\u0003CqAa9\r\u0001\u0004\u0011)/\u0001\ntkB\u0004xN\u001d;t\t\u0006$Xm\u00157jG\u0016\u001cXC\u0001B\u0014\u0003!1\u0017.\u001a7e\u001b\u0006\u0004XCAB\u0001!!\u0019\u0019a!\u0003\u0002\u0014\u0005\rRBAB\u0003\u0015\u0011\u00199A!\b\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BB\u0006\u0007\u000b\u00111!T1q\u0003%1\u0017.\u001a7e\u001b\u0006\u0004\b%A\beCR,7OR8s\r&dG/\u001a:t)\u0011\u0019\u0019b!\t\u0011\t\rU1QD\u0007\u0003\u0007/QAAa%\u0004\u001a)\u001911D'\u0002\t\u0011\fG/Y\u0005\u0005\u0007?\u00199B\u0001\u0007M_\u000e\fG\u000eR1uKN+G\u000fC\u0004\u0003dB\u0001\rA!:\u0002\u001d\u0011\fG/Z:G_J4\u0015\u000e\u001c;feR!1qEB\u0015!\u0015A'qLB\n\u0011\u001d\u0019Y#\u0005a\u0001\u0005O\f\u0011AZ\u0001\u0014I\u0006$Xm\u001d$pe\u001aKW\r\u001c3GS2$XM\u001d\u000b\u0007\u0007O\u0019\td!\u000e\t\u000f\rM\"\u00031\u0001\u0002\u0014\u0005)a-[3mI\"911\u0006\nA\u0002\t\u001d\u0018!\u00054jYR,'/\u001a3TY&\u001cWmU2b]R!11HB$!\u0019\u0019ida\u0011\u0003r6\u00111q\b\u0006\u0004\u0007\u0003R\u0016a\u0001:eI&!1QIB \u0005\r\u0011F\t\u0012\u0005\b\u0005G\u001c\u0002\u0019AB%!\u0015A71\nBt\u0013\r\u0019i%\u001b\u0002\u0006\u0003J\u0014\u0018-_\u0001\rG\",7m\u001b$jYR,'o\u001d\u000b\u0007\u0005O\u0019\u0019fa\u0016\t\u000f\rUC\u00031\u0001\u0003H\u0006Y1m\u001c8tiJ\f\u0017N\u001c;t\u0011\u001d\u0011\u0019\u000f\u0006a\u0001\u0005K\f!B]3d_J$7kY1o)\u0019\u0019if!\u001a\u0004lA11QHB\"\u0007?\u0002B!a\u0017\u0004b%\u001911\r-\u0003\u0007I{w\u000fC\u0004\u0004hU\u0001\ra!\u001b\u0002\u001dI,\u0017/^5sK\u00124\u0015.\u001a7egB)\u0001na\u0013\u0002$!9!1]\u000bA\u0002\r%\u0013!G8qK:dunY1uS>t\u0017I\u001c3EK\u000e|W\u000e\u001d:fgN$B!! \u0004r!9\u0011Q\u0012\fA\u0002\u0005M\u0011AB:dQ\u0016l\u0017-\u0006\u0002\u0004xA!1\u0011PB@\u001b\t\u0019YHC\u0002\u0004~a\u000bQ\u0001^=qKNLAa!!\u0004|\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u000fM\u001c\u0007.Z7bA\u0005I!-^5mIN\u001b\u0017M\u001c\u000b\u0007\u0007;\u001aIia$\t\u000f\r-\u0015\u00041\u0001\u0004\u000e\u0006y!/Z9vSJ,GmQ8mk6t7\u000fE\u0003i\u0007\u0017\n\u0019\u0002C\u0004\u0003df\u0001\ra!\u0013")
public abstract class SlicingRelation
extends BaseRelation
implements SlicingRelationSparkVerImpl,
PrunedFilteredScan,
scala.Serializable,
LazyLogging {
    private final Seq<Tuple2<String, IPFIXField<Object>>> fields;
    private final InfoModel infoModel;
    private final SlicingRelationConfig config;
    private final transient SQLContext sqlContext;
    private final Map<String, IPFIXField<Object>> fieldMap;
    private final StructType schema;
    private transient Logger logger;
    private volatile byte bitmap$init$0;
    private volatile transient boolean bitmap$trans$0;

    public static Seq<Constraint> constraintsForDate(String string) {
        return SlicingRelation$.MODULE$.constraintsForDate(string);
    }

    public static Seq<Constraint> constraintsForLocation(String string) {
        return SlicingRelation$.MODULE$.constraintsForLocation(string);
    }

    @Override
    public Option<LocalDateSet> datesForFilterImpl(Filter f) {
        return SlicingRelationSparkVerImpl.datesForFilterImpl$(this, f);
    }

    @Override
    public final boolean checkFiltersImpl(Seq<Constraint> constraints, Seq<Filter> filters) {
        return SlicingRelationSparkVerImpl.checkFiltersImpl$(this, constraints, filters);
    }

    private Logger logger$lzycompute() {
        SlicingRelation slicingRelation = this;
        synchronized (slicingRelation) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Seq<Tuple2<String, IPFIXField<Object>>> fields() {
        return this.fields;
    }

    public InfoModel infoModel() {
        return this.infoModel;
    }

    public SlicingRelationConfig config() {
        return this.config;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public abstract InputStream openLocation(String var1);

    public abstract Iterator<LocationSize> filteredLocationSizes(Option<String> var1, Option<String> var2, Seq<Filter> var3);

    public abstract Slice makeSlice(Option<String> var1, Option<String> var2, Seq<Filter> var3);

    public boolean supportsDateSlices() {
        return true;
    }

    @Override
    public Map<String, IPFIXField<Object>> fieldMap() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_datasources_ipfix/src/SlicingRelation.scala: 103");
        }
        return this.fieldMap;
    }

    public final LocalDateSet datesForFilters(Seq<Filter> filters) {
        return (LocalDateSet)((TraversableOnce)filters.map((Function1 & Serializable & scala.Serializable)x$1 -> (LocalDateSet)this.datesForFilter((Filter)x$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> LocalDateSet$.MODULE$.ALL()), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)LocalDateSet$.MODULE$.ALL(), (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.$amp(x$3));
    }

    @Override
    public Option<LocalDateSet> datesForFilter(Filter f) {
        return this.datesForFilterImpl(f);
    }

    @Override
    public Option<LocalDateSet> datesForFieldFilter(String field, Filter f) {
        return this.fieldMap().get((Object)field).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.filterDates(f));
    }

    public final RDD<Slice> filteredSliceScan(Filter[] filters) {
        RDD rDD;
        LocalDateSet dateSet;
        Seq filterSeq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).toSeq();
        LocalDateSet localDateSet = dateSet = this.supportsDateSlices() ? this.datesForFilters((Seq<Filter>)filterSeq) : LocalDateSet$.MODULE$.ALL();
        if (dateSet.isEmpty()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("dateSet is empty");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            rDD = this.sqlContext().sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Slice.class));
        } else {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            BoxedUnit boxedUnit5;
            LocalDate dateMin = dateSet.min();
            LocalDate dateMax = dateSet.max();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Filters: {}", new Object[]{filterSeq});
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Date range: {} {}", new Object[]{dateMin, dateMax});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Dates: {}", new Object[]{dateSet});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            LocalDate localDate = dateMin;
            LocalDate localDate2 = LocalDate.MIN;
            None$ startAfter = !(localDate != null ? !((Object)localDate).equals(localDate2) : localDate2 != null) ? None$.MODULE$ : new Some((Object)dateMin.format(SlicingRelation$.MODULE$.org$cert$netsa$mothra$datasources$ipfix$SlicingRelation$$ymdPrefixFormat()));
            LocalDate localDate3 = dateMax;
            LocalDate localDate4 = LocalDate.MAX;
            None$ finishAfter = !(localDate3 != null ? !((Object)localDate3).equals(localDate4) : localDate4 != null) ? None$.MODULE$ : new Some((Object)dateMax.plusDays(1L).format(SlicingRelation$.MODULE$.org$cert$netsa$mothra$datasources$ipfix$SlicingRelation$$ymdPrefixFormat()));
            long sliceSize = BoxesRunTime.unboxToLong((Object)this.config().targetSize().getOrElse((Function0)((JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> SlicingRelation.$anonfun$filteredSliceScan$1(this, (Option)startAfter, (Option)finishAfter, filterSeq))));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Tarrget slice size: {}", new Object[]{BoxesRunTime.boxToLong((long)sliceSize)});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            ObjectRef filteredSlices = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
            LongRef currentSize = LongRef.create((long)0L);
            ObjectRef currentStartAfter = ObjectRef.create((Object)startAfter);
            this.filteredLocationSizes((Option<String>)startAfter, (Option<String>)finishAfter, (Seq<Filter>)filterSeq).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)SlicingRelation.$anonfun$filteredSliceScan$4(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                SlicingRelation.$anonfun$filteredSliceScan$5(this, currentSize, sliceSize, filteredSlices, currentStartAfter, filterSeq, x$7);
                return BoxedUnit.UNIT;
            });
            Slice slice = this.makeSlice((Option<String>)((Option)currentStartAfter.elem), (Option<String>)finishAfter, (Seq<Filter>)filterSeq);
            filteredSlices.elem = (Seq)((Seq)filteredSlices.elem).$plus$colon((Object)slice, Seq$.MODULE$.canBuildFrom());
            Slice[] slices = (Slice[])((Seq)filteredSlices.elem).toArray(ClassTag$.MODULE$.apply(Slice.class));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Slices: {}", new Object[]{slices});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            rDD = this.sqlContext().sparkContext().parallelize(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])slices)).toSeq(), slices.length, ClassTag$.MODULE$.apply(Slice.class));
        }
        return rDD;
    }

    public final boolean checkFilters(Seq<Constraint> constraints, Seq<Filter> filters) {
        return this.checkFiltersImpl(constraints, filters);
    }

    public final RDD<Row> recordScan(IPFIXField<Object>[] requiredFields, Filter[] filters) {
        return this.filteredSliceScan(filters).flatMap((Function1 & Serializable & scala.Serializable)slice -> {
            IntRef totalFailures = IntRef.create((int)0);
            IntRef openFailures = IntRef.create((int)0);
            IntRef parseFailures = IntRef.create((int)0);
            IntRef skippedLocations = IntRef.create((int)0);
            IntRef locationParseFailures = IntRef.create((int)0);
            return slice.locations().flatMap((Function1 & Serializable & scala.Serializable)location -> this.liftedTree1$1(locationParseFailures, (String)location, openFailures, totalFailures, (Slice)slice, parseFailures, skippedLocations).flatMap((Function1 & Serializable & scala.Serializable)session -> package$.MODULE$.Iterator().continually(() -> SlicingRelation.$anonfun$recordScan$8(this, session, requiredFields, location, locationParseFailures, parseFailures, totalFailures, skippedLocations, openFailures, slice)).takeWhile((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)SlicingRelation.$anonfun$recordScan$11(x$14))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)SlicingRelation.$anonfun$recordScan$12(check$ifrefutable$3))).map((Function1 & Serializable & scala.Serializable)x$15 -> {
                Some some;
                Option option;
                Option option2 = x$15;
                if (!(option2 instanceof Some) || !((option = (Option)(some = (Some)option2).value()) instanceof Some)) {
                    throw new MatchError((Object)option2);
                }
                Some some2 = (Some)option;
                Object[] row = (Object[])some2.value();
                Row row2 = Row$.MODULE$.fromSeq(Predef$.MODULE$.genericArrayOps((Object)row).toSeq());
                return row2;
            })));
        }, ClassTag$.MODULE$.apply(Row.class));
    }

    private InputStream openLocationAndDecompress(String location) {
        InputStream inputStream;
        Option codec;
        Option option;
        try {
            CompressionCodecFactory factory = new CompressionCodecFactory(new Configuration());
            option = Option$.MODULE$.apply((Object)factory.getCodec(new Path(location)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            option = none$;
        }
        Option option3 = codec = option;
        if (None$.MODULE$.equals(option3)) {
            inputStream = this.openLocation(location);
        } else if (option3 instanceof Some) {
            Some some = (Some)option3;
            CompressionCodec c = (CompressionCodec)some.value();
            inputStream = c.createInputStream(this.openLocation(location), CodecPool.getDecompressor((CompressionCodec)c));
        } else {
            throw new MatchError((Object)option3);
        }
        return inputStream;
    }

    public StructType schema() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/prevost1/src/site/code.sei.cmu.edu/mothra-base/mothra_datasources_ipfix/src/SlicingRelation.scala: 355");
        }
        return this.schema;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        String k;
        String k2;
        StructField[] requiredSchemaFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).isEmpty() ? this.schema().fields() : new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).map((Function1 & Serializable & scala.Serializable)x$16 -> this.schema().apply(x$16), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))).fields();
        IPFIXField[] requiredFields = (IPFIXField[])Array$.MODULE$.tabulate(requiredSchemaFields.length, (Function1 & Serializable & scala.Serializable)i -> SlicingRelation.$anonfun$buildScan$2(this, requiredSchemaFields, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(IPFIXField.class));
        boolean bl = false;
        Some some = null;
        Option<String> option = this.config().debugMode();
        if (None$.MODULE$.equals(option)) {
            return this.recordScan(requiredFields, filters);
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String k3 = (String)some.value();
            if (k3.startsWith("slices")) {
                Debug$.MODULE$.update(k3, (Seq<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.filteredSliceScan(filters).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.toString(), ClassTag$.MODULE$.apply(String.class)).collect())).toSeq());
                return this.sqlContext().sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class));
            }
        }
        if (bl && (k2 = (String)some.value()).startsWith("files")) {
            Debug$.MODULE$.update(k2, (Seq<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.filteredSliceScan(filters).flatMap((Function1 & Serializable & scala.Serializable)x$18 -> x$18.locations(), ClassTag$.MODULE$.apply(String.class)).collect())).toSeq());
            return this.sqlContext().sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class));
        }
        if (bl && (k = (String)some.value()).startsWith("sliced_files")) {
            Debug$.MODULE$.update(k, (Seq<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.filteredSliceScan(filters).map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.locations().toList().toString(), ClassTag$.MODULE$.apply(String.class)).collect())).toSeq());
            return this.sqlContext().sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class));
        }
        if (!bl) throw new MatchError(option);
        String k4 = (String)some.value();
        throw new IllegalArgumentException(new StringBuilder(69).append("Debug mode '").append(k4).append("' doesn't start with 'slices', 'files', or ").append("'sliced_files'").toString());
    }

    public static final /* synthetic */ boolean $anonfun$filteredSliceScan$2(LocationSize check$ifrefutable$1) {
        LocationSize locationSize = check$ifrefutable$1;
        boolean bl = locationSize != null;
        return bl;
    }

    public static final /* synthetic */ long $anonfun$filteredSliceScan$3(LocationSize x$5) {
        long size;
        LocationSize locationSize = x$5;
        if (locationSize == null) {
            throw new MatchError((Object)locationSize);
        }
        long l = size = locationSize.size();
        return l;
    }

    public static final /* synthetic */ long $anonfun$filteredSliceScan$1(SlicingRelation $this, Option startAfter$1, Option finishAfter$1, Seq filterSeq$1) {
        BoxedUnit boxedUnit;
        long totalSize = BoxesRunTime.unboxToLong((Object)$this.filteredLocationSizes((Option<String>)startAfter$1, (Option<String>)finishAfter$1, (Seq<Filter>)filterSeq$1).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SlicingRelation.$anonfun$filteredSliceScan$2(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)SlicingRelation.$anonfun$filteredSliceScan$3(x$5))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Total size: {}", new Object[]{BoxesRunTime.boxToLong((long)totalSize)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return totalSize / (long)$this.config().numSlices();
    }

    public static final /* synthetic */ boolean $anonfun$filteredSliceScan$4(LocationSize check$ifrefutable$2) {
        LocationSize locationSize = check$ifrefutable$2;
        boolean bl = locationSize != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$filteredSliceScan$5(SlicingRelation $this, LongRef currentSize$1, long sliceSize$1, ObjectRef filteredSlices$1, ObjectRef currentStartAfter$1, Seq filterSeq$1, LocationSize x$7) {
        LocationSize locationSize = x$7;
        if (locationSize != null) {
            String location = locationSize.location();
            long size = locationSize.size();
            if (currentSize$1.elem != 0L && currentSize$1.elem + size / 2L > sliceSize$1) {
                Slice slice = $this.makeSlice((Option<String>)((Option)currentStartAfter$1.elem), (Option<String>)new Some((Object)location), (Seq<Filter>)filterSeq$1);
                filteredSlices$1.elem = (Seq)((Seq)filteredSlices$1.elem).$plus$colon((Object)slice, Seq$.MODULE$.canBuildFrom());
                currentSize$1.elem = 0L;
                currentStartAfter$1.elem = new Some((Object)location);
            }
            currentSize$1.elem += size;
        } else {
            throw new MatchError((Object)locationSize);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void abort$1(String message, Throwable cause) {
        throw new Exception(message, cause);
    }

    private final void abortOrWarn$1(String message, Throwable cause, IntRef openFailures$1, Slice slice$1, IntRef parseFailures$1, IntRef skippedLocations$1, IntRef totalFailures$1) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn(message, cause);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        if (!this.config().maxOpenFailures().exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> openFailures$1.elem > x$9)) break block2;
                        SlicingRelation.abort$1(new StringBuilder(34).append("Too many open failures in slice ").append(slice$1).append(": ").append(message).toString(), cause);
                        break block3;
                    }
                    if (!this.config().maxParseFailures().exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$10 -> parseFailures$1.elem > x$10)) break block4;
                    SlicingRelation.abort$1(new StringBuilder(35).append("Too many parse failures in slice ").append(slice$1).append(": ").append(message).toString(), cause);
                    break block3;
                }
                if (!this.config().maxSkippedLocations().exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$11 -> skippedLocations$1.elem > x$11)) break block5;
                SlicingRelation.abort$1(new StringBuilder(35).append("Too many location skips in slice ").append(slice$1).append(": ").append(message).toString(), cause);
                break block3;
            }
            if (!this.config().maxTotalFailures().exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$12 -> totalFailures$1.elem > x$12)) break block3;
            SlicingRelation.abort$1(new StringBuilder(35).append("Too many total failures in slice ").append(slice$1).append(": ").append(message).toString(), cause);
        }
    }

    private final /* synthetic */ Iterator liftedTree1$1(IntRef locationParseFailures$1, String location$1, IntRef openFailures$1, IntRef totalFailures$1, Slice slice$1, IntRef parseFailures$1, IntRef skippedLocations$1) {
        Iterator iterator;
        try {
            locationParseFailures$1.elem = 0;
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputStreamSession[]{InputStreamSession$.MODULE$.apply(this.openLocationAndDecompress(location$1), this.infoModel())}));
        }
        catch (Exception ex) {
            ++openFailures$1.elem;
            ++totalFailures$1.elem;
            this.abortOrWarn$1(new StringBuilder(26).append("Open failure for location ").append(location$1).toString(), ex, openFailures$1, slice$1, parseFailures$1, skippedLocations$1, totalFailures$1);
            iterator = package$.MODULE$.Iterator().empty();
        }
        return iterator;
    }

    public static final /* synthetic */ Object $anonfun$recordScan$9(Record rec$1, String location$1, IPFIXField f) {
        return f.extractOne(rec$1, location$1).orNull(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$recordScan$10(IntRef locationParseFailures$1, int x$13) {
        return locationParseFailures$1.elem > x$13;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Option $anonfun$recordScan$8(SlicingRelation $this, InputStreamSession session$1, IPFIXField[] requiredFields$1, String location$1, IntRef locationParseFailures$1, IntRef parseFailures$1, IntRef totalFailures$1, IntRef skippedLocations$1, IntRef openFailures$1, Slice slice$1) {
        try {
            block9: {
                block8: {
                    var11_10 = false;
                    var12_11 = null;
                    var13_12 = session$1.call();
                    if (!None$.MODULE$.equals(var13_12)) break block8;
                    var10_13 = new Some((Object)None$.MODULE$);
                    break block9;
                }
                if (!(var13_12 instanceof Some)) ** GOTO lbl-1000
                var11_10 = true;
                var12_11 = (Some)var13_12;
                rec = (Record)var12_11.value();
                if (rec.template().isMetadataTemplate()) {
                    var10_13 = None$.MODULE$;
                } else if (var11_10) {
                    rec = (Record)var12_11.value();
                    var10_13 = new Some((Object)new Some(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredFields$1)).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$recordScan$9(org.cert.netsa.io.ipfix.Record java.lang.String org.cert.netsa.mothra.datasources.ipfix.fields.IPFIXField ), (Lorg/cert/netsa/mothra/datasources/ipfix/fields/IPFIXField;)Ljava/lang/Object;)((Record)rec, (String)location$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))));
                } else {
                    throw new MatchError((Object)var13_12);
                }
            }
            v0 = var10_13;
        }
        catch (Exception ex) {
            ++locationParseFailures$1.elem;
            ++parseFailures$1.elem;
            ++totalFailures$1.elem;
            if ($this.config().maxLocationParseFailures().exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (I)Z, $anonfun$recordScan$10(scala.runtime.IntRef int ), (I)Z)((IntRef)locationParseFailures$1))) {
                ++skippedLocations$1.elem;
                v1 = new Some((Object)None$.MODULE$);
            } else {
                v1 = None$.MODULE$;
            }
            result = v1;
            $this.abortOrWarn$1(new StringBuilder(37).append("Parse failure for record in location ").append(location$1).toString(), ex, openFailures$1, slice$1, parseFailures$1, skippedLocations$1, totalFailures$1);
            v0 = result;
        }
        return v0;
    }

    public static final /* synthetic */ boolean $anonfun$recordScan$11(Option x$14) {
        Option option = x$14;
        Some some = new Some((Object)None$.MODULE$);
        return option == null ? some != null : !option.equals(some);
    }

    public static final /* synthetic */ boolean $anonfun$recordScan$12(Option check$ifrefutable$3) {
        Some some;
        Option option;
        Option option2 = check$ifrefutable$3;
        boolean bl = option2 instanceof Some && (option = (Option)(some = (Some)option2).value()) instanceof Some;
        return bl;
    }

    public static final /* synthetic */ IPFIXField $anonfun$buildScan$2(SlicingRelation $this, StructField[] requiredSchemaFields$1, int i) {
        return (IPFIXField)((Tuple2)$this.fields().apply(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.schema().fields())).indexOf((Object)requiredSchemaFields$1[i])))._2();
    }

    public SlicingRelation(Seq<Tuple2<String, IPFIXField<Object>>> fields, InfoModel infoModel, SlicingRelationConfig config, SQLContext sqlContext) {
        this.fields = fields;
        this.infoModel = infoModel;
        this.config = config;
        this.sqlContext = sqlContext;
        SlicingRelationSparkVerImpl.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.fieldMap = fields.toMap(Predef$.MODULE$.$conforms());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.schema = StructType$.MODULE$.apply((Seq)fields.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String fieldName = (String)tuple2._1();
            IPFIXField field = (IPFIXField)tuple2._2();
            StructField structField = new StructField(fieldName, field.sqlType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            return structField;
        }, Seq$.MODULE$.canBuildFrom()));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public static class LocationSize
    implements Product,
    scala.Serializable {
        private final String location;
        private final long size;

        public String location() {
            return this.location;
        }

        public long size() {
            return this.size;
        }

        public LocationSize copy(String location, long size) {
            return new LocationSize(location, size);
        }

        public String copy$default$1() {
            return this.location();
        }

        public long copy$default$2() {
            return this.size();
        }

        public String productPrefix() {
            return "LocationSize";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.location();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.size());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LocationSize;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.location()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.size()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof LocationSize)) return false;
            boolean bl = true;
            if (!bl) return false;
            LocationSize locationSize = (LocationSize)x$1;
            String string = this.location();
            String string2 = locationSize.location();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.size() != locationSize.size()) return false;
            if (!locationSize.canEqual(this)) return false;
            return true;
        }

        public LocationSize(String location, long size) {
            this.location = location;
            this.size = size;
            Product.$init$((Product)this);
        }
    }

    public static interface Slice
    extends scala.Serializable {
        public Iterator<String> locations();

        public Option<String> startAfter();

        public Option<String> finishAfter();
    }
}

