/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.datasources.ipfix;

import java.sql.Timestamp;
import java.time.Instant;
import org.cert.netsa.mothra.datasources.ipfix.Constraint;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichBoolean;

public final class Constraint$ {
    public static Constraint$ MODULE$;
    private volatile int bitmap$init$0;

    static {
        new Constraint$();
    }

    public Constraint apply(String opName, String field, Seq<String> args) {
        String string = opName;
        if ("eq".equals(string)) {
            Predef$.MODULE$.require(args.length() == 1);
            return new Constraint.EQ(field, (String)args.apply(0));
        }
        if ("lt".equals(string)) {
            Predef$.MODULE$.require(args.length() == 1);
            return new Constraint.LT(field, (String)args.apply(0));
        }
        if ("le".equals(string)) {
            Predef$.MODULE$.require(args.length() == 1);
            return new Constraint.LE(field, (String)args.apply(0));
        }
        if ("ge".equals(string)) {
            Predef$.MODULE$.require(args.length() == 1);
            return new Constraint.GE(field, (String)args.apply(0));
        }
        if ("gt".equals(string)) {
            Predef$.MODULE$.require(args.length() == 1);
            return new Constraint.GT(field, (String)args.apply(0));
        }
        if ("gt_lt".equals(string)) {
            Predef$.MODULE$.require(args.length() == 2);
            return new Constraint.GT_LT(field, (String)args.apply(0), (String)args.apply(1));
        }
        if ("ge_lt".equals(string)) {
            Predef$.MODULE$.require(args.length() == 2);
            return new Constraint.GE_LT(field, (String)args.apply(0), (String)args.apply(1));
        }
        if ("ge_le".equals(string)) {
            Predef$.MODULE$.require(args.length() == 2);
            return new Constraint.GE_LE(field, (String)args.apply(0), (String)args.apply(1));
        }
        if ("gt_le".equals(string)) {
            Predef$.MODULE$.require(args.length() == 2);
            return new Constraint.GT_LE(field, (String)args.apply(0), (String)args.apply(1));
        }
        if ("is_null".equals(string)) {
            Predef$.MODULE$.require(args.length() == 0);
            return new Constraint.IS_NULL(field);
        }
        if ("in".equals(string)) {
            Predef$.MODULE$.require(args.length() >= 1);
            return new Constraint.IN(field, args);
        }
        if ("not_in".equals(string)) {
            Predef$.MODULE$.require(args.length() >= 1);
            return new Constraint.NOT_IN(field, args);
        }
        throw new UnsupportedOperationException(new StringBuilder(33).append("Unrecognized constraint operator ").append(opName).toString());
    }

    public boolean isEQ(Object fv, String cv) {
        Object object = fv;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return bl == this.decodeBoolean(cv);
        }
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            return by == this.decodeByte(cv);
        }
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return s == this.decodeShort(cv);
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return n == this.decodeInt(cv);
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return l == this.decodeLong(cv);
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return f == this.decodeFloat(cv);
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return d == this.decodeDouble(cv);
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return timestamp.compareTo(this.decodeTimestamp(cv)) == 0;
        }
        throw new UnsupportedOperationException(new StringBuilder(38).append("Unsupported constraint value ").append(fv).append(" of type ").append(fv.getClass()).toString());
    }

    public boolean isLT(Object fv, String cv) {
        Object object = fv;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return new RichBoolean(Predef$.MODULE$.booleanWrapper(bl)).$less((Object)BoxesRunTime.boxToBoolean((boolean)this.decodeBoolean(cv)));
        }
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            return by < this.decodeByte(cv);
        }
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return s < this.decodeShort(cv);
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return n < this.decodeInt(cv);
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return l < this.decodeLong(cv);
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return f < this.decodeFloat(cv);
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return d < this.decodeDouble(cv);
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return timestamp.compareTo(this.decodeTimestamp(cv)) < 0;
        }
        throw new UnsupportedOperationException(new StringBuilder(38).append("Unsupported constraint value ").append(fv).append(" of type ").append(fv.getClass()).toString());
    }

    public boolean isLE(Object fv, String cv) {
        Object object = fv;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return new RichBoolean(Predef$.MODULE$.booleanWrapper(bl)).$less$eq((Object)BoxesRunTime.boxToBoolean((boolean)this.decodeBoolean(cv)));
        }
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            return by <= this.decodeByte(cv);
        }
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return s <= this.decodeShort(cv);
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return n <= this.decodeInt(cv);
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return l <= this.decodeLong(cv);
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return f <= this.decodeFloat(cv);
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return d <= this.decodeDouble(cv);
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return timestamp.compareTo(this.decodeTimestamp(cv)) <= 0;
        }
        throw new UnsupportedOperationException(new StringBuilder(38).append("Unsupported constraint value ").append(fv).append(" of type ").append(fv.getClass()).toString());
    }

    public boolean isGE(Object fv, String cv) {
        Object object = fv;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return new RichBoolean(Predef$.MODULE$.booleanWrapper(bl)).$greater$eq((Object)BoxesRunTime.boxToBoolean((boolean)this.decodeBoolean(cv)));
        }
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            return by >= this.decodeByte(cv);
        }
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return s >= this.decodeShort(cv);
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return n >= this.decodeInt(cv);
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return l >= this.decodeLong(cv);
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return f >= this.decodeFloat(cv);
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return d >= this.decodeDouble(cv);
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return timestamp.compareTo(this.decodeTimestamp(cv)) >= 0;
        }
        throw new UnsupportedOperationException(new StringBuilder(38).append("Unsupported constraint value ").append(fv).append(" of type ").append(fv.getClass()).toString());
    }

    public boolean isGT(Object fv, String cv) {
        Object object = fv;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return new RichBoolean(Predef$.MODULE$.booleanWrapper(bl)).$greater((Object)BoxesRunTime.boxToBoolean((boolean)this.decodeBoolean(cv)));
        }
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            return by > this.decodeByte(cv);
        }
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return s > this.decodeShort(cv);
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return n > this.decodeInt(cv);
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return l > this.decodeLong(cv);
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return f > this.decodeFloat(cv);
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return d > this.decodeDouble(cv);
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return timestamp.compareTo(this.decodeTimestamp(cv)) > 0;
        }
        throw new UnsupportedOperationException(new StringBuilder(38).append("Unsupported constraint value ").append(fv).append(" of type ").append(fv.getClass()).toString());
    }

    private boolean decodeBoolean(String cv) {
        return new StringOps(Predef$.MODULE$.augmentString(cv)).toBoolean();
    }

    private byte decodeByte(String cv) {
        return new StringOps(Predef$.MODULE$.augmentString(cv)).toByte();
    }

    private short decodeShort(String cv) {
        return new StringOps(Predef$.MODULE$.augmentString(cv)).toShort();
    }

    private int decodeInt(String cv) {
        return new StringOps(Predef$.MODULE$.augmentString(cv)).toInt();
    }

    private long decodeLong(String cv) {
        return new StringOps(Predef$.MODULE$.augmentString(cv)).toLong();
    }

    private float decodeFloat(String cv) {
        return new StringOps(Predef$.MODULE$.augmentString(cv)).toFloat();
    }

    private double decodeDouble(String cv) {
        return new StringOps(Predef$.MODULE$.augmentString(cv)).toDouble();
    }

    private Timestamp decodeTimestamp(String cv) {
        return Timestamp.from(Instant.parse(cv));
    }

    private Constraint$() {
        MODULE$ = this;
    }
}

