/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.datasources.silk.flow;

import java.time.Instant;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.Filter;
import org.cert.netsa.io.silk.FlowType;
import org.cert.netsa.io.silk.Sensor;
import org.cert.netsa.io.silk.SilkConfig;
import org.cert.netsa.mothra.datasources.silk.flow.GlobInfo;
import org.cert.netsa.mothra.datasources.silk.flow.SilkField;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001C\u0001\u0003!\u0003\r\nC\u0001\t\u0003\u0015MKGn[*pkJ\u001cWM\u0003\u0002\u0004\t\u0005!a\r\\8x\u0015\t)a!\u0001\u0003tS2\\'BA\u0004\t\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005%Q\u0011AB7pi\"\u0014\u0018M\u0003\u0002\f\u0019\u0005)a.\u001a;tC*\u0011QBD\u0001\u0005G\u0016\u0014HOC\u0001\u0010\u0003\ry'oZ\n\u0004\u0001E9\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\r\u0005\u0002\u00131%\u0011\u0011d\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u00067\u00011\t!H\u0001\u000bg&d7nQ8oM&<7\u0001A\u000b\u0002=A\u0019!cH\u0011\n\u0005\u0001\u001a\"AB(qi&|g\u000e\u0005\u0002#M5\t1E\u0003\u0002\u0006I)\u0011QEC\u0001\u0003S>L!aJ\u0012\u0003\u0015MKGn[\"p]\u001aLw\rC\u0003*\u0001\u0019\u0005!&A\u0003gS2,7\u000f\u0006\u0003,})+\u0006c\u0001\u00175o9\u0011QF\r\b\u0003]Ej\u0011a\f\u0006\u0003aq\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000b\n\u0005M\u001a\u0012a\u00029bG.\fw-Z\u0005\u0003kY\u00121aU3r\u0015\t\u00194\u0003\u0005\u00029w9\u0011!#O\u0005\u0003uM\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!h\u0005\u0005\u0006\u007f!\u0002\r\u0001Q\u0001\u000bgFd7i\u001c8uKb$\bCA!I\u001b\u0005\u0011%BA\"E\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u001a\u000bQa\u001d9be.T!a\u0012\b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tI%I\u0001\u0006T#2\u001buN\u001c;fqRDQa\u0013\u0015A\u00021\u000bqAZ5mi\u0016\u00148\u000fE\u0002\u0013\u001b>K!AT\n\u0003\u000b\u0005\u0013(/Y=\u0011\u0005A\u001bV\"A)\u000b\u0005I\u0013\u0015aB:pkJ\u001cWm]\u0005\u0003)F\u0013aAR5mi\u0016\u0014\b\"\u0002,)\u0001\u00049\u0016A\u00024jK2$7\u000fE\u0002-ia\u0003\"!\u0017.\u000e\u0003\tI!a\u0017\u0002\u0003\u0013MKGn\u001b$jK2$\u0017\u0006\u0002\u0001^\u0003_1aAX0A\u0005\tm!!\u0002$jY\u0016\u001chAB\u0001\u0003\u0011\u0003\u0011\u0001mE\u0002`#]AQAY0\u0005\u0002\r\fa\u0001P5oSRtD#\u00013\u0011\u0005e{\u0006B\u00024`A\u0013%q-A\teK\u001a\fW\u000f\u001c;SKB|7/\u001b;pef,\u0012\u0001\u001b\t\u0004%}9t\u0001\u00036`\u0003\u0003E\tAA6\u0002\u000b\u0019KG.Z:\u0011\u00051lW\"A0\u0007\u0011y{\u0016\u0011!E\u0001\u00059\u001c2!\\8\u0018!\u0015\u00018o\u000e\u0010v\u001b\u0005\t(B\u0001:\u0014\u0003\u001d\u0011XO\u001c;j[\u0016L!\u0001^9\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0002m;\")!-\u001cC\u0001oR\t1\u000eC\u0004z[\u0006\u0005IQ\t>\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u001f\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018\u0001\u00027b]\u001eT!!!\u0001\u0002\t)\fg/Y\u0005\u0003yuD\u0011\"a\u0002n\u0003\u0003%\t)!\u0003\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bU\fY!a\u0004\t\u000f\u00055\u0011Q\u0001a\u0001o\u0005!\u0001/\u0019;i\u0011\u0019Y\u0012Q\u0001a\u0001=!I\u00111C7\u0002\u0002\u0013\u0005\u0015QC\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9\"a\b\u0011\tIy\u0012\u0011\u0004\t\u0006%\u0005mqGH\u0005\u0004\u0003;\u0019\"A\u0002+va2,'\u0007C\u0005\u0002\"\u0005E\u0011\u0011!a\u0001k\u0006\u0019\u0001\u0010\n\u0019\t\u0013\u0005\u0015R.!A\u0005\n\u0005\u001d\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u000b\u0011\u0007q\fY#C\u0002\u0002.u\u0014aa\u00142kK\u000e$haBA\u0019?\u0002\u0013\u00111\u0007\u0002\u000b%\u0016\u0004xn]5u_JL8\u0003CA\u0018#\u0005U\u0012qG\f\u0011\u0005e\u0003\u0001c\u0001\n\u0002:%\u0019\u00111H\n\u0003\u000fA\u0013x\u000eZ;di\"Y\u0011qHA\u0018\u0005+\u0007I\u0011AA!\u0003)\u0011X\r]8tSR|'/_\u000b\u0002o!Q\u0011QIA\u0018\u0005#\u0005\u000b\u0011B\u001c\u0002\u0017I,\u0007o\\:ji>\u0014\u0018\u0010\t\u0005\f\u0003\u0013\nyC!f\u0001\n\u0003\tY%\u0001\bsKF,\u0018N]3e\u0007>tg-[4\u0016\u0003\u0005B!\"a\u0014\u00020\tE\t\u0015!\u0003\"\u0003=\u0011X-];je\u0016$7i\u001c8gS\u001e\u0004\u0003b\u00022\u00020\u0011\u0005\u00111\u000b\u000b\u0007\u0003+\n9&!\u0017\u0011\u00071\fy\u0003C\u0004\u0002@\u0005E\u0003\u0019A\u001c\t\u000f\u0005%\u0013\u0011\u000ba\u0001C!11$a\f\u0005BuAq!KA\u0018\t\u0003\ny\u0006F\u0004,\u0003C\n\u0019'!\u001a\t\r}\ni\u00061\u0001A\u0011\u0019Y\u0015Q\fa\u0001\u0019\"1a+!\u0018A\u0002]C!\"!\u001b\u00020\u0005\u0005I\u0011AA6\u0003\u0011\u0019w\u000e]=\u0015\r\u0005U\u0013QNA8\u0011%\ty$a\u001a\u0011\u0002\u0003\u0007q\u0007C\u0005\u0002J\u0005\u001d\u0004\u0013!a\u0001C!Q\u00111OA\u0018#\u0003%\t!!\u001e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u000f\u0016\u0004o\u0005e4FAA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u00155#\u0001\u0006b]:|G/\u0019;j_:LA!!#\u0002\u0000\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u00055\u0015qFI\u0001\n\u0003\ty)\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005E%fA\u0011\u0002z!Q\u0011QSA\u0018\u0003\u0003%\t%a&\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005Y\bBCAN\u0003_\t\t\u0011\"\u0001\u0002\u001e\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0014\t\u0004%\u0005\u0005\u0016bAAR'\t\u0019\u0011J\u001c;\t\u0015\u0005\u001d\u0016qFA\u0001\n\u0003\tI+\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005-\u0016\u0011\u0017\t\u0004%\u00055\u0016bAAX'\t\u0019\u0011I\\=\t\u0015\u0005M\u0016QUA\u0001\u0002\u0004\ty*A\u0002yIEB!\"a.\u00020\u0005\u0005I\u0011IA]\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA^!\u0019\ti,a1\u0002,6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003\u001c\u0012AC2pY2,7\r^5p]&!\u0011QYA`\u0005!IE/\u001a:bi>\u0014\bBCAe\u0003_\t\t\u0011\"\u0001\u0002L\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002N\u0006M\u0007c\u0001\n\u0002P&\u0019\u0011\u0011[\n\u0003\u000f\t{w\u000e\\3b]\"Q\u00111WAd\u0003\u0003\u0005\r!a+\t\u0015\u0005]\u0017qFA\u0001\n\u0003\nI.\u0001\u0005iCND7i\u001c3f)\t\ty\n\u0003\u0005z\u0003_\t\t\u0011\"\u0011{\u0011)\ty.a\f\u0002\u0002\u0013\u0005\u0013\u0011]\u0001\u0007KF,\u0018\r\\:\u0015\t\u00055\u00171\u001d\u0005\u000b\u0003g\u000bi.!AA\u0002\u0005-vACAt?\u0006\u0005\t\u0012\u0001\u0002\u0002j\u0006Q!+\u001a9pg&$xN]=\u0011\u00071\fYO\u0002\u0006\u00022}\u000b\t\u0011#\u0001\u0003\u0003[\u001cR!a;\u0002p^\u0001b\u0001]:8C\u0005U\u0003b\u00022\u0002l\u0012\u0005\u00111\u001f\u000b\u0003\u0003SD\u0001\"_Av\u0003\u0003%)E\u001f\u0005\u000b\u0003\u000f\tY/!A\u0005\u0002\u0006eHCBA+\u0003w\fi\u0010C\u0004\u0002@\u0005]\b\u0019A\u001c\t\u000f\u0005%\u0013q\u001fa\u0001C!Q\u00111CAv\u0003\u0003%\tI!\u0001\u0015\t\t\r!q\u0001\t\u0005%}\u0011)\u0001E\u0003\u0013\u000379\u0014\u0005\u0003\u0006\u0002\"\u0005}\u0018\u0011!a\u0001\u0003+B!\"!\n\u0002l\u0006\u0005I\u0011BA\u0014\u0011\u001d\t9a\u0018C\u0001\u0005\u001b!\"\"!\u000e\u0003\u0010\tE!1\u0003B\u000b\u0011\u0019y$1\u0002a\u0001\u0001\"9\u0011Q\u0002B\u0006\u0001\u0004A\u0007bBA \u0005\u0017\u0001\r\u0001\u001b\u0005\b\u0005/\u0011Y\u00011\u0001i\u0003)\u0019wN\u001c4jO\u001aKG.\u001a\u0005\n\u0003Ky\u0016\u0011!C\u0005\u0003O\u0019r!X\t\u00026\u0005]r\u0003\u0003\u0006\u0002\u000eu\u0013)\u001a!C\u0001\u0003\u0003B\u0011B!\t^\u0005#\u0005\u000b\u0011B\u001c\u0002\u000bA\fG\u000f\u001b\u0011\t\u0011mi&Q3A\u0005\u0002uA\u0011Ba\n^\u0005#\u0005\u000b\u0011\u0002\u0010\u0002\u0017MLGn[\"p]\u001aLw\r\t\u0005\u0007Ev#\tAa\u000b\u0015\u000bU\u0014iCa\f\t\u000f\u00055!\u0011\u0006a\u0001o!11D!\u000bA\u0002yAa!K/\u0005B\tMBcB\u0016\u00036\t]\"\u0011\b\u0005\u0007\u007f\tE\u0002\u0019\u0001!\t\r-\u0013\t\u00041\u0001M\u0011\u00191&\u0011\u0007a\u0001/\"I\u0011\u0011N/\u0002\u0002\u0013\u0005!Q\b\u000b\u0006k\n}\"\u0011\t\u0005\n\u0003\u001b\u0011Y\u0004%AA\u0002]B\u0001b\u0007B\u001e!\u0003\u0005\rA\b\u0005\n\u0003gj\u0016\u0013!C\u0001\u0003kB\u0011\"!$^#\u0003%\tAa\u0012\u0016\u0005\t%#f\u0001\u0010\u0002z!I\u0011QS/\u0002\u0002\u0013\u0005\u0013q\u0013\u0005\n\u00037k\u0016\u0011!C\u0001\u0003;C\u0011\"a*^\u0003\u0003%\tA!\u0015\u0015\t\u0005-&1\u000b\u0005\u000b\u0003g\u0013y%!AA\u0002\u0005}\u0005\"CA\\;\u0006\u0005I\u0011IA]\u0011%\tI-XA\u0001\n\u0003\u0011I\u0006\u0006\u0003\u0002N\nm\u0003BCAZ\u0005/\n\t\u00111\u0001\u0002,\"I\u0011q[/\u0002\u0002\u0013\u0005\u0013\u0011\u001c\u0005\bsv\u000b\t\u0011\"\u0011{\u0011%\ty.XA\u0001\n\u0003\u0012\u0019\u0007\u0006\u0003\u0002N\n\u0015\u0004BCAZ\u0005C\n\t\u00111\u0001\u0002,\u001e9!\u0011\u000e\u0002\t\u0002\t!\u0017AC*jY.\u001cv.\u001e:dK\u0002")
public interface SilkSource
extends Serializable {
    public Option<SilkConfig> silkConfig();

    public Seq<String> files(SQLContext var1, Filter[] var2, Seq<SilkField> var3);

    public static class Files
    implements SilkSource,
    Product {
        private final String path;
        private final Option<SilkConfig> silkConfig;

        public String path() {
            return this.path;
        }

        @Override
        public Option<SilkConfig> silkConfig() {
            return this.silkConfig;
        }

        @Override
        public Seq<String> files(SQLContext sqlContext, Filter[] filters, Seq<SilkField> fields) {
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.path()}));
        }

        public Files copy(String path, Option<SilkConfig> silkConfig) {
            return new Files(path, silkConfig);
        }

        public String copy$default$1() {
            return this.path();
        }

        public Option<SilkConfig> copy$default$2() {
            return this.silkConfig();
        }

        public String productPrefix() {
            return "Files";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.silkConfig();
                    break;
                }
                case 0: {
                    object = this.path();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Files;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Files)) return false;
            boolean bl = true;
            if (!bl) return false;
            Files files2 = (Files)x$1;
            String string = this.path();
            String string2 = files2.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<SilkConfig> option = this.silkConfig();
            Option<SilkConfig> option2 = files2.silkConfig();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!files2.canEqual(this)) return false;
            return true;
        }

        public Files(String path, Option<SilkConfig> silkConfig) {
            this.path = path;
            this.silkConfig = silkConfig;
            Product.class.$init$((Product)this);
        }
    }

    public static class Repository
    implements SilkSource,
    Product {
        private final String repository;
        private final SilkConfig requiredConfig;

        public String repository() {
            return this.repository;
        }

        public SilkConfig requiredConfig() {
            return this.requiredConfig;
        }

        @Override
        public Option<SilkConfig> silkConfig() {
            return new Some((Object)this.requiredConfig());
        }

        @Override
        public Seq<String> files(SQLContext sqlContext, Filter[] filters, Seq<SilkField> fields) {
            FileSystem fs = new Path(this.repository()).getFileSystem(sqlContext.sparkContext().hadoopConfiguration());
            Path candidatePath = new Path(this.repository(), this.requiredConfig().globAll());
            Map fieldMap = ((TraversableOnce)fields.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, SilkField> apply(SilkField f) {
                    return new Tuple2((Object)f.name(), (Object)f);
                }
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            PathFilter pathFilter = new PathFilter(this, filters, fieldMap){
                private final /* synthetic */ Repository $outer;
                private final Filter[] filters$1;
                private final Map fieldMap$1;

                public boolean accept(Path p) {
                    Option option;
                    block4: {
                        boolean bl;
                        block3: {
                            Some some;
                            Tuple3 tuple3;
                            block2: {
                                option = this.$outer.requiredConfig().filenameToGlobInfo(p.getName());
                                if (!None$.MODULE$.equals(option)) break block2;
                                bl = false;
                                break block3;
                            }
                            if (!(option instanceof Some) || (tuple3 = (Tuple3)(some = (Some)option).x()) == null) break block4;
                            Instant hour = (Instant)tuple3._1();
                            byte flowTypeId = ((FlowType)tuple3._2()).toByte();
                            short sensorId = ((Sensor)tuple3._3()).toShort();
                            bl = new GlobInfo((Map<String, SilkField>)this.fieldMap$1, this.$outer.requiredConfig(), hour, flowTypeId, sensorId, p.toString()).checkFilters((Seq<Filter>)Predef$.MODULE$.wrapRefArray((Object[])this.filters$1));
                        }
                        return bl;
                    }
                    throw new MatchError((Object)option);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.filters$1 = filters$1;
                    this.fieldMap$1 = fieldMap$1;
                }
            };
            FileStatus[] fileStatuses = fs.globStatus(candidatePath, pathFilter);
            return (Seq)Predef$.MODULE$.refArrayOps((Object[])fileStatuses).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(FileStatus x$1) {
                    return x$1.getPath().toString();
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }

        public Repository copy(String repository, SilkConfig requiredConfig) {
            return new Repository(repository, requiredConfig);
        }

        public String copy$default$1() {
            return this.repository();
        }

        public SilkConfig copy$default$2() {
            return this.requiredConfig();
        }

        public String productPrefix() {
            return "Repository";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.requiredConfig();
                    break;
                }
                case 0: {
                    object = this.repository();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Repository;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Repository)) return false;
            boolean bl = true;
            if (!bl) return false;
            Repository repository = (Repository)x$1;
            String string = this.repository();
            String string2 = repository.repository();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            SilkConfig silkConfig = this.requiredConfig();
            SilkConfig silkConfig2 = repository.requiredConfig();
            if (silkConfig == null) {
                if (silkConfig2 != null) {
                    return false;
                }
            } else if (!silkConfig.equals(silkConfig2)) return false;
            if (!repository.canEqual(this)) return false;
            return true;
        }

        public Repository(String repository, SilkConfig requiredConfig) {
            this.repository = repository;
            this.requiredConfig = requiredConfig;
            Product.class.$init$((Product)this);
        }
    }
}

