/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.datasources.silk.flow;

import java.io.Serializable;
import java.time.Instant;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.Filter;
import org.cert.netsa.io.silk.FlowType;
import org.cert.netsa.io.silk.Sensor;
import org.cert.netsa.io.silk.SilkConfig;
import org.cert.netsa.mothra.datasources.silk.flow.GlobInfo;
import org.cert.netsa.mothra.datasources.silk.flow.SilkField;
import org.cert.netsa.mothra.datasources.silk.flow.SilkSource$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t\re\u0001\u0003 @!\u0003\r\ncP'\t\u000b\u0005\u0004a\u0011\u00012\t\u000b5\u0004a\u0011\u00018\b\u0011\t\u0005u\b#\u0001@\u0003\u000f2qAP \t\u0002}\n)\u0004C\u0004\u0002D\u0011!\t!!\u0012\t\u0011\u0005%C\u0001)C\u0005\u0003\u00172q!a\r\u0005\u0001~\u0012\u0019\u0006\u0003\u0006\u0002|\u001d\u0011)\u001a!C\u0001\u0003OC\u0011B!\u0016\b\u0005#\u0005\u000b\u0011\u0002:\t\u0011\u0005<!Q3A\u0005\u0002\tD\u0011Ba\u0016\b\u0005#\u0005\u000b\u0011B2\t\u000f\u0005\rs\u0001\"\u0001\u0003Z!1Qn\u0002C!\u0005?B\u0011\"!1\b\u0003\u0003%\tAa\u001a\t\u0013\u0005%w!%A\u0005\u0002\u0005-\u0007\"CAq\u000fE\u0005I\u0011\u0001B7\u0011%\t9oBA\u0001\n\u0003\nI\u000fC\u0005\u0002l\u001e\t\t\u0011\"\u0001\u0002n\"I\u0011Q_\u0004\u0002\u0002\u0013\u0005!\u0011\u000f\u0005\n\u0005\u00079\u0011\u0011!C!\u0005\u000bA\u0011Ba\u0005\b\u0003\u0003%\tA!\u001e\t\u0013\t}q!!A\u0005B\te\u0004\"\u0003B\u0013\u000f\u0005\u0005I\u0011\tB\u0014\u0011%\t9gBA\u0001\n\u0003\nI\u0007C\u0005\u0003*\u001d\t\t\u0011\"\u0011\u0003~\u001dQ\u0011q\n\u0003\u0002\u0002#\u0005q(!\u0015\u0007\u0015\u0005MB!!A\t\u0002}\n)\u0006C\u0004\u0002Dm!\t!!\u001a\t\u0013\u0005\u001d4$!A\u0005F\u0005%\u0004\"CA;7\u0005\u0005I\u0011QA<\u0011%\tyhGA\u0001\n\u0003\u000b\t\tC\u0005\u0002\u0010n\t\t\u0011\"\u0003\u0002\u0012\u001a9\u0011\u0011\u0014\u0003A\u007f\u0005m\u0005BCASC\tU\r\u0011\"\u0001\u0002(\"I\u0011\u0011V\u0011\u0003\u0012\u0003\u0006IA\u001d\u0005\u000b\u0003W\u000b#Q3A\u0005\u0002\u00055\u0006\"CAXC\tE\t\u0015!\u0003g\u0011\u001d\t\u0019%\tC\u0001\u0003cCQ!Y\u0011\u0005B\tDa!\\\u0011\u0005B\u0005e\u0006\"CAaC\u0005\u0005I\u0011AAb\u0011%\tI-II\u0001\n\u0003\tY\rC\u0005\u0002b\u0006\n\n\u0011\"\u0001\u0002d\"I\u0011q]\u0011\u0002\u0002\u0013\u0005\u0013\u0011\u001e\u0005\n\u0003W\f\u0013\u0011!C\u0001\u0003[D\u0011\"!>\"\u0003\u0003%\t!a>\t\u0013\t\r\u0011%!A\u0005B\t\u0015\u0001\"\u0003B\nC\u0005\u0005I\u0011\u0001B\u000b\u0011%\u0011y\"IA\u0001\n\u0003\u0012\t\u0003C\u0005\u0003&\u0005\n\t\u0011\"\u0011\u0003(!I\u0011qM\u0011\u0002\u0002\u0013\u0005\u0013\u0011\u000e\u0005\n\u0005S\t\u0013\u0011!C!\u0005W9!Ba\f\u0005\u0003\u0003E\ta\u0010B\u0019\r)\tI\nBA\u0001\u0012\u0003y$1\u0007\u0005\b\u0003\u00072D\u0011\u0001B\u001c\u0011%\t9GNA\u0001\n\u000b\nI\u0007C\u0005\u0002vY\n\t\u0011\"!\u0003:!I\u0011q\u0010\u001c\u0002\u0002\u0013\u0005%q\b\u0005\n\u0003\u001f3\u0014\u0011!C\u0005\u0003#Cq!!\u001e\u0005\t\u0003\u00119\u0005C\u0005\u0002\u0010\u0012\t\t\u0011\"\u0003\u0002\u0012\nQ1+\u001b7l'>,(oY3\u000b\u0005\u0001\u000b\u0015\u0001\u00024m_^T!AQ\"\u0002\tMLGn\u001b\u0006\u0003\t\u0016\u000b1\u0002Z1uCN|WO]2fg*\u0011aiR\u0001\u0007[>$\bN]1\u000b\u0005!K\u0015!\u00028fiN\f'B\u0001&L\u0003\u0011\u0019WM\u001d;\u000b\u00031\u000b1a\u001c:h'\r\u0001a\n\u0016\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0002#\u0006)1oY1mC&\u00111\u000b\u0015\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UsfB\u0001,]\u001d\t96,D\u0001Y\u0015\tI&,\u0001\u0004=e>|GOP\u0002\u0001\u0013\u0005\t\u0016BA/Q\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00181\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005u\u0003\u0016AC:jY.\u001cuN\u001c4jOV\t1\rE\u0002PI\u001aL!!\u001a)\u0003\r=\u0003H/[8o!\t97.D\u0001i\u0015\t\u0011\u0015N\u0003\u0002k\u000f\u0006\u0011\u0011n\\\u0005\u0003Y\"\u0014!bU5mW\u000e{gNZ5h\u0003\u00151\u0017\u000e\\3t)\u0019y'0!\u0004\u0002$A\u0019Q\u000b\u001d:\n\u0005E\u0004'aA*fcB\u00111o\u001e\b\u0003iV\u0004\"a\u0016)\n\u0005Y\u0004\u0016A\u0002)sK\u0012,g-\u0003\u0002ys\n11\u000b\u001e:j]\u001eT!A\u001e)\t\u000bm\u0014\u0001\u0019\u0001?\u0002\u0015M\fHnQ8oi\u0016DH\u000fE\u0002~\u0003\u0013i\u0011A \u0006\u0004\u007f\u0006\u0005\u0011aA:rY*!\u00111AA\u0003\u0003\u0015\u0019\b/\u0019:l\u0015\r\t9aS\u0001\u0007CB\f7\r[3\n\u0007\u0005-aP\u0001\u0006T#2\u001buN\u001c;fqRDq!a\u0004\u0003\u0001\u0004\t\t\"A\u0004gS2$XM]:\u0011\u000b=\u000b\u0019\"a\u0006\n\u0007\u0005U\u0001KA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\tiB`\u0001\bg>,(oY3t\u0013\u0011\t\t#a\u0007\u0003\r\u0019KG\u000e^3s\u0011\u001d\t)C\u0001a\u0001\u0003O\taAZ5fY\u0012\u001c\b\u0003B+q\u0003S\u0001B!a\u000b\u0002.5\tq(C\u0002\u00020}\u0012\u0011bU5mW\u001aKW\r\u001c3*\u0007\u00019\u0011EA\u0003GS2,7o\u0005\u0003\u0005\u001d\u0006]\u0002\u0003BA\u001d\u0003\u0003j!!a\u000f\u000b\u0007)\fiD\u0003\u0002\u0002@\u0005!!.\u0019<b\u0013\ry\u00161H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u001d\u0003cAA\u0016\t\u0005\tB-\u001a4bk2$(+\u001a9pg&$xN]=\u0016\u0005\u00055\u0003cA(ee\u0006)a)\u001b7fgB\u0019\u00111K\u000e\u000e\u0003\u0011\u0019RaGA,\u0003o\u0001\u0002\"!\u0017\u0002`I\u001c\u00171M\u0007\u0003\u00037R1!!\u0018Q\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\u0019\u0002\\\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\u0007\u0005Ms\u0001\u0006\u0002\u0002R\u0005AAo\\*ue&tw\r\u0006\u0002\u0002lA!\u0011QNA:\u001b\t\tyG\u0003\u0003\u0002r\u0005u\u0012\u0001\u00027b]\u001eL1\u0001_A8\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\t\u0019'!\u001f\u0002~!1\u00111\u0010\u0010A\u0002I\fA\u0001]1uQ\")\u0011M\ba\u0001G\u00069QO\\1qa2LH\u0003BAB\u0003\u0017\u0003Ba\u00143\u0002\u0006B)q*a\"sG&\u0019\u0011\u0011\u0012)\u0003\rQ+\b\u000f\\33\u0011%\tiiHA\u0001\u0002\u0004\t\u0019'A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a%\u0011\t\u00055\u0014QS\u0005\u0005\u0003/\u000byG\u0001\u0004PE*,7\r\u001e\u0002\u000b%\u0016\u0004xn]5u_JL8cB\u0011O\u0003;\u000by\n\u0016\t\u0004\u0003W\u0001\u0001cA(\u0002\"&\u0019\u00111\u0015)\u0003\u000fA\u0013x\u000eZ;di\u0006Q!/\u001a9pg&$xN]=\u0016\u0003I\f1B]3q_NLGo\u001c:zA\u0005q!/Z9vSJ,GmQ8oM&<W#\u00014\u0002\u001fI,\u0017/^5sK\u0012\u001cuN\u001c4jO\u0002\"b!a-\u00026\u0006]\u0006cAA*C!1\u0011Q\u0015\u0014A\u0002IDa!a+'\u0001\u00041GcB8\u0002<\u0006u\u0016q\u0018\u0005\u0006w\"\u0002\r\u0001 \u0005\b\u0003\u001fA\u0003\u0019AA\t\u0011\u001d\t)\u0003\u000ba\u0001\u0003O\tAaY8qsR1\u00111WAc\u0003\u000fD\u0001\"!**!\u0003\u0005\rA\u001d\u0005\t\u0003WK\u0003\u0013!a\u0001M\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAgU\r\u0011\u0018qZ\u0016\u0003\u0003#\u0004B!a5\u0002^6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fI.A\u0005v]\u000eDWmY6fI*\u0019\u00111\u001c)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002`\u0006U'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAsU\r1\u0017qZ\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAAx!\ry\u0015\u0011_\u0005\u0004\u0003g\u0004&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA}\u0003\u007f\u00042aTA~\u0013\r\ti\u0010\u0015\u0002\u0004\u0003:L\b\"\u0003B\u0001]\u0005\u0005\t\u0019AAx\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0001\t\u0007\u0005\u0013\u0011y!!?\u000e\u0005\t-!b\u0001B\u0007!\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tE!1\u0002\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0018\tu\u0001cA(\u0003\u001a%\u0019!1\u0004)\u0003\u000f\t{w\u000e\\3b]\"I!\u0011\u0001\u0019\u0002\u0002\u0003\u0007\u0011\u0011`\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002l\t\r\u0002\"\u0003B\u0001c\u0005\u0005\t\u0019AAx\u0003!A\u0017m\u001d5D_\u0012,GCAAx\u0003\u0019)\u0017/^1mgR!!q\u0003B\u0017\u0011%\u0011\t\u0001NA\u0001\u0002\u0004\tI0\u0001\u0006SKB|7/\u001b;pef\u00042!a\u00157'\u00151$QGA\u001c!!\tI&a\u0018sM\u0006MFC\u0001B\u0019)\u0019\t\u0019La\u000f\u0003>!1\u0011QU\u001dA\u0002IDa!a+:\u0001\u00041G\u0003\u0002B!\u0005\u000b\u0002Ba\u00143\u0003DA)q*a\"sM\"I\u0011Q\u0012\u001e\u0002\u0002\u0003\u0007\u00111\u0017\u000b\u000b\u0003;\u0013IEa\u0013\u0003N\t=\u0003\"B>=\u0001\u0004a\bbBA>y\u0001\u0007\u0011Q\n\u0005\b\u0003Kc\u0004\u0019AA'\u0011\u001d\u0011\t\u0006\u0010a\u0001\u0003\u001b\n!bY8oM&<g)\u001b7f'\u001d9a*!(\u0002 R\u000bQ\u0001]1uQ\u0002\n1b]5mW\u000e{gNZ5hAQ1\u00111\rB.\u0005;Ba!a\u001f\r\u0001\u0004\u0011\b\"B1\r\u0001\u0004\u0019GcB8\u0003b\t\r$Q\r\u0005\u0006w6\u0001\r\u0001 \u0005\b\u0003\u001fi\u0001\u0019AA\t\u0011\u001d\t)#\u0004a\u0001\u0003O!b!a\u0019\u0003j\t-\u0004\u0002CA>\u001dA\u0005\t\u0019\u0001:\t\u000f\u0005t\u0001\u0013!a\u0001GV\u0011!q\u000e\u0016\u0004G\u0006=G\u0003BA}\u0005gB\u0011B!\u0001\u0014\u0003\u0003\u0005\r!a<\u0015\t\t]!q\u000f\u0005\n\u0005\u0003)\u0012\u0011!a\u0001\u0003s$B!a\u001b\u0003|!I!\u0011\u0001\f\u0002\u0002\u0003\u0007\u0011q\u001e\u000b\u0005\u0005/\u0011y\bC\u0005\u0003\u0002e\t\t\u00111\u0001\u0002z\u0006Q1+\u001b7l'>,(oY3")
public interface SilkSource
extends Serializable {
    public static SilkSource apply(SQLContext sqlContext, Option<String> path, Option<String> repository, Option<String> configFile) {
        return SilkSource$.MODULE$.apply(sqlContext, path, repository, configFile);
    }

    public Option<SilkConfig> silkConfig();

    public Seq<String> files(SQLContext var1, Filter[] var2, Seq<SilkField> var3);

    public static class Files
    implements SilkSource,
    Product {
        private final String path;
        private final Option<SilkConfig> silkConfig;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String path() {
            return this.path;
        }

        @Override
        public Option<SilkConfig> silkConfig() {
            return this.silkConfig;
        }

        @Override
        public Seq<String> files(SQLContext sqlContext, Filter[] filters, Seq<SilkField> fields) {
            return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.path()}));
        }

        public Files copy(String path, Option<SilkConfig> silkConfig) {
            return new Files(path, silkConfig);
        }

        public String copy$default$1() {
            return this.path();
        }

        public Option<SilkConfig> copy$default$2() {
            return this.silkConfig();
        }

        public String productPrefix() {
            return "Files";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.path();
                    break;
                }
                case 1: {
                    object = this.silkConfig();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Files;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "path";
                    break;
                }
                case 1: {
                    string = "silkConfig";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Files)) return false;
            boolean bl = true;
            if (!bl) return false;
            Files files = (Files)x$1;
            String string = this.path();
            String string2 = files.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<SilkConfig> option = this.silkConfig();
            Option<SilkConfig> option2 = files.silkConfig();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!files.canEqual(this)) return false;
            return true;
        }

        public Files(String path, Option<SilkConfig> silkConfig) {
            this.path = path;
            this.silkConfig = silkConfig;
            Product.$init$((Product)this);
        }
    }

    public static class Repository
    implements SilkSource,
    Product {
        private final String repository;
        private final SilkConfig requiredConfig;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String repository() {
            return this.repository;
        }

        public SilkConfig requiredConfig() {
            return this.requiredConfig;
        }

        @Override
        public Option<SilkConfig> silkConfig() {
            return new Some((Object)this.requiredConfig());
        }

        @Override
        public Seq<String> files(SQLContext sqlContext, Filter[] filters, Seq<SilkField> fields) {
            FileSystem fs = new Path(this.repository()).getFileSystem(sqlContext.sparkContext().hadoopConfiguration());
            Path candidatePath = new Path(this.repository(), this.requiredConfig().globAll());
            Map fieldMap = ((IterableOnceOps)fields.map((Function1 & Serializable)f -> new Tuple2((Object)f.name(), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            PathFilter pathFilter = new PathFilter(this, fieldMap, filters){
                private final /* synthetic */ Repository $outer;
                private final Map fieldMap$1;
                private final Filter[] filters$1;

                public boolean accept(Path p) {
                    Some some;
                    Tuple3 tuple3;
                    boolean bl;
                    Option option = this.$outer.requiredConfig().filenameToGlobInfo(p.getName());
                    if (None$.MODULE$.equals(option)) {
                        bl = false;
                    } else if (option instanceof Some && (tuple3 = (Tuple3)(some = (Some)option).value()) != null) {
                        Instant hour = (Instant)tuple3._1();
                        byte flowTypeId = ((FlowType)tuple3._2()).toByte();
                        short sensorId = ((Sensor)tuple3._3()).toShort();
                        bl = new GlobInfo((Map<String, SilkField>)this.fieldMap$1, this.$outer.requiredConfig(), hour, flowTypeId, sensorId, p.toString()).checkFilters((Seq<Filter>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])this.filters$1)));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fieldMap$1 = fieldMap$1;
                    this.filters$1 = filters$1;
                }
            };
            Seq fileStatuses = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])fs.globStatus(candidatePath, pathFilter)));
            return (Seq)fileStatuses.map((Function1 & Serializable)x$1 -> x$1.getPath().toString());
        }

        public Repository copy(String repository, SilkConfig requiredConfig) {
            return new Repository(repository, requiredConfig);
        }

        public String copy$default$1() {
            return this.repository();
        }

        public SilkConfig copy$default$2() {
            return this.requiredConfig();
        }

        public String productPrefix() {
            return "Repository";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.repository();
                    break;
                }
                case 1: {
                    object = this.requiredConfig();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Repository;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "repository";
                    break;
                }
                case 1: {
                    string = "requiredConfig";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Repository)) return false;
            boolean bl = true;
            if (!bl) return false;
            Repository repository = (Repository)x$1;
            String string = this.repository();
            String string2 = repository.repository();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            SilkConfig silkConfig = this.requiredConfig();
            SilkConfig silkConfig2 = repository.requiredConfig();
            if (silkConfig == null) {
                if (silkConfig2 != null) {
                    return false;
                }
            } else if (!silkConfig.equals(silkConfig2)) return false;
            if (!repository.canEqual(this)) return false;
            return true;
        }

        public Repository(String repository, SilkConfig requiredConfig) {
            this.repository = repository;
            this.requiredConfig = requiredConfig;
            Product.$init$((Product)this);
        }
    }
}

