/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.datasources.silk.flow;

import java.io.Serializable;
import java.time.Instant;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.Filter;
import org.cert.netsa.io.silk.FlowType;
import org.cert.netsa.io.silk.Sensor;
import org.cert.netsa.io.silk.SilkConfig;
import org.cert.netsa.mothra.datasources.silk.flow.GlobInfo;
import org.cert.netsa.mothra.datasources.silk.flow.SilkField;
import org.cert.netsa.mothra.datasources.silk.flow.SilkSource$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t\re\u0001\u0003 @!\u0003\r\ncP'\t\u000b\u0005\u0004a\u0011\u00012\t\u000b5\u0004a\u0011\u00018\b\u0011\t\u0005u\b#\u0001@\u0003\u000f2qAP \t\u0002}\n)\u0004C\u0004\u0002D\u0011!\t!!\u0012\t\u000f\u0005%C\u0001\"\u0003\u0002L\u00199\u00111\u0007\u0003A\u007f\tM\u0003BCA>\u000f\tU\r\u0011\"\u0001\u0002(\"I!QK\u0004\u0003\u0012\u0003\u0006IA\u001d\u0005\tC\u001e\u0011)\u001a!C\u0001E\"I!qK\u0004\u0003\u0012\u0003\u0006Ia\u0019\u0005\b\u0003\u0007:A\u0011\u0001B-\u0011\u0019iw\u0001\"\u0011\u0003`!I\u0011\u0011Y\u0004\u0002\u0002\u0013\u0005!q\r\u0005\n\u0003\u0013<\u0011\u0013!C\u0001\u0003\u0017D\u0011\"!9\b#\u0003%\tA!\u001c\t\u0013\u0005\u001dx!!A\u0005B\u0005%\b\"CAv\u000f\u0005\u0005I\u0011AAw\u0011%\t)pBA\u0001\n\u0003\u0011\t\bC\u0005\u0003\u0004\u001d\t\t\u0011\"\u0011\u0003\u0006!I!1C\u0004\u0002\u0002\u0013\u0005!Q\u000f\u0005\n\u0005?9\u0011\u0011!C!\u0005sB\u0011B!\n\b\u0003\u0003%\tEa\n\t\u0013\u0005\u001dt!!A\u0005B\u0005%\u0004\"\u0003B\u0015\u000f\u0005\u0005I\u0011\tB?\u000f)\ty\u0005BA\u0001\u0012\u0003y\u0014\u0011\u000b\u0004\u000b\u0003g!\u0011\u0011!E\u0001\u007f\u0005U\u0003bBA\"7\u0011\u0005\u0011Q\r\u0005\n\u0003OZ\u0012\u0011!C#\u0003SB\u0011\"!\u001e\u001c\u0003\u0003%\t)a\u001e\t\u0013\u0005}4$!A\u0005\u0002\u0006\u0005\u0005\"CAH7\u0005\u0005I\u0011BAI\r\u001d\tI\n\u0002!@\u00037C!\"!*\"\u0005+\u0007I\u0011AAT\u0011%\tI+\tB\tB\u0003%!\u000f\u0003\u0006\u0002,\u0006\u0012)\u001a!C\u0001\u0003[C\u0011\"a,\"\u0005#\u0005\u000b\u0011\u00024\t\u000f\u0005\r\u0013\u0005\"\u0001\u00022\")\u0011-\tC!E\"1Q.\tC!\u0003sC\u0011\"!1\"\u0003\u0003%\t!a1\t\u0013\u0005%\u0017%%A\u0005\u0002\u0005-\u0007\"CAqCE\u0005I\u0011AAr\u0011%\t9/IA\u0001\n\u0003\nI\u000fC\u0005\u0002l\u0006\n\t\u0011\"\u0001\u0002n\"I\u0011Q_\u0011\u0002\u0002\u0013\u0005\u0011q\u001f\u0005\n\u0005\u0007\t\u0013\u0011!C!\u0005\u000bA\u0011Ba\u0005\"\u0003\u0003%\tA!\u0006\t\u0013\t}\u0011%!A\u0005B\t\u0005\u0002\"\u0003B\u0013C\u0005\u0005I\u0011\tB\u0014\u0011%\t9'IA\u0001\n\u0003\nI\u0007C\u0005\u0003*\u0005\n\t\u0011\"\u0011\u0003,\u001dQ!q\u0006\u0003\u0002\u0002#\u0005qH!\r\u0007\u0015\u0005eE!!A\t\u0002}\u0012\u0019\u0004C\u0004\u0002DY\"\tAa\u000e\t\u0013\u0005\u001dd'!A\u0005F\u0005%\u0004\"CA;m\u0005\u0005I\u0011\u0011B\u001d\u0011%\tyHNA\u0001\n\u0003\u0013y\u0004C\u0005\u0002\u0010Z\n\t\u0011\"\u0003\u0002\u0012\"9\u0011Q\u000f\u0003\u0005\u0002\t\u001d\u0003\"CAH\t\u0005\u0005I\u0011BAI\u0005)\u0019\u0016\u000e\\6T_V\u00148-\u001a\u0006\u0003\u0001\u0006\u000bAA\u001a7po*\u0011!iQ\u0001\u0005g&d7N\u0003\u0002E\u000b\u0006YA-\u0019;bg>,(oY3t\u0015\t1u)\u0001\u0004n_RD'/\u0019\u0006\u0003\u0011&\u000bQA\\3ug\u0006T!AS&\u0002\t\r,'\u000f\u001e\u0006\u0002\u0019\u0006\u0019qN]4\u0014\u0007\u0001qE\u000b\u0005\u0002P%6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006K\u0001\u0004B]f\u0014VM\u001a\t\u0003+zs!A\u0016/\u000f\u0005][V\"\u0001-\u000b\u0005eS\u0016A\u0002\u001fs_>$hh\u0001\u0001\n\u0003EK!!\u0018)\u0002\u000fA\f7m[1hK&\u0011q\f\u0019\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003;B\u000b!b]5mW\u000e{gNZ5h+\u0005\u0019\u0007cA(eM&\u0011Q\r\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u001d\\W\"\u00015\u000b\u0005\tK'B\u00016H\u0003\tIw.\u0003\u0002mQ\nQ1+\u001b7l\u0007>tg-[4\u0002\u000b\u0019LG.Z:\u0015\r=T\u0018QBA\u0012!\r)\u0006O]\u0005\u0003c\u0002\u00141aU3r!\t\u0019xO\u0004\u0002ukB\u0011q\u000bU\u0005\u0003mB\u000ba\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\u0019\u0019FO]5oO*\u0011a\u000f\u0015\u0005\u0006w\n\u0001\r\u0001`\u0001\u000bgFd7i\u001c8uKb$\bcA?\u0002\n5\taPC\u0002\u0000\u0003\u0003\t1a]9m\u0015\u0011\t\u0019!!\u0002\u0002\u000bM\u0004\u0018M]6\u000b\u0007\u0005\u001d1*\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0004\u0003\u0017q(AC*R\u0019\u000e{g\u000e^3yi\"9\u0011q\u0002\u0002A\u0002\u0005E\u0011a\u00024jYR,'o\u001d\t\u0006\u001f\u0006M\u0011qC\u0005\u0004\u0003+\u0001&!B!se\u0006L\b\u0003BA\r\u0003?i!!a\u0007\u000b\u0007\u0005ua0A\u0004t_V\u00148-Z:\n\t\u0005\u0005\u00121\u0004\u0002\u0007\r&dG/\u001a:\t\u000f\u0005\u0015\"\u00011\u0001\u0002(\u00051a-[3mIN\u0004B!\u00169\u0002*A!\u00111FA\u0017\u001b\u0005y\u0014bAA\u0018\u007f\tI1+\u001b7l\r&,G\u000eZ\u0015\u0004\u0001\u001d\t#!\u0002$jY\u0016\u001c8\u0003\u0002\u0003O\u0003o\u0001B!!\u000f\u0002B5\u0011\u00111\b\u0006\u0004U\u0006u\"BAA \u0003\u0011Q\u0017M^1\n\u0007}\u000bY$\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003\u000f\u00022!a\u000b\u0005\u0003E!WMZ1vYR\u0014V\r]8tSR|'/_\u000b\u0003\u0003\u001b\u00022a\u00143s\u0003\u00151\u0015\u000e\\3t!\r\t\u0019fG\u0007\u0002\tM)1$a\u0016\u00028AA\u0011\u0011LA0e\u000e\f\u0019'\u0004\u0002\u0002\\)\u0019\u0011Q\f)\u0002\u000fI,h\u000e^5nK&!\u0011\u0011MA.\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0004\u0003':ACAA)\u0003!!xn\u0015;sS:<GCAA6!\u0011\ti'a\u001d\u000e\u0005\u0005=$\u0002BA9\u0003{\tA\u0001\\1oO&\u0019\u00010a\u001c\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005\r\u0014\u0011PA?\u0011\u0019\tYH\ba\u0001e\u0006!\u0001/\u0019;i\u0011\u0015\tg\u00041\u0001d\u0003\u001d)h.\u00199qYf$B!a!\u0002\fB!q\nZAC!\u0015y\u0015q\u0011:d\u0013\r\tI\t\u0015\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u00055u$!AA\u0002\u0005\r\u0014a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u00111\u0013\t\u0005\u0003[\n)*\u0003\u0003\u0002\u0018\u0006=$AB(cU\u0016\u001cGO\u0001\u0006SKB|7/\u001b;pef\u001cr!\t(\u0002\u001e\u0006}E\u000bE\u0002\u0002,\u0001\u00012aTAQ\u0013\r\t\u0019\u000b\u0015\u0002\b!J|G-^2u\u0003)\u0011X\r]8tSR|'/_\u000b\u0002e\u0006Y!/\u001a9pg&$xN]=!\u00039\u0011X-];je\u0016$7i\u001c8gS\u001e,\u0012AZ\u0001\u0010e\u0016\fX/\u001b:fI\u000e{gNZ5hAQ1\u00111WA[\u0003o\u00032!a\u0015\"\u0011\u0019\t)K\na\u0001e\"1\u00111\u0016\u0014A\u0002\u0019$ra\\A^\u0003{\u000by\fC\u0003|Q\u0001\u0007A\u0010C\u0004\u0002\u0010!\u0002\r!!\u0005\t\u000f\u0005\u0015\u0002\u00061\u0001\u0002(\u0005!1m\u001c9z)\u0019\t\u0019,!2\u0002H\"A\u0011QU\u0015\u0011\u0002\u0003\u0007!\u000f\u0003\u0005\u0002,&\u0002\n\u00111\u0001g\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!4+\u0007I\fym\u000b\u0002\u0002RB!\u00111[Ao\u001b\t\t)N\u0003\u0003\u0002X\u0006e\u0017!C;oG\",7m[3e\u0015\r\tY\u000eU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAp\u0003+\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!:+\u0007\u0019\fy-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003W\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a<\u0011\u0007=\u000b\t0C\u0002\u0002tB\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!?\u0002\u0000B\u0019q*a?\n\u0007\u0005u\bKA\u0002B]fD\u0011B!\u0001/\u0003\u0003\u0005\r!a<\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00119\u0001\u0005\u0004\u0003\n\t=\u0011\u0011`\u0007\u0003\u0005\u0017Q1A!\u0004Q\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005#\u0011YA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\f\u0005;\u00012a\u0014B\r\u0013\r\u0011Y\u0002\u0015\u0002\b\u0005>|G.Z1o\u0011%\u0011\t\u0001MA\u0001\u0002\u0004\tI0\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA6\u0005GA\u0011B!\u00012\u0003\u0003\u0005\r!a<\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a<\u0002\r\u0015\fX/\u00197t)\u0011\u00119B!\f\t\u0013\t\u0005A'!AA\u0002\u0005e\u0018A\u0003*fa>\u001c\u0018\u000e^8ssB\u0019\u00111\u000b\u001c\u0014\u000bY\u0012)$a\u000e\u0011\u0011\u0005e\u0013q\f:g\u0003g#\"A!\r\u0015\r\u0005M&1\bB\u001f\u0011\u0019\t)+\u000fa\u0001e\"1\u00111V\u001dA\u0002\u0019$BA!\u0011\u0003FA!q\n\u001aB\"!\u0015y\u0015q\u0011:g\u0011%\tiIOA\u0001\u0002\u0004\t\u0019\f\u0006\u0006\u0002\u001e\n%#1\nB'\u0005\u001fBQa\u001f\u001fA\u0002qDq!a\u001f=\u0001\u0004\ti\u0005C\u0004\u0002&r\u0002\r!!\u0014\t\u000f\tEC\b1\u0001\u0002N\u0005Q1m\u001c8gS\u001e4\u0015\u000e\\3\u0014\u000f\u001dq\u0015QTAP)\u0006)\u0001/\u0019;iA\u0005Y1/\u001b7l\u0007>tg-[4!)\u0019\t\u0019Ga\u0017\u0003^!1\u00111\u0010\u0007A\u0002IDQ!\u0019\u0007A\u0002\r$ra\u001cB1\u0005G\u0012)\u0007C\u0003|\u001b\u0001\u0007A\u0010C\u0004\u0002\u00105\u0001\r!!\u0005\t\u000f\u0005\u0015R\u00021\u0001\u0002(Q1\u00111\rB5\u0005WB\u0001\"a\u001f\u000f!\u0003\u0005\rA\u001d\u0005\bC:\u0001\n\u00111\u0001d+\t\u0011yGK\u0002d\u0003\u001f$B!!?\u0003t!I!\u0011A\n\u0002\u0002\u0003\u0007\u0011q\u001e\u000b\u0005\u0005/\u00119\bC\u0005\u0003\u0002U\t\t\u00111\u0001\u0002zR!\u00111\u000eB>\u0011%\u0011\tAFA\u0001\u0002\u0004\ty\u000f\u0006\u0003\u0003\u0018\t}\u0004\"\u0003B\u00013\u0005\u0005\t\u0019AA}\u0003)\u0019\u0016\u000e\\6T_V\u00148-\u001a")
public interface SilkSource
extends Serializable {
    public static SilkSource apply(SQLContext sqlContext, Option<String> path, Option<String> repository, Option<String> configFile) {
        return SilkSource$.MODULE$.apply(sqlContext, path, repository, configFile);
    }

    public Option<SilkConfig> silkConfig();

    public Seq<String> files(SQLContext var1, Filter[] var2, Seq<SilkField> var3);

    public static class Files
    implements SilkSource,
    Product {
        private final String path;
        private final Option<SilkConfig> silkConfig;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String path() {
            return this.path;
        }

        @Override
        public Option<SilkConfig> silkConfig() {
            return this.silkConfig;
        }

        @Override
        public Seq<String> files(SQLContext sqlContext, Filter[] filters, Seq<SilkField> fields) {
            return new .colon.colon((Object)this.path(), (List)Nil$.MODULE$);
        }

        public Files copy(String path, Option<SilkConfig> silkConfig) {
            return new Files(path, silkConfig);
        }

        public String copy$default$1() {
            return this.path();
        }

        public Option<SilkConfig> copy$default$2() {
            return this.silkConfig();
        }

        public String productPrefix() {
            return "Files";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.path();
                }
                case 1: {
                    return this.silkConfig();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Files;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "path";
                }
                case 1: {
                    return "silkConfig";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Files)) return false;
            boolean bl = true;
            if (!bl) return false;
            Files files = (Files)x$1;
            String string = this.path();
            String string2 = files.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<SilkConfig> option = this.silkConfig();
            Option<SilkConfig> option2 = files.silkConfig();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!files.canEqual(this)) return false;
            return true;
        }

        public Files(String path, Option<SilkConfig> silkConfig) {
            this.path = path;
            this.silkConfig = silkConfig;
            Product.$init$((Product)this);
        }
    }

    public static class Repository
    implements SilkSource,
    Product {
        private final String repository;
        private final SilkConfig requiredConfig;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String repository() {
            return this.repository;
        }

        public SilkConfig requiredConfig() {
            return this.requiredConfig;
        }

        @Override
        public Option<SilkConfig> silkConfig() {
            return new Some((Object)this.requiredConfig());
        }

        @Override
        public Seq<String> files(SQLContext sqlContext, Filter[] filters, Seq<SilkField> fields) {
            FileSystem fs = new Path(this.repository()).getFileSystem(sqlContext.sparkContext().hadoopConfiguration());
            Path candidatePath = new Path(this.repository(), this.requiredConfig().globAll());
            Map fieldMap = ((IterableOnceOps)fields.map((Function1 & Serializable)f -> new Tuple2((Object)f.name(), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            PathFilter pathFilter = new PathFilter(this, fieldMap, filters){
                private final /* synthetic */ Repository $outer;
                private final Map fieldMap$1;
                private final Filter[] filters$1;

                public boolean accept(Path p) {
                    Some some;
                    Tuple3 tuple3;
                    Option option = this.$outer.requiredConfig().filenameToGlobInfo(p.getName());
                    if (None$.MODULE$.equals(option)) {
                        return false;
                    }
                    if (option instanceof Some && (tuple3 = (Tuple3)(some = (Some)option).value()) != null) {
                        Instant hour = (Instant)tuple3._1();
                        byte flowTypeId = ((FlowType)tuple3._2()).toByte();
                        short sensorId = ((Sensor)tuple3._3()).toShort();
                        return new GlobInfo((Map<String, SilkField>)this.fieldMap$1, this.$outer.requiredConfig(), hour, flowTypeId, sensorId, p.toString()).checkFilters((Seq<Filter>)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])this.filters$1)));
                    }
                    throw new MatchError((Object)option);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fieldMap$1 = fieldMap$1;
                    this.filters$1 = filters$1;
                }
            };
            Seq fileStatuses = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])fs.globStatus(candidatePath, pathFilter)));
            return (Seq)fileStatuses.map((Function1 & Serializable)x$1 -> x$1.getPath().toString());
        }

        public Repository copy(String repository, SilkConfig requiredConfig) {
            return new Repository(repository, requiredConfig);
        }

        public String copy$default$1() {
            return this.repository();
        }

        public SilkConfig copy$default$2() {
            return this.requiredConfig();
        }

        public String productPrefix() {
            return "Repository";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.repository();
                }
                case 1: {
                    return this.requiredConfig();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Repository;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "repository";
                }
                case 1: {
                    return "requiredConfig";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Repository)) return false;
            boolean bl = true;
            if (!bl) return false;
            Repository repository = (Repository)x$1;
            String string = this.repository();
            String string2 = repository.repository();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            SilkConfig silkConfig = this.requiredConfig();
            SilkConfig silkConfig2 = repository.requiredConfig();
            if (silkConfig == null) {
                if (silkConfig2 != null) {
                    return false;
                }
            } else if (!silkConfig.equals(silkConfig2)) return false;
            if (!repository.canEqual(this)) return false;
            return true;
        }

        public Repository(String repository, SilkConfig requiredConfig) {
            this.repository = repository;
            this.requiredConfig = requiredConfig;
            Product.$init$((Product)this);
        }
    }
}

