/*
 * Decompiled with CFR 0.152.
 */
package org.cert.netsa.mothra.packer;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.cert.netsa.mothra.packer.CorePacker;
import org.cert.netsa.mothra.packer.PackFileJob$;
import resource.Resource$;
import resource.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005]g!\u0002\u0012$\u0001\u0016j\u0003\u0002\u0003+\u0001\u0005+\u0007I\u0011\u0001,\t\u0011\u0005\u0004!\u0011#Q\u0001\n]C\u0001\u0002\n\u0001\u0003\u0016\u0004%\tA\u0019\u0005\tO\u0002\u0011\t\u0012)A\u0005G\"A\u0001\u000e\u0001B\u0001B\u0003-\u0011\u000eC\u0003o\u0001\u0011\u0005q\u000e\u0003\u0004v\u0001\u0001\u0006IA\u001e\u0005\u0007s\u0002\u0001\u000b\u0015\u0002<\t\ri\u0004\u0001\u0015)\u0003|\u0011!\t)\u0001\u0001Q\u0001\n\u0005\u001d\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\f\u0003C\u0001\u0001\u0019!A!B\u0013\t\u0019\u0003C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u0011Q\b\u0001\u0005\u0002\u0005}\u0002\"CA!\u0001\u0005\u0005I\u0011AA\"\u0011%\ti\u0005AI\u0001\n\u0003\ty\u0005C\u0005\u0002f\u0001\t\n\u0011\"\u0001\u0002h!I\u00111\u000e\u0001\u0002\u0002\u0013\u0005\u0013Q\u000e\u0005\n\u0003k\u0002\u0011\u0011!C\u0001\u0003?A\u0011\"a\u001e\u0001\u0003\u0003%\t!!\u001f\t\u0013\u0005\u0015\u0005!!A\u0005B\u0005\u001d\u0005\"CAK\u0001\u0005\u0005I\u0011AAL\u0011%\tY\nAA\u0001\n\u0003\ni\nC\u0005\u0002 \u0002\t\t\u0011\"\u0011\u0002\"\"I\u00111\u0015\u0001\u0002\u0002\u0013\u0005\u0013QU\u0004\u000b\u0003S\u001b\u0013\u0011!E\u0001K\u0005-f!\u0003\u0012$\u0003\u0003E\t!JAW\u0011\u0019qG\u0004\"\u0001\u00026\"I\u0011q\u0014\u000f\u0002\u0002\u0013\u0015\u0013\u0011\u0015\u0005\n\u0003oc\u0012\u0011!CA\u0003sC\u0011\"a1\u001d\u0003\u0003%\t)!2\t\u0013\u0005MG$!A\u0005\n\u0005U'a\u0003)bG.4\u0015\u000e\\3K_\nT!\u0001J\u0013\u0002\rA\f7m[3s\u0015\t1s%\u0001\u0004n_RD'/\u0019\u0006\u0003Q%\nQA\\3ug\u0006T!AK\u0016\u0002\t\r,'\u000f\u001e\u0006\u0002Y\u0005\u0019qN]4\u0014\r\u0001qc\u0007\u0012(R!\tyC'D\u00011\u0015\t\t$'\u0001\u0003mC:<'\"A\u001a\u0002\t)\fg/Y\u0005\u0003kA\u0012aa\u00142kK\u000e$\bcA\u001c=}5\t\u0001H\u0003\u0002:u\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005m\u0012\u0014\u0001B;uS2L!!\u0010\u001d\u0003\u0011\r\u000bG\u000e\\1cY\u0016\u0004\"a\u0010\"\u000e\u0003\u0001S\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0002\u0013qAQ8pY\u0016\fg\u000e\u0005\u0002F\u00196\taI\u0003\u0002H\u0011\u0006a1oY1mC2|wmZ5oO*\u0011\u0011JS\u0001\tif\u0004Xm]1gK*\t1*A\u0002d_6L!!\u0014$\u0003\u001bM#(/[2u\u0019><w-\u001b8h!\tyt*\u0003\u0002Q\u0001\n9\u0001K]8ek\u000e$\bCA S\u0013\t\u0019\u0006I\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0006t_V\u00148-\u001a)bi\"\u001c\u0001!F\u0001X!\tAv,D\u0001Z\u0015\tQ6,\u0001\u0002gg*\u0011A,X\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005y[\u0013AB1qC\u000eDW-\u0003\u0002a3\n!\u0001+\u0019;i\u0003-\u0019x.\u001e:dKB\u000bG\u000f\u001b\u0011\u0016\u0003\r\u0004\"\u0001Z3\u000e\u0003\rJ!AZ\u0012\u0003\u0015\r{'/\u001a)bG.,'/A\u0004qC\u000e\\WM\u001d\u0011\u0002\t\r|gN\u001a\t\u0003U2l\u0011a\u001b\u0006\u0003QnK!!\\6\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u0019\u0001o\u001d;\u0015\u0005E\u0014\bC\u00013\u0001\u0011\u0015Ag\u0001q\u0001j\u0011\u0015!f\u00011\u0001X\u0011\u0015!c\u00011\u0001d\u0003\u001d!8I]3bi\u0016\u0004\"aP<\n\u0005a\u0004%\u0001\u0002'p]\u001e\fa\u0001^*uCJ$\u0018!B2pk:$\bCA }\u0013\ti\bIA\u0002J]RD#!C@\u0011\u0007}\n\t!C\u0002\u0002\u0004\u0001\u0013\u0001B^8mCRLG.Z\u0001\u0006G>$Wm\u0019\t\u0006\u007f\u0005%\u0011QB\u0005\u0004\u0003\u0017\u0001%AB(qi&|g\u000e\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0011\r|W\u000e\u001d:fgNT1!a\u0006\\\u0003\tIw.\u0003\u0003\u0002\u001c\u0005E!\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0003!\u0011XO\\\"pk:$X#A>\u0002\u000f}\u0013Xm];miB!q'!\n?\u0013\r\t9\u0003\u000f\u0002\u0007\rV$XO]3)\u00051y\u0018\u0001C:vE6LG\u000fV8\u0015\u0007E\fy\u0003C\u0004\u000225\u0001\r!a\r\u0002\tA|w\u000e\u001c\t\u0004o\u0005U\u0012bAA\u001cq\t\u0011B\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u0003\u0019\u0011Xm];miV\u0011\u00111E\u0001\u0005G\u0006dG\u000eF\u0001?\u0003\u0011\u0019w\u000e]=\u0015\r\u0005\u0015\u0013\u0011JA&)\r\t\u0018q\t\u0005\u0006QB\u0001\u001d!\u001b\u0005\b)B\u0001\n\u00111\u0001X\u0011\u001d!\u0003\u0003%AA\u0002\r\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002R)\u001aq+a\u0015,\u0005\u0005U\u0003\u0003BA,\u0003Cj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0018A\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\nIFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002j)\u001a1-a\u0015\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0007E\u00020\u0003cJ1!a\u001d1\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA>\u0003\u0003\u00032aPA?\u0013\r\ty\b\u0011\u0002\u0004\u0003:L\b\u0002CAB+\u0005\u0005\t\u0019A>\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\t\u0005\u0004\u0002\f\u0006E\u00151P\u0007\u0003\u0003\u001bS1!a$A\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003'\u000biI\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001 \u0002\u001a\"I\u00111Q\f\u0002\u0002\u0003\u0007\u00111P\u0001\tQ\u0006\u001c\bnQ8eKR\t10\u0001\u0005u_N#(/\u001b8h)\t\ty'\u0001\u0004fcV\fGn\u001d\u000b\u0004}\u0005\u001d\u0006\"CAB5\u0005\u0005\t\u0019AA>\u0003-\u0001\u0016mY6GS2,'j\u001c2\u0011\u0005\u0011d2\u0003\u0002\u000f\u00020F\u00032aPAY\u0013\r\t\u0019\f\u0011\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005-\u0016!B1qa2LHCBA^\u0003\u007f\u000b\t\rF\u0002r\u0003{CQ\u0001[\u0010A\u0004%DQ\u0001V\u0010A\u0002]CQ\u0001J\u0010A\u0002\r\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002H\u0006=\u0007#B \u0002\n\u0005%\u0007#B \u0002L^\u001b\u0017bAAg\u0001\n1A+\u001e9mKJB\u0001\"!5!\u0003\u0003\u0005\r!]\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012A\f")
public class PackFileJob
implements Callable<Object>,
StrictLogging,
Product,
scala.Serializable {
    private final Path sourcePath;
    private final CorePacker packer;
    private final Configuration conf;
    private final long tCreate;
    private long tStart;
    private volatile int count;
    private final Option<CompressionCodec> codec;
    private volatile Future<Object> _result;
    private final Logger logger;

    public static Option<Tuple2<Path, CorePacker>> unapply(PackFileJob packFileJob) {
        return PackFileJob$.MODULE$.unapply(packFileJob);
    }

    public static PackFileJob apply(Path path, CorePacker corePacker, Configuration configuration) {
        return PackFileJob$.MODULE$.apply(path, corePacker, configuration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Path sourcePath() {
        return this.sourcePath;
    }

    public CorePacker packer() {
        return this.packer;
    }

    public synchronized int runCount() {
        return this.count;
    }

    public PackFileJob submitTo(ThreadPoolExecutor pool) {
        this._result = pool.submit(this);
        return this;
    }

    public Future<Object> result() {
        return this._result;
    }

    @Override
    public boolean call() {
        BoxedUnit boxedUnit;
        boolean bl;
        BoxedUnit boxedUnit2;
        this.tStart = System.currentTimeMillis();
        ++this.count;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Attempting to pack '{}', try #{}", new Object[]{this.sourcePath(), BoxesRunTime.boxToInteger((int)this.count)});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        LongRef fileSize = LongRef.create((long)0L);
        Option decompr = this.codec.map((Function1 & Serializable & scala.Serializable)c -> CodecPool.getDecompressor((CompressionCodec)c));
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            FileSystem sourceFs = this.sourcePath().getFileSystem($this.conf);
            fileSize$1.elem = BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> sourceFs.getFileStatus(this.sourcePath()).getLen()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> {
                ReadableByteChannel readableByteChannel;
                FSDataInputStream stream = sourceFs.open(this.sourcePath());
                Option<CompressionCodec> option = $this.codec;
                if (None$.MODULE$.equals(option)) {
                    readableByteChannel = Channels.newChannel((InputStream)stream);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    CompressionCodec c = (CompressionCodec)some.value();
                    readableByteChannel = Channels.newChannel((InputStream)c.createInputStream((InputStream)stream, (Decompressor)decompr.get()));
                } else {
                    throw new MatchError(option);
                }
                return readableByteChannel;
            }, Resource$.MODULE$.closeableResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(ReadableByteChannel.class)).foreach((Function1 & Serializable & scala.Serializable)channel -> {
                PackFileJob.$anonfun$call$6(this, channel);
                return BoxedUnit.UNIT;
            });
            return sourceFs.delete(this.sourcePath(), false);
        });
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Failed to pack '{}': {}", new Object[]{this.sourcePath(), e.toString()});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(32).append("Failed to pack '").append(this.sourcePath()).append("' on attempt #").append(this.count).append(":").append(" ").append(sw.toString()).toString());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            bl = false;
        } else {
            bl = true;
        }
        boolean succeeded = bl;
        decompr.foreach((Function1 & Serializable & scala.Serializable)d -> {
            PackFileJob.$anonfun$call$7(d);
            return BoxedUnit.UNIT;
        });
        if (succeeded) {
            String humanSize;
            String string;
            long tEnd = System.currentTimeMillis();
            if (fileSize.elem <= 0L) {
                string = "unknown";
            } else {
                String[] units = (String[])((Object[])new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"});
                double s = fileSize.elem;
                int u = 0;
                while (s > 1024.0) {
                    s /= 1024.0;
                    ++u;
                }
                double arg$macro$1 = s;
                String arg$macro$2 = units[u];
                string = humanSize = new StringOps("%.3f%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1), arg$macro$2}));
            }
            if (this.logger().underlying().isInfoEnabled()) {
                double arg$macro$3 = (double)(this.tStart - this.tCreate) / 1000.0;
                double arg$macro$4 = (double)(tEnd - this.tStart) / 1000.0;
                this.logger().underlying().info(new StringBuilder(17).append("Packed '").append(this.sourcePath()).append("'; size ").append(humanSize).append(";").append(new StringOps(" waited %.3f seconds;").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}))).append(new StringOps(" worked %.3f seconds").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$4)}))).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return succeeded;
    }

    public PackFileJob copy(Path sourcePath, CorePacker packer, Configuration conf) {
        return new PackFileJob(sourcePath, packer, conf);
    }

    public Path copy$default$1() {
        return this.sourcePath();
    }

    public CorePacker copy$default$2() {
        return this.packer();
    }

    public String productPrefix() {
        return "PackFileJob";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.sourcePath();
                break;
            }
            case 1: {
                object = this.packer();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PackFileJob;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PackFileJob)) return false;
        boolean bl = true;
        if (!bl) return false;
        PackFileJob packFileJob = (PackFileJob)x$1;
        Path path = this.sourcePath();
        Path path2 = packFileJob.sourcePath();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!path.equals(path2)) return false;
        CorePacker corePacker = this.packer();
        CorePacker corePacker2 = packFileJob.packer();
        if (corePacker == null) {
            if (corePacker2 != null) {
                return false;
            }
        } else if (!((Object)corePacker).equals(corePacker2)) return false;
        if (!packFileJob.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$call$6(PackFileJob $this, ReadableByteChannel channel) {
        $this.packer().packStream(channel);
    }

    public static final /* synthetic */ void $anonfun$call$7(Decompressor d) {
        CodecPool.returnDecompressor((Decompressor)d);
    }

    public PackFileJob(Path sourcePath, CorePacker packer, Configuration conf) {
        this.sourcePath = sourcePath;
        this.packer = packer;
        this.conf = conf;
        StrictLogging.$init$((StrictLogging)this);
        Product.$init$((Product)this);
        this.tCreate = System.currentTimeMillis();
        this.tStart = 0L;
        this.count = 0;
        this.codec = (Option)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            CompressionCodecFactory factory = new CompressionCodecFactory($this.conf);
            return Option$.MODULE$.apply((Object)factory.getCodec(this.sourcePath()));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
    }
}

